// resize script by Dora Gustafson, Studio Dora 2010
// Free for anybody to read, copy, modify, compile, use, rip apart, trample on and flush
// The script is open source and free. As so it is not supported in any way
// NOTE: only for SL server v1.38 and later
// Place in prim or linkset in order to resize
// Must run in root prim
// resizer v1.0 No check or precautions against dimensions out of limits
// resizer v1.1 Test if new dimensions are within limts [0.01;10.0]m If not, resize is cancelled
// resizer v1.2 Added kill script button
// resizer v1.3 Added llListenRemove() for low lag
// resizer v1.4 Added Current relative size display
// resizer v1.5 Added rounding for size display
// resizer v1.6 Reversible resize increments
// resizer v1.7 changed to accept 64m max prim size, limits [0.01;64.0]
// resizer v1.8 changed v1.7 to accept 640 max prim size, limits (0.0001; 640.0)

integer dialogChanal;
list USER_MENU = [ "Size@Rez", "Size@Buy", "Kill Script", "-1.96..%", "-4.76..%", "-9.09..%", "+2%", "+5%", "+10%" ];
string uDialogP = "•Resize\n•Set to Size at Rez\n•Set to Size at Buy";

float fabsizeX;
float rezsizeX;
vector rs;
float listenTimeout=1800.0; // seconds
integer listenHandle;

open_dialog( vector vr )
{
    string s="Size is "+(string)(llRound(100.0*vr.x/fabsizeX))+" %\n";
    llDialog( llGetOwner(), s+uDialogP, USER_MENU, dialogChanal);
    llSetTimerEvent(listenTimeout);
}

integer dimTest( vector vr )
{
    return !( vr.x<0.0001 || vr.y<0.0001 || vr.z<0.0001 || vr.x>640.0 || vr.y>640.0 || vr.z>640.0 );
}

primloop( float scal )
{
    integer primindx;
    integer validDim=TRUE;
    list primP;

    if (llGetNumberOfPrims()<2) validDim = validDim && dimTest( scal*llGetScale());
    else
    for ( primindx = 1; primindx <= llGetNumberOfPrims(); primindx++ )
    {
        primP = llGetLinkPrimitiveParams( primindx, [PRIM_SIZE]);
        validDim = validDim && dimTest( scal*llList2Vector( primP, 0 ));
    }

    if ( validDim )
    {
        if (llGetNumberOfPrims()<2) llSetScale( scal*llGetScale()); // not linked prim
        else
        for ( primindx = 1; primindx <= llGetNumberOfPrims(); primindx++ )
        {
            primP = llGetLinkPrimitiveParams( primindx, [PRIM_SIZE, PRIM_POSITION]);
            vector primScale = scal*llList2Vector( primP, 0 );
            vector primPos = scal*(llList2Vector( primP, 1 )-llGetPos());
            if ( primindx == 1 ) llSetLinkPrimitiveParamsFast( primindx, [PRIM_SIZE, primScale]);
            else llSetLinkPrimitiveParamsFast( primindx, [PRIM_SIZE, primScale, PRIM_POSITION, primPos/llGetRootRotation()]);
        }
    }
    else llOwnerSay("No resize! Out of limit sizes are not accepted");
}

default
{
    state_entry()
    {
        rs = llGetScale();
        fabsizeX = rs.x;
        rezsizeX = fabsizeX;
        llOwnerSay("Size at buy is set to Current size");
    }
    on_rez( integer p)
    {
        rs = llGetScale();
        rezsizeX = rs.x;
    }
    touch_end(integer n)
    {
        if (llDetectedKey(0) == llGetOwner())
        {
            dialogChanal = (integer)llFrand( 8388608.0 ) + 0x80000000;
            llListenRemove(listenHandle);
            listenHandle = llListen( dialogChanal, "", llGetOwner(), "");
            open_dialog(llGetScale());
        }
    }
    listen(integer cannel, string name, key id, string message)
    {
        if ( message == "Kill Script" ) llRemoveInventory( llGetScriptName());
        else
        {
            rs = llGetScale();
            if ( message == "+2%" ) primloop( 1.02);
            else if ( message == "+5%" ) primloop( 1.05);
            else if ( message == "+10%" ) primloop( 1.1);
            else if ( message == "-1.96..%" ) primloop( 1.0/1.02);
            else if ( message == "-4.76..%" ) primloop( 1.0/1.05);
            else if ( message == "-9.09..%" ) primloop( 1.0/1.1);
            else if ( message == "Size@Rez" ) primloop( rezsizeX/rs.x);
            else if ( message == "Size@Buy" ) primloop( fabsizeX/rs.x);
            open_dialog(llGetScale());
        }
    }
    timer()
    {
        llListenRemove(listenHandle);
        llSetTimerEvent(0.0);
    }
}