
//Tonto Zerbino added modifications 2/09

// LightPoleLight.lsl
// 28 august 2007
// Author: Hans541 Tomsen

// PRODUCED BY:
// (c) 2007 Logic
// Logic Scripted Products and Script Services
// Owner: Flennan Roffo

// VERSION:
// Version: 1.0

// LICENCE:
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.

// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
// (Also available at http://www.gnu.org/copyleft/gpl.html) 

// DESCRIPTION:
// Sets the light of a light pole ON or OFF. 
// Touching the light pole will toggle between ON and OFF.
// Takes into account the SunDirection and will go ON at night and OFF when day.
// Additionally you can tweak the values for SunFullValue and SunDarkValue (the Z coordinate of Sun direction)
// to create a DIM period, during which the light pole is less bright/dimmed.
// LightColor and LightIntensity are changeable values. 

// INSTALLION:
// Place this script in the prim that emits the light. You can have several light emitting prims within the
// same linkset. Each light emitting prim needs this script.
// Place the LightPoleTouch script in the ROOT prim of the linkset.
// (in case there is only one prim, place both scripts in the same prim).
// Note: if the light emitting prim and the prim in which the touch script is put are not in the
// same linkset, this will not work.

// FUTURE ENHANCEMENTS:
// 1) The 'tweakable' parameters (LigthColor, LightIntensity, LightRadius and LightFalloff
//    and also SunFullValue and SunDarkValue) can be read from a notecard.
// 2) A slow instead of abrubt intensity change for the light when the sun goes down.
// 3) Particle effects?

///////////////////// EDITABLE VALUES (can be changed) \\\\\\\\\\\\\\\\\\\\\\\

float SunFullValue         = 0.0;                 // Above this value DayLight is DAYLIGHT_FULL 
float SunDarkValue         = -0.2;                // Below this value DayLight is DAYLIGHT_DARK
                                                  // Between SunDarkValue and SunFullValue DayLight is DAYLIGHT_DIM

float CheckDayLightInterval = 150.0;        // Time interval to check for Daylight in seconds
vector LightColor     = <1.0,1.0,1.0>;      // Color of the light (RGB - each value between 0.0 and 1.0)
float  LightIntensity = 1.0;                // Intensity of the light (values from 0.0 .. 1.0)
float  LightRadius    = 10.0;               // Radius of light cone
float  LightFalloff   = 0.75;               // Fall off (distance/intensity decrease) values from 0.0 ..1.0

////////////////// NON EDITABLE VALUES  (Don't touch) \\\\\\\\\\\\\\\\\\\\\\\\\\\\

integer LIGHT_ON               = TRUE;
integer LIGHT_OFF           = FALSE;
integer LightStatus         = LIGHT_OFF;

integer DAYLIGHT_DARK       = 0;
integer DAYLIGHT_DIM        = 1;
integer DAYLIGHT_FULL       = 2;

integer DayLight            = DAYLIGHT_FULL;
float   DimFactor           = 0.5;
integer LM_TOUCH            = 193356;
////////////////////////////////////////// DayLight() ////////////////////////////////

integer GetDayLight()
{
    vector SunDirection = llGetSunDirection();

    if (SunDirection.z > SunFullValue)
        return DAYLIGHT_FULL;
    else if (SunDirection.z < SunDarkValue)
        return DAYLIGHT_DARK;
    else
        return DAYLIGHT_DIM;
}

/////////////////////////////////// LightOn() /////////////////////////////////////////

LightOn(float dimfactor)
{
    // code for light on
    
    llSetPrimitiveParams( 
    [ PRIM_POINT_LIGHT, TRUE, LightColor, dimfactor * LightIntensity, LightRadius, LightFalloff ] 
    );
    llSetAlpha(0.29, ALL_SIDES);                    // added, TZ
    llMessageLinked(LINK_SET, -1, "on", NULL_KEY);  // added, TZ  send to bulb prim to toggle full bright  

    LightStatus = LIGHT_ON;
}

///////////////////////////////////// LightOff() /////////////////////////////////////////

LightOff()
{
    // code for light off
    
    llSetPrimitiveParams( 
    [ PRIM_POINT_LIGHT, FALSE, <0.0,0.0,0.0>, 0.0, 0.0, 0.0 ] 
    );
    llSetAlpha(0.0, ALL_SIDES);                    // added, TZ
    llMessageLinked(LINK_SET, -1, "off", NULL_KEY);  // added, TZ  send to bulb prim to toggle full bright  

    LightStatus = LIGHT_OFF;
}

//////////////////////////////////////// ToggleLight() //////////////////////////////////

ToggleLight()
{
    if (LightStatus == LIGHT_ON)
    {
        LightOff();
    }
    else
    {
        LightOn(1.0);
    }
}

//////////////////////////// CheckDayLight() /////////////////////////////////

CheckDayLight()
{
    integer daylight = GetDayLight();
        
    if (daylight != DayLight)
    {
        if (daylight == DAYLIGHT_FULL)
        {
            DayLight = DAYLIGHT_FULL;
            LightOff();
        }
        else if (daylight == DAYLIGHT_DARK)
        {
            DayLight = DAYLIGHT_DARK;
            LightOn(1.0);
        }
        else // Dim
        {
            DayLight = DAYLIGHT_DIM;
            LightOn(DimFactor);
        }
    }
}
//////////////////////////////////////////////////////////////////////////////
// state default
//////////////////////////////////////////////////////////////////////////////

default
{
    //////////////////////////////////////////////////////////////////////////
    
    state_entry()
    {
        CheckDayLight();
        llSetTimerEvent(CheckDayLightInterval);
    }
    
    //////////////////////////////////////////////////////////////////////////
    
    timer()
    {
        CheckDayLight();
    }
    
    //////////////////////////////////////////////////////////////////////////
    
    link_message(integer sender, integer msgid, string message, key id)
    {
        if (msgid == LM_TOUCH)
        {
            ToggleLight();
        }
    }
}

//////////////////////////////////////////////////////////////////////////////
// End LightPoleLight.lsl
//////////////////////////////////////////////////////////////////////////////