float interval = 5.0;
vector defaultsit = <0, 0, 0.01>;
integer prims;
vector agentpos;
integer numragents;
key agent;
integer lastnumagents;
list agents;
list ragents;
list ragentposs;
float seconds;
float lastms;
float ms;
float diff;
string time;

list sits = [
    <-8.98493, 3.77486, 1.40910>, <0.00000, 0.00000, 0.15643, -0.98769>,
    <-8.98493, 5.63763, 1.40910>, <0.00000, 0.00000, 0.15643, -0.98769>,
    <-8.98493, -3.54469, 1.40910>, <0.00000, 0.00000, 0.15643, -0.98769>,
    <-8.98493, -5.32617, 1.40910>, <0.00000, 0.00000, 0.15643, -0.98769>,
    <-5.85863, -5.03409, 1.40910>, <0.00000, 0.00000, 0.15643, -0.98769>,
    <-5.85863, -3.66602, 1.40910>, <0.00000, 0.00000, 0.15643, -0.98769>,
    <-5.85863, 3.82877, 1.40910>, <0.00000, 0.00000, 0.15643, -0.98769>,
    <-5.85863, 5.35677, 1.40910>, <0.00000, 0.00000, 0.15643, -0.98769>,
    <-6.62076, 5.18825, 1.40910>, <0.00000, 0.00000, 0.99985, 0.01746>,
    <-6.62076, 3.95309, 1.40910>, <0.00000, 0.00000, 0.99985, 0.01746>,
    <-6.62076, -3.65269, 1.40910>, <0.00000, 0.00000, 0.99985, 0.01746>,
    <-6.62076, -5.30023, 1.40910>, <0.00000, 0.00000, 0.99985, 0.01746>,
    <-3.60726, -5.30023, 1.40910>, <0.00000, 0.00000, 0.99985, 0.01746>,
    <-3.60726, -3.79665, 1.40910>, <0.00000, 0.00000, 0.99985, 0.01746>,
    <-3.60726, 3.83554, 1.40910>, <0.00000, 0.00000, 0.99985, 0.01746>,
    <-3.60726, 5.21669, 1.40910>, <0.00000, 0.00000, 0.99985, 0.01746>,
    <-1.77218, 3.98148, 1.40910>, <0.00000, 0.00000, 0.00874, -0.99996>,
    <-1.77218, 2.77682, 1.40910>, <0.00000, 0.00000, 0.00874, -0.99996>,
    <-1.77218, -2.78596, 1.40910>, <0.00000, 0.00000, 0.00874, -0.99996>,
    <-1.77218, -4.02191, 1.40910>, <0.00000, 0.00000, 0.00874, -0.99996>,
    <1.30920, -2.93988, 1.40910>, <0.00000, 0.00000, 0.00874, -0.99996>,
    <1.30920, 2.96205, 1.40910>, <0.00000, 0.00000, 0.00874, -0.99996>,
    <1.30920, 3.97966, 1.40910>, <0.00000, 0.00000, 0.00874, -0.99996>,
    <3.59908, 3.97966, 1.40910>, <0.00000, -0.00000, 0.99966, 0.02616>,
    <3.64837, 2.90227, 1.40910>, <0.00000, -0.00000, 0.99966, 0.02616>,
    <3.64837, -2.75267, 1.40910>, <0.00000, -0.00000, 0.99966, 0.02616>,
    <3.64837, -3.77489, 1.40910>, <0.00000, -0.00000, 0.99966, 0.02616>,
    <0.54892, -3.90903, 1.40910>, <0.00000, -0.00000, 0.99966, 0.02616>,
    <0.54892, -2.79231, 1.40910>, <0.00000, -0.00000, 0.99966, 0.02616>,
    <0.54892, 2.84718, 1.40910>, <0.00000, -0.00000, 0.99966, 0.02616>,
    <0.54892, 4.00003, 1.40910>, <0.00000, -0.00000, 0.99966, 0.02616>,
    <5.13273, 2.29994, 2.31362>, <0.00000, -0.00000, 0.99966, 0.02616>,
    <5.13273, -2.53883, 3.05141>, <0.00000, -0.00000, 0.99966, 0.02616>,
    <2.78778, -0.71678, 16.65500>, <0.00000, -0.00000, 0.99966, 0.02616>,
    
    //missing targets added
    <1.29071, -4.05350, 1.40450>, <0.00000, -0.00000, 0.00000, 1.00000>];

integer debug;

findparts()
{
    integer i;
    for(i = 2; i < llGetNumberOfPrims() + 1; i++)
    {
        string name = llGetLinkName(i);
        if(name == "debug")
            debug = i;
    }
}

updatesit(vector p, rotation r)
{
    //llSitTarget(p, r);
    llSitTarget(defaultsit, ZERO_ROTATION);
    //llOwnerSay((string)p + ", " + (string)r);
    
    if(agent)
    {
        vector size = llGetAgentSize(agent);
        if(size != ZERO_VECTOR){             // OpenSim fix
            rotation localrot = ZERO_ROTATION;
            vector localpos = ZERO_VECTOR;
            p.z += 0.4;
            integer linkNum = llGetNumberOfPrims();
            do{
                if(agent == llGetLinkKey(linkNum))
                {
                    vector newpos = ((p - (llRot2Up(r) * size.z * 0.02638)) * localrot) + localpos;
                    rotation newrot = r * localrot / llGetRootRotation();
                    llSetLinkPrimitiveParamsFast(linkNum, [PRIM_POSITION, newpos, PRIM_ROTATION, newrot]);
                    return;
                }
            }while( --linkNum );
        }
        else
        {
            llUnSit(agent);
        }
    }
}
 
integer overlapped(vector pos)
{
    vector testpos;
    key id;
    vector idpos;
    integer isoverlapped = FALSE;
    integer i;
    for(i = 0; i < llGetListLength(agents); i++)
    {
        id = llList2Key(agents, i);
        idpos = llList2Vector(llGetObjectDetails(id, [OBJECT_POS]), 0);
        testpos = (idpos - llGetPos())/llGetRot();
        if(llVecDist(testpos, pos) < 0.5)
        {
            //text((string)pos + "\n" + (string)testpos);
            isoverlapped = TRUE;
            return isoverlapped;
        }
    }
    return isoverlapped;
}
   
closestseat(vector pos)
{
    vector sitpos = (pos - llGetPos())/llGetRot();
    float dist = 1024.0;
    float testdist;
    vector testpos;
    integer sitindex;
    
    integer i;
    for(i = 0; i < llGetListLength(sits)/2; i++)
    {
        testpos = llList2Vector(sits, i*2);
        testdist = llVecDist(testpos, sitpos);
        if(!overlapped(testpos))
        {
            if(testdist < dist)
            {
                dist = testdist;
                sitindex = i;
            }
        }
    }
    
    if(dist == 1024.0)
        llUnSit(agent);//no open chairs found
    else
        updatesit(llList2Vector(sits, sitindex*2), llList2Rot(sits, sitindex*2 + 1));
    
    //text((string)sitpos);
}

getagents()
{
    key id;
    list params;
    integer mat;
    integer newprims = llGetNumberOfPrims();
    
    agents = [];    
    integer i;
    for(i = 2; i < newprims + 1; i++)
    {
        id = llGetLinkKey(i);
        params = llGetLinkPrimitiveParams(i, [PRIM_MATERIAL, PRIM_POS_LOCAL]);
        mat = llList2Integer(params, 0);
        if(mat == PRIM_MATERIAL_FLESH)
            agents += id;
    }
}

getragents()
{
    ragentposs = [];
    ragents = llGetAgentList(AGENT_LIST_REGION, []);
    numragents = llGetListLength(ragents);
    integer i;
    for(i = 0; i < numragents; i++)
    {
        ragentposs += llList2Vector(llGetObjectDetails(llList2Key(ragents, i), [OBJECT_POS]), 0);
    }
}

text(string msg)
{
    llSetLinkPrimitiveParamsFast(debug, [PRIM_TEXT, msg, <1, 1, 1>, 1]);
}

default
{
    state_entry()
    {
        findparts();
        text("");
        llSitTarget(defaultsit, ZERO_ROTATION);
        getagents();
        prims = llGetNumberOfPrims() - llGetListLength(agents);
        //text((string)prims);
        getragents();
        llSetTimerEvent(interval);
    }

    on_rez(integer start_param)
    {
        llResetScript();
    }
    
    touch_start(integer total_number)
    {
        vector touchpos = llDetectedTouchPos(0);
        //llOwnerSay((string)touchpos);
        key id = llDetectedKey(0);
        
        getagents();
        
        if(llListFindList(agents, [id]) != -1)
        {
            agent = id;
            closestseat(touchpos);
        }
    }
    
    timer()
    {
        getragents();
/*        
        seconds = llGetWallclock();
        time = llGetTimestamp();
        lastms = ms;
        ms = seconds + (float)llGetSubString(time,  -8, llStringLength(time) - 1);
        diff = ms - lastms;
        if(diff < -86000.0)
        {
            diff += 86400.0;
        }        
        text((string)diff);
*/
    }
    
    changed(integer change) 
    {
        if(change & CHANGED_LINK)
        {
            list params;
            integer mat;
            key id;
            
            integer newprims = llGetNumberOfPrims();
            //text((string)newprims);
            
            if(newprims <= prims)
                llResetScript();
            
            lastnumagents = llGetListLength(agents);
            getagents();
            if(llGetListLength(agents) < lastnumagents)
                return;
                
            agent = llList2Key(agents, -1);
            integer ragentindex = llListFindList(ragents, [agent]);
            if(ragentindex != -1)
                agentpos = llList2Vector(ragentposs, ragentindex);
            else
                agentpos = llList2Vector(llGetLinkPrimitiveParams(newprims, [PRIM_POS_LOCAL]), 0);
            
            llRequestPermissions(agent, PERMISSION_TRIGGER_ANIMATION);
        }
    }
    
    run_time_permissions(integer perm) 
    {
        llStopAnimation("sit");
        llStopAnimation("sit_generic");
        llStopAnimation("sit_female");
        llStartAnimation("sit_ground");
        closestseat(agentpos);
    }
}
