
//The name of the folder to give to the user.
string gFolder = "Hobo-Yukata-Kimono Collection";

//Message which will be sent by IM to user.
string gMessage = "";

//___________ Do NOT edit below here _________

list gInventoryList = [];
fBuildList()
{
    gInventoryList = [];
    integer Num = llGetInventoryNumber(INVENTORY_ALL);
    if(Num > 0)
    {
        string Name;
        integer i;
        for(i=0;i<Num;i++)
        {
            Name = llGetInventoryName(INVENTORY_ALL, i);
            if(Name != llGetScriptName())
                gInventoryList += Name;
        }
    }
}

default
{
    state_entry()
    {
        fBuildList();
    }
    
    touch_start(integer num_detected)
    {
        if(llStringTrim(gMessage, STRING_TRIM) != "")
            llInstantMessage(llDetectedKey(0), gMessage);
            
            
        if(llGetListLength(gInventoryList) > 0)
            llGiveInventoryList(llDetectedKey(0), gFolder, gInventoryList);
    }
    
    changed(integer change)
    {
        if(change & CHANGED_INVENTORY)
        {
            fBuildList();
        }
    }   
    
    on_rez(integer start_param)
    {
        llResetScript();    
    }   
} 