// Handy's doors plugin - Auto Close v1.0 export

string NOTECARD_README        = "Handy's doors READ ME" ;
string SCRIPT_SETUP        = "Handy's doors setup" ;

//integer PLUGIN_DOOR_SEND_OPEN_ALL        = 715001 ;
//integer PLUGIN_DOOR_SEND_CLOSE_ALL        = 715002 ;
//integer PLUGIN_DOOR_SEND_OPEN_ONE        = 715003 ;
integer PLUGIN_DOOR_SEND_CLOSE_ONE        = 715004 ;
integer PLUGIN_DOOR_RECV_OPEN            = 715005 ;
integer PLUGIN_DOOR_RECV_CLOSE            = 715006 ;
//integer PLUGIN_DOOR_RECV_TRYING            = 715007 ;
//integer PLUGIN_DOOR_SEND_LOCK            = 715010 ;
//integer PLUGIN_DOOR_SEND_UNLOCK            = 715011 ;
integer PLUGIN_DOOR_SEND_LIST_DOORS        = 715020 ;
integer PLUGIN_DOOR_RECV_LIST_DOORS        = 715021 ;
integer PLUGIN_DOOR_SEND_MENU_BUTTON    = 715100 ;
integer PLUGIN_DOOR_RECV_MENU_BUTTON    = 715101 ;
integer PLUGIN_DOOR_SEND_MENU_FINISH    = 715102 ;
integer PLUGIN_DOOR_BOOTING                = 715200 ;
integer PLUGIN_DOOR_BOOTED                = 715201 ;
//
// Parallel lists
list IDs ;
list ClosingTimes ;

list DoorList ;

integer AutoCloseOn = TRUE ;
integer Time ;
integer IsOpen ;
integer MENU_CHANNEL = -129201871 ;
string MENU_MAIN = "Auto close" ;
integer MenuUp = FALSE ;
integer MenuListen ;
key OwnerID ;

SetTimer()
{
    if (AutoCloseOn)
        llSetTimerEvent(2.0) ;
    else
        llSetTimerEvent(0.0) ;
}
ShowMenu()
{
    string Text ;
    list Buttons = [ "<< BACK", " ", " " ] ;
    if (AutoCloseOn)
    {
        Text = "Current time: " + (string)Time + " seconds" ;
        Buttons += [ "Time ++", "Time --", "Reset", "Time +", "Time -", "Off" ] ;
    }
    else
    {
        Text = "Auto close is off." ;
        Buttons += [ "Turn on" ] ;
    }
    MenuListen = llListen(MENU_CHANNEL, "", OwnerID, "") ;
    llSetTimerEvent(120.0) ;
    llDialog(OwnerID, "\n\n     DOOR AUTO CLOSE SETTINGS\n\n" + Text, Buttons , MENU_CHANNEL) ;
}
integer GetClosingTime()
{
    return((integer)llGetTime() + Time) ;
}
default
{
    on_rez(integer Start)
    {
        llResetScript() ;
    }
    state_entry()
    {
        if (llGetInventoryType(NOTECARD_README) == INVENTORY_NOTECARD) state Hang ;
        integer N = llGetInventoryNumber(INVENTORY_SCRIPT) ;
        integer S ;
        for (S = 0 ; S < N ; S++)
        {
            string Name = llGetInventoryName(INVENTORY_SCRIPT, S) ;
            if (llGetSubString(Name, 0, llStringLength(SCRIPT_SETUP) -1) == SCRIPT_SETUP) state Hang ;
        }        
        AutoCloseOn = TRUE ;        
        IsOpen = FALSE ;
        IDs = ClosingTimes = [] ;
        OwnerID = llGetOwner() ;
        MENU_CHANNEL += (integer)llFrand(10000.0) ;
        Time = 30 ;
        MenuUp = FALSE ;
        SetTimer() ;
        //llOwnerSay("Memory (auto close plugin): " + (string)llGetUsedMemory()) ;
        llSetMemoryLimit(15700) ;
    }
    link_message(integer Sender, integer Number, string Message, key Key)
    {

        if (Number == PLUGIN_DOOR_BOOTING) llResetScript() ;
        else if (Number == PLUGIN_DOOR_BOOTED)
        {
            llMessageLinked(LINK_SET, PLUGIN_DOOR_SEND_MENU_BUTTON, MENU_MAIN, NULL_KEY) ;
            llMessageLinked(LINK_SET, PLUGIN_DOOR_SEND_LIST_DOORS, "", "") ;
        }
        else if (Number == PLUGIN_DOOR_RECV_OPEN)
        {
            integer ClosingTime = GetClosingTime() ;
            if (Message == "")    // all doors
            {
                IDs = DoorList ;
                ClosingTimes = [] ;
                integer I = llGetListLength(IDs) ;
                while(I-- > 0) ClosingTimes += ClosingTime ;
            }
            else
            {
                integer ID = (integer)Message ;
                integer Ptr = llListFindList(IDs, [ ID ]) ;
                if (Ptr > -1)
                {
                    IDs = llDeleteSubList(IDs, Ptr, Ptr) ;
                    ClosingTimes = llDeleteSubList(ClosingTimes, Ptr, Ptr) ;
                }
                IDs += ID ;
                ClosingTimes += ClosingTime ;
            }
        }
        else if (Number == PLUGIN_DOOR_RECV_CLOSE)
        {
            if (Message == "")
            {
                IDs = ClosingTimes = [] ;
            }
            else
            {
                integer ID = (integer)Message ;
                integer Ptr = llListFindList(IDs, [ ID ]) ;
                if (Ptr > -1)
                {
                    IDs = llDeleteSubList(IDs, Ptr, Ptr) ;
                    ClosingTimes = llDeleteSubList(ClosingTimes, Ptr, Ptr) ;
                }                
            }
        }
        else if (Number == PLUGIN_DOOR_RECV_MENU_BUTTON && Message == MENU_MAIN)
        {
            MenuUp = TRUE ;
            ShowMenu() ;
        }
        else if (Number == PLUGIN_DOOR_RECV_LIST_DOORS)
            DoorList = llCSV2List(Message) ;
    }
    listen(integer Channel, string Name, key ID, string Message)
    {
        if (Channel == MENU_CHANNEL && ID == OwnerID)
        {
            if (Message == "<< BACK")
            {
                llMessageLinked(LINK_SET, PLUGIN_DOOR_SEND_MENU_FINISH, "", NULL_KEY) ;
                MenuUp = FALSE ;
                SetTimer() ;
                llListenRemove(MenuListen) ;
                return ;
            }
            else if (Message == " ++") Time += 30 ;
            else if (Message == "Time --") Time -= 30 ;
            else if (Message == "Time +") Time += 5 ;
            else if (Message == "Time -") Time -= 5 ;
            else if (Message == "Reset") Time = 30 ;
            else if (Message == "Off") AutoCloseOn = FALSE ;
            else if (Message == "Turn on") AutoCloseOn = TRUE ;
            if (Time > 10000) Time = 10000 ;
            else if (Time < 5) Time = 5 ;
            ShowMenu() ;
        }
    }
    timer()
    {
        if (MenuUp)
        {
            llDialog(OwnerID, "Menu timed out", [ "OK" ], -494781433) ;
            llListenRemove(MenuListen) ;
            MenuUp = FALSE ;
            SetTimer() ;
        }
        else
        {
            //if (llGetListLength(IDs) > 0) llSay(0, "L: " + llList2CSV(IDs) + " - " + llList2CSV(ClosingTimes) + " (" + (string)llRound(llGetTime()) + ")") ; ;
            integer Now = (integer)llGetTime() ;
            integer Looper = TRUE ;
            // ugly, but run-time efficiency is paramount - while there are doors open, and oldest (first) has expired, close that door and take it off the list, loop back
            while(Looper)
            {
                if (llGetListLength(IDs) == 0)
                    Looper = FALSE ;
                else
                {
                    if (llList2Integer(ClosingTimes, 0) < Now)
                    {
                        integer ID = llList2Integer(IDs, 0) ;
                        llMessageLinked(LINK_SET, PLUGIN_DOOR_SEND_CLOSE_ONE, (string)ID, NULL_KEY) ;
                        IDs = llDeleteSubList(IDs, 0, 0) ;
                        ClosingTimes = llDeleteSubList(ClosingTimes, 0, 0) ;
                    }
                    else
                        Looper = FALSE ;
                }
            }
        }
    }
}
state Hang
{
    on_rez(integer Param)
    {
        llResetScript() ;
    }
    changed(integer Change)
    {
        if (Change & (CHANGED_OWNER | CHANGED_INVENTORY | CHANGED_SHAPE)) llResetScript() ;
        else if (Change & CHANGED_LINK) llResetScript() ;
    }
}
// Handy's doors plugin - Auto Close v1.0