integer onlytransparent = FALSE; //particles emit only from prims textred "default_transparent" when true
integer revivedelay = 300;   //integer interval to revive after exploding
integer attackdelay = 300;   //integer interval after which attacks timeout and revive
integer maxlife = 05;       //integer hit points
string smoketexture = "Smoke"; //texture used for all smoke and explosion
string firetexture = "Flame";  //texture used for fire
integer text = FALSE;    //show floating text life remaining TRUE or FALSE;
integer HasWindmill = FALSE;     // If there is a need to silence the windmill noises

//no further end user parameters
integer maxhits = 50; //maximum number of hits remembered to avoid stack/heap crash

float timerinterval = 1.0; 
integer life;
integer repairing;
integer reviving;
integer attacked;
float range;
list bb;
integer sensing;
list hits;
list psys;

reset()
{
    llSetText("", <1, 1, 1>, 1);
    hits = [];
        
    integer i;
    for(i = 0; i < llGetNumberOfPrims() + 1; i++)
    {
        key texid = llList2Key(llGetLinkPrimitiveParams(i, [PRIM_TEXTURE, 0]), 0);
        if(texid == TEXTURE_TRANSPARENT || !onlytransparent)
            llLinkParticleSystem(i, []);
        llSetLinkPrimitiveParamsFast(i, [PRIM_COLOR, ALL_SIDES, <1, 1, 1>, 1.0]);
    }
    llSetStatus(STATUS_PHANTOM, FALSE);
    
    if( HasWindmill ){
        llMessageLinked(1, 0, "run", llGetKey());
    }
    
    life = maxlife;
    bb = llGetBoundingBox(llGetKey());
    range = llVecMag(llList2Vector(bb, 1) - llList2Vector(bb, 0))/2.0;
    sense();
    reviving = 0;
}

explode()
{
    llSetText("", <1, 1, 1>, 1);
    psys = [  // start of particle settings
       // Texture Parameters:
       PSYS_SRC_TEXTURE, smoketexture, 
       PSYS_PART_START_SCALE, <1.0,1.0, FALSE>,  PSYS_PART_END_SCALE, <5.00,5.00, FALSE>, 
       PSYS_PART_START_COLOR, <1.0, 1.0, 1.0>,       PSYS_PART_END_COLOR, <0.2, 0.6, 1.0>, 
       PSYS_PART_START_ALPHA, (float)1.0,            PSYS_PART_END_ALPHA, (float)0.0,     
     
       PSYS_SRC_BURST_PART_COUNT, 500, 
       PSYS_SRC_BURST_RATE,  (float)0.01,   
       PSYS_PART_MAX_AGE, (float)2.0, 
       PSYS_SRC_MAX_AGE, (float)2.6,  
    
       PSYS_SRC_PATTERN, 2, // 1=DROP, 2=EXPLODE, 4=ANGLE, 8=ANGLE_CONE,
       PSYS_SRC_ACCEL, <0.0,0.0,-3.0>,  
       
    // PSYS_SRC_BURST_RADIUS, 0.0,
       PSYS_SRC_BURST_SPEED_MIN, (float)1.2,   PSYS_SRC_BURST_SPEED_MAX, (float)10.01, 
    
       PSYS_SRC_ANGLE_BEGIN,  (float)0.25*PI,        PSYS_SRC_ANGLE_END, (float)0.00*PI,  
       PSYS_SRC_OMEGA, <0,0,0>, 
    
    // PSYS_SRC_TARGET_KEY,      llGetLinkKey(llGetLinkNumber() + 1),       
          
       PSYS_PART_FLAGS, ( 0      
                            | PSYS_PART_INTERP_COLOR_MASK   
                            | PSYS_PART_INTERP_SCALE_MASK   
                            | PSYS_PART_EMISSIVE_MASK   
                            | PSYS_PART_FOLLOW_VELOCITY_MASK
                            | PSYS_PART_WIND_MASK            
                         // | PSYS_PART_BOUNCE_MASK          
                         // | PSYS_PART_FOLLOW_SRC_MASK     
                         // | PSYS_PART_TARGET_POS_MASK     
                         // | PSYS_PART_TARGET_LINEAR_MASK    
                        ) 
        //end of particle settings                     
    ];    
    
    integer i;
    for(i = 0; i < llGetNumberOfPrims() + 1; i++)
    {
        key texid = llList2Key(llGetLinkPrimitiveParams(i, [PRIM_TEXTURE, 0]), 0);
        if(texid == TEXTURE_TRANSPARENT || !onlytransparent)
            llLinkParticleSystem(i, psys);
        llSetLinkPrimitiveParamsFast(i, [PRIM_COLOR, ALL_SIDES, <1, 1, 1>, 0.0]);
    }
    llSetStatus(STATUS_PHANTOM, TRUE);
    
    vector end = llGetPos() + llList2Vector(bb, 1);
    vector begin = llGetPos() + llList2Vector(bb, 0);
    vector center = (end - begin) / 2.0 + begin;
    if( llGetInventoryName(INVENTORY_OBJECT, 0) != "" ){
        llRezObject(llGetInventoryName(INVENTORY_OBJECT, 0), center, ZERO_VECTOR, llGetRot(), 0);
    }
    
    if( HasWindmill ){
        llMessageLinked(1, 0, "run", llGetKey());
    }
    
    nosense();
    reviving = revivedelay;
}

fire()
{
    psys = [  // start of particle settings
        // Texture Parameters:
        PSYS_SRC_TEXTURE, firetexture, 
        PSYS_PART_START_SCALE, <5.25,5.25, FALSE>,  PSYS_PART_END_SCALE, <2.0,2.0, FALSE>, 
        PSYS_PART_START_COLOR, <1,1,0>,       PSYS_PART_END_COLOR, <.4,0,0>, 
        PSYS_PART_START_ALPHA, (float).8,            PSYS_PART_END_ALPHA, (float)0.0,     
     
        // Production Parameters:
        PSYS_SRC_BURST_PART_COUNT, (integer) 1, 
        PSYS_SRC_BURST_RATE, (float) 0.01,  
        PSYS_PART_MAX_AGE, (float)3.5, 
        PSYS_SRC_MAX_AGE,(float) 0.0,  
    
        // Placement Parameters:
        PSYS_SRC_PATTERN, (integer)2, // 1=DROP, 2=EXPLODE, 4=ANGLE, 8=ANGLE_CONE,
       
        // Placement Parameters (for any non-DROP pattern):
        PSYS_SRC_BURST_SPEED_MIN, (float).1,   PSYS_SRC_BURST_SPEED_MAX, (float)3.01, 
        // PSYS_SRC_BURST_RADIUS, 0.0,
    
        // Placement Parameters (only for ANGLE & CONE patterns):
        PSYS_SRC_ANGLE_BEGIN, (float) 0.01*PI,        PSYS_SRC_ANGLE_END,(float) 0.0*PI,  
        PSYS_SRC_OMEGA, <0,0,0>, 
        
        // After-Effect & Influence Parameters:
        PSYS_SRC_ACCEL, <0.5,0.5,1.5>,  
        // PSYS_SRC_TARGET_KEY,      llGetLinkKey(llGetLinkNum() + 1),       
          
        PSYS_PART_FLAGS, (integer)( 0           // Texture Options:     
                            | PSYS_PART_INTERP_COLOR_MASK   
                            | PSYS_PART_INTERP_SCALE_MASK   
                            | PSYS_PART_EMISSIVE_MASK   
                            | PSYS_PART_FOLLOW_VELOCITY_MASK
                                              // After-effect & Influence Options:
                         // | PSYS_PART_WIND_MASK            
                         // | PSYS_PART_BOUNCE_MASK          
                         // | PSYS_PART_FOLLOW_SRC_MASK     
                         // | PSYS_PART_TARGET_POS_MASK     
                         // | PSYS_PART_TARGET_LINEAR_MASK     
                        ) 
        //end of particle settings                     
        ];
        
    integer i;
    for(i = 0; i < llGetNumberOfPrims() + 1; i++)
    {
        key texid = llList2Key(llGetLinkPrimitiveParams(i, [PRIM_TEXTURE, 0]), 0);
        if(texid == TEXTURE_TRANSPARENT || !onlytransparent)
            llLinkParticleSystem(i, psys);
    }
}
       
heavysmoke()
{
    psys = [
        PSYS_PART_FLAGS, PSYS_PART_INTERP_COLOR_MASK | PSYS_PART_INTERP_SCALE_MASK | PSYS_PART_WIND_MASK, 
        PSYS_PART_START_COLOR, <.5,.5,.5>, 
        PSYS_PART_START_ALPHA, 1.0, 
        PSYS_PART_END_COLOR, <0,0,0>, 
        PSYS_PART_END_ALPHA, 0.0, 
        PSYS_PART_START_SCALE, <1,1,0>, 
        PSYS_PART_END_SCALE, <5,5,0>, 
        PSYS_PART_MAX_AGE, 10.0,
        PSYS_SRC_ACCEL, <0.0,0.00,.5>, 
        PSYS_SRC_PATTERN, PSYS_SRC_PATTERN_EXPLODE,
        PSYS_SRC_BURST_RATE, 0.1,
        PSYS_SRC_BURST_PART_COUNT, 3, 
        PSYS_SRC_BURST_RADIUS, 0.00, 
        PSYS_SRC_BURST_SPEED_MIN, 0.00, 
        PSYS_SRC_BURST_SPEED_MAX, 0.50, 
        PSYS_SRC_MAX_AGE, 0.0, 
        PSYS_SRC_TEXTURE, smoketexture,
        PSYS_SRC_OMEGA, <0.00,0.00,0.00>
        ];
        
    integer i;
    for(i = 0; i < llGetNumberOfPrims() + 1; i++)
    {
        key texid = llList2Key(llGetLinkPrimitiveParams(i, [PRIM_TEXTURE, 0]), 0);
        if(texid == TEXTURE_TRANSPARENT || !onlytransparent)
            llLinkParticleSystem(i, psys);
    }
}

lightsmoke()
{
    integer flags;
    
    // Mask Flags - set to TRUE to enable
    integer glow = FALSE;            // Make the particles glow
    integer bounce = FALSE;          // Make particles bounce on Z plane of object
    integer interpColor = TRUE;     // Go from start to end color
    integer interpSize = TRUE;      // Go from start to end size
    integer wind = FALSE;           // Particles effected by wind
    integer followSource = FALSE;    // Particles follow the source
    integer followVel = FALSE;       // Particles turn to velocity direction
    
    // Choose a pattern from the following:
    // PSYS_SRC_PATTERN_EXPLODE
    // PSYS_SRC_PATTERN_DROP
    // PSYS_SRC_PATTERN_ANGLE_CONE_EMPTY
    // PSYS_SRC_PATTERN_ANGLE_CONE
    // PSYS_SRC_PATTERN_ANGLE
    integer pattern = PSYS_SRC_PATTERN_EXPLODE;
    
    // Select a target for particles to go towards
    // "" for no target, "owner" will follow object owner 
    //    and "self" will target this object
    //    or put the key of an object for particles to go to
    key target = "";
    
    // Particle paramaters
    float age = 2.5;                  // Life of each particle
    float maxSpeed = 0.3;            // Max speed each particle is spit out at
    float minSpeed = 0.8;            // Min speed each particle is spit out at
    string texture = (string)smoketexture;//"4f714019-c1cf-6b16-994f-44b217022f1a";                 // Texture used for particles, default used if blank
    float startAlpha = 0.8;           // Start alpha (transparency) value
    float endAlpha = 0.0;           // End alpha (transparency) value
    vector startColor = <0.5,0.5,0.5>;    // Start color of particles <R,G,B>
    vector endColor = <0,0,0>;      // End color of particles <R,G,B> (if interpColor == TRUE)
    vector startSize = <0.01,0.01,0.0>;     // Start size of particles 
    vector endSize = <2.0,2.0,0.0>;       // End size of particles (if interpSize == TRUE)
    vector push = <.2,0,3>;          // Force pushed on particles
    
    // System paramaters
    float rate = 0.1;            // How fast (rate) to emit particles
    float radius = 0.0;          // Radius to emit particles for BURST pattern
    integer count = 5;        // How many particles to emit per BURST 
    float outerAngle = 0;    // Outer angle for all ANGLE patterns
    float innerAngle = 0.1;    // Inner angle for all ANGLE patterns
    vector omega = <0,0,0>;    // Rotation of ANGLE patterns around the source
    float life = 0;             // Life in seconds for the system to make particles
    
    flags = 0;
    if (target == "owner") target = llGetOwner();
    if (target == "self") target = llGetKey();
    if (glow) flags = flags | PSYS_PART_EMISSIVE_MASK;
    if (bounce) flags = flags | PSYS_PART_BOUNCE_MASK;
    if (interpColor) flags = flags | PSYS_PART_INTERP_COLOR_MASK;
    if (interpSize) flags = flags | PSYS_PART_INTERP_SCALE_MASK;
    if (wind) flags = flags | PSYS_PART_WIND_MASK;
    if (followSource) flags = flags | PSYS_PART_FOLLOW_SRC_MASK;
    if (followVel) flags = flags | PSYS_PART_FOLLOW_VELOCITY_MASK;
    if (target != "") flags = flags | PSYS_PART_TARGET_POS_MASK;
    psys = [  PSYS_PART_MAX_AGE,age,
                        PSYS_PART_FLAGS,flags,
                        PSYS_PART_START_COLOR, startColor,
                        PSYS_PART_END_COLOR, endColor,
                        PSYS_PART_START_SCALE,startSize,
                        PSYS_PART_END_SCALE,endSize, 
                        PSYS_SRC_PATTERN, pattern,
                        PSYS_SRC_BURST_RATE,rate,
                        PSYS_SRC_ACCEL, push,
                        PSYS_SRC_BURST_PART_COUNT,count,
                        PSYS_SRC_BURST_RADIUS,radius,
                        PSYS_SRC_BURST_SPEED_MIN,minSpeed,
                        PSYS_SRC_BURST_SPEED_MAX,maxSpeed,
                        PSYS_SRC_TARGET_KEY,target,
                        PSYS_SRC_INNERANGLE,innerAngle, 
                        PSYS_SRC_OUTERANGLE,outerAngle,
                        PSYS_SRC_OMEGA, omega,
                        PSYS_SRC_MAX_AGE, life,
                        PSYS_SRC_TEXTURE, texture,
                        PSYS_PART_START_ALPHA, startAlpha,
                        PSYS_PART_END_ALPHA, endAlpha
                            ];
                        
    integer i;
    for(i = 0; i < llGetNumberOfPrims() + 1; i++)
    {
        key texid = llList2Key(llGetLinkPrimitiveParams(i, [PRIM_TEXTURE, 0]), 0);
        if(texid == TEXTURE_TRANSPARENT || !onlytransparent)
            llLinkParticleSystem(i, psys);
    }    
}

sense()
{
    sensing = TRUE;
    //llSensorRepeat("CannonBall", "", SCRIPTED, range, PI, senseinterval);
}

nosense()
{
    sensing = FALSE;
    //llSensorRemove();
}

damage()
{        
    if(life <= 0)
        explode();
    else if(life <= maxlife*0.25)
        fire();
    else if(life <= maxlife*0.50)
        heavysmoke();
    else if(life <= maxlife*0.75)
        lightsmoke();
    else if(life == maxlife)
        llResetScript();
    
    if(life <= 0)
        llSetText("", <1, 1, 1>, 1);
    else
    {
        if(text)
        {
            llSetText("life: " + (string)life, <1, 1, 1>, 1);
            //llOwnerSay((string)life);
        }
    }
}

default
{
    state_entry()
    {
        reset();
        llSetTimerEvent(timerinterval);
    }
    
    on_rez(integer num)
    {
        llResetScript();
    }
    
    timer()
    {
        if(attacked)
        {
            attacked--;
            if(!attacked)
                repairing = TRUE;
        }
         
        if(repairing)
        {
            if(life < maxlife)
            {
                life++;
                damage();
                if(life == maxlife)
                {
                    repairing = FALSE;
                    llSetText("", <1, 1, 1>, 1);
                }
            }
        }   
            
        if(reviving)
        {
            attacked = 0;
            reviving--;
            if(!reviving)
                llResetScript();
        }
    }
    
    collision_start(integer num)//sensor(integer num)
    {
        if(!sensing)
            return;
        
        string name;
        key id;
        integer i;
        for(i = 0; i < num; i++)
        {
            name = llDetectedName(i);
            id = llDetectedKey(i);
            if(name == "CannonBall" && llListFindList(hits, [id]) == -1)
            {
                life--;
                hits += id;
                if(llGetListLength(hits) == maxhits)
                    hits = llDeleteSubList(hits, 0, 0);
                attacked = attackdelay;
                damage();
            }
        }
    }
}
