// Optional second hand will be a much simpler script that will be
// unrelated to real-time.
//
// note - to reduce load, this script only calculates once a minute, so
// this provides a jump style minute hand, rather than a smoothy rotating one.
// This (and rounding) makes the clock's accuracy +/- 1 minute.
// It's a prim clock anyways, so digital accuracy is just excessive.
//
// It would probably be more elegant to use link messages rather than each
// hand having it's own script, however, this method allows for less caution
// when linking/unlinking parts of the clock.

// To not mess up timekeeping, please keep chime sounds under 4 seconds long.

integer time;
integer hours;
integer minutes;

float anglehours;
float angleminutes;

integer chime;
integer numrings;

string chimesound = "clockchime";
float chimevolume = 1.0;

default

{
    state_entry()
    {
        //we want to calculate once a minute.
        llSetTimerEvent(60.0);
    }
    timer()
        {
        time = (integer)llGetWallclock(); // seconds since midnight
        hours = (time / 3600);
        //convert from 24 to 12 hour time
        if (hours > 11)
            {
                hours = hours - 12;
            }
        minutes = (time % 3600) / 60;
        
        numrings = (integer)hours;
        if (numrings == 0)
            {
            numrings = 12;
            }
        
        //the extra addition here makes a smooth hour hand
        //for example, at 6:30, the hour hand should actually
        //be halfway between 6 and 7 on the clock dial
        
        anglehours = - (((float)hours / 12) + (((float)minutes / 720))) * TWO_PI;
        llSetSoundQueueing(TRUE);
        llRotateTexture(anglehours, ALL_SIDES);
        if (minutes == 0)
            {
            for (chime = 0; chime < numrings; chime++)
                {
                llPlaySound(chimesound, chimevolume);
                llSleep(3.0);    
                }
            
            }
        }
} 