 
rotation rot_xyzq;
integer open = FALSE;
integer locked = FALSE;
integer auto_close = 0; // Seconds to wait before closing the door automaticly.
integer dialog_channel;
list buttons = [];
key locked_by_key = NULL_KEY;


setAngle(vector angle)
{
    vector xyz_angles = angle; // This is to define a 1 degree change
    vector angles_in_radians = xyz_angles*DEG_TO_RAD; // Change to Radians
    rot_xyzq = llEuler2Rot(angles_in_radians); // Change to a Rotation
}

list order_buttons(list buttons)
{
    return llList2List(buttons, -3, -1) + llList2List(buttons, -6, -4) + llList2List(buttons, -9, -7) + llList2List(buttons, -12, -10);
}

integer random_integer( integer min, integer max )
{
    return min + (integer)(llFrand(max - min + 1));
}

show_menu()
{
    llDialog(llDetectedKey(0), "Choose an option.", buttons, dialog_channel);
}

door_open()
{
    setAngle(<0.0,0.0,-90.0>);
    llSetRot(llGetRot()*rot_xyzq);
    open = TRUE;
    llSetTimerEvent(auto_close);
}

door_close()
{
    setAngle(<0.0,0.0,90.0>);
    llSetRot(llGetRot()*rot_xyzq);
    open = FALSE;
    llSetTimerEvent(0);
}

default
{
    state_entry()
    {
        setAngle(<0.0,0.0,-90.0>);
        buttons = ["Open", "Close", "Lock", "Unlock"];
        buttons = order_buttons(buttons);
        dialog_channel = random_integer(1000,30000);
        llListen(dialog_channel,"", "","");
    }
 
    touch_start(integer i)
    {
        show_menu();
    }
    
    listen(integer channel, string name, key id, string option)
    {
        if (channel == dialog_channel)
        {
            if (option == "Open")
            {
                if (!open)
                {
                    if (locked)
                    {
                        llWhisper(0, llKey2Name(locked_by_key) + " has locked this door.");
                    } else {
                        door_open();
                    }
                } else {
                    llWhisper(0, "This door is already open.");
                }
                return;
            }
            if (option == "Close")
            {
                if (open)
                {
                    door_close();
                } else {
                    llWhisper(0, "This door is already closed.");
                }
                return;
            }
            if (option == "Lock")
            {
                if (open)
                {
                    llWhisper(0, "You cannot lock an open door.");
                    return;
                }
                if (locked)
                {
                    llWhisper(0, "This door is already locked.");
                    return;
                } else {
                    locked = TRUE;
                    locked_by_key = id;
                    llWhisper(0, "This door has been locked by " + name + ".");
                }
                return;
            }
            if (option == "Unlock")
            {
                if (open)
                {
                    llWhisper(0, "You cannot unlock an open door.");
                    return;
                }
                if (!locked)
                {
                    llWhisper(0, "This door is already unlocked.");
                    return;
                }
                if (locked)
                {
                    if (locked_by_key == id)
                    {
                        locked = FALSE;
                        locked_by_key = NULL_KEY;
                        llWhisper(0, "The door is unlocked.");
                    } else {
                        llWhisper(0, "Only " + llKey2Name(locked_by_key) + " may unlock this door.");
                    }
                    return;
                }
                return;
            }
        }
    }
    
    timer()
    {
        door_close();
        
    }
}