float speed;
vector angular_motor;

default
{
    state_entry()
    {
        llMessageLinked(LINK_ALL_CHILDREN, 0, "stop", NULL_KEY);
        llSetSitText("Raft");
        llStopSound();
        llSetTimerEvent(0.0);
        speed=0;
       llSitTarget(<-2.14719, -0.02570, 0.98203>, <0.00000, 0.00000, -0.37461, 0.92718>);
        llSetCameraEyeOffset(<-7.0, -0.00, 3.0>);
        llSetCameraAtOffset(<3.0, 0.0, 2.0>);
        llSetVehicleType(VEHICLE_TYPE_BOAT);
        llSetVehicleFlags(VEHICLE_FLAG_HOVER_UP_ONLY | VEHICLE_FLAG_HOVER_WATER_ONLY);
        // remove these flags 
        llRemoveVehicleFlags( VEHICLE_FLAG_HOVER_TERRAIN_ONLY 
                      | VEHICLE_FLAG_LIMIT_ROLL_ONLY 
                      | VEHICLE_FLAG_HOVER_GLOBAL_HEIGHT);
        
        // least for forward-back, most friction for up-down
        llSetVehicleVectorParam( VEHICLE_LINEAR_FRICTION_TIMESCALE, <2, 3, 2> );
    
        // uniform angular friction (setting it as a scalar rather than a vector)
        llSetVehicleFloatParam( VEHICLE_ANGULAR_FRICTION_TIMESCALE, 2 );

        // linear motor wins after about five seconds, decays after about a minute
        llSetVehicleFloatParam( VEHICLE_LINEAR_MOTOR_TIMESCALE, 5 );
        llSetVehicleFloatParam( VEHICLE_LINEAR_MOTOR_DECAY_TIMESCALE, 60 );

        // agular motor wins after four seconds, decays in same amount of time
        llSetVehicleFloatParam( VEHICLE_ANGULAR_MOTOR_TIMESCALE, 2 );
        llSetVehicleFloatParam( VEHICLE_ANGULAR_MOTOR_DECAY_TIMESCALE, 5 );

        // hover / float
        llSetVehicleFloatParam( VEHICLE_HOVER_HEIGHT, 0.1);
        llSetVehicleFloatParam( VEHICLE_HOVER_EFFICIENCY,.5 );
        llSetVehicleFloatParam( VEHICLE_HOVER_TIMESCALE, 2.0 );
        llSetVehicleFloatParam( VEHICLE_BUOYANCY, 0.5 );

        // halfway linear deflection with timescale of 3 seconds
        llSetVehicleFloatParam( VEHICLE_LINEAR_DEFLECTION_EFFICIENCY, 0.5 );
        llSetVehicleFloatParam( VEHICLE_LINEAR_DEFLECTION_TIMESCALE, 3 );

        // angular deflection 
        llSetVehicleFloatParam( VEHICLE_ANGULAR_DEFLECTION_EFFICIENCY, 0.5 );
        llSetVehicleFloatParam( VEHICLE_ANGULAR_DEFLECTION_TIMESCALE, 10 );
    
        // somewhat bounscy vertical attractor 
        llSetVehicleFloatParam( VEHICLE_VERTICAL_ATTRACTION_EFFICIENCY, 0.5 );
        llSetVehicleFloatParam( VEHICLE_VERTICAL_ATTRACTION_TIMESCALE, 2 );

        // weak negative damped banking
        llSetVehicleFloatParam( VEHICLE_BANKING_EFFICIENCY, 1 );
        llSetVehicleFloatParam( VEHICLE_BANKING_MIX, 0.1 );
        llSetVehicleFloatParam( VEHICLE_BANKING_TIMESCALE, .75 );

        // default rotation of local frame
        llSetVehicleRotationParam( VEHICLE_REFERENCE_FRAME, <0, 0, 0, 1> );
    }
    
    changed(integer change)
    {
        if (change & CHANGED_LINK)
        {
            key agent = llAvatarOnSitTarget();
            if (agent)
            {
                if (agent != llGetOwner())
                {
                    llSay(0, "You ain't no Hobo:P");
                    llUnSit(agent);
                    llPushObject(agent, <0,0,100>, ZERO_VECTOR, FALSE);
                }
                else
                {
                    // You sit and are owner so get controls
                    llSetStatus(STATUS_PHYSICS, TRUE);
                    llSetStatus(STATUS_ROTATE_X | STATUS_ROTATE_Y | STATUS_ROTATE_Z, TRUE);
                    llRequestPermissions(agent,PERMISSION_TAKE_CONTROLS);
                }
            }
            else
            {
                // You stand so boat stops
                llMessageLinked(LINK_ALL_CHILDREN, 0, "stop", NULL_KEY);
                llSetStatus(STATUS_PHYSICS, FALSE);
                llSetStatus(STATUS_ROTATE_X | STATUS_ROTATE_Y | STATUS_ROTATE_Z, FALSE);
                llReleaseControls();
                llStopSound();
                llSetTimerEvent(0.0);
            }
        }
        
    }
    
    run_time_permissions(integer perm)
    {
        if (perm)
        {
            // Take these controls and lets go
            llTakeControls(CONTROL_FWD | CONTROL_BACK | CONTROL_RIGHT | CONTROL_LEFT | CONTROL_ROT_RIGHT | CONTROL_ROT_LEFT | CONTROL_UP | CONTROL_DOWN, TRUE, FALSE);
            llMessageLinked(LINK_ALL_CHILDREN, 0, "start", NULL_KEY);
           
            llSetTimerEvent(0.3);
        }
    }
    control(key id, integer level, integer edge)
    {

        if(level & CONTROL_FWD)
        {
            // Set cruising speed faster
            if(speed < 15)
            {
                speed +=1;
            }
        }
        if(level & CONTROL_BACK)
        {
            // Set cruising speed slower
            if(speed > -8)
            {
                speed -=1;
            }
        }
        if(level & (CONTROL_RIGHT|CONTROL_ROT_RIGHT))
        {
            // Turn right
            angular_motor.x += 5;
            angular_motor.z -= 1;
        }
        if(level & (CONTROL_LEFT|CONTROL_ROT_LEFT))
        {
            // Turn left
            angular_motor.x -= 5;
            angular_motor.z += 1;
        }
        if(level & CONTROL_UP)
        {
            // add features for when you press up
        }
        if(level & CONTROL_DOWN)
        {
            // Added feature for when you press down
            // Stops boat when down is pressed
            speed=0;
        }
    
    }

    timer()
    {
        // the timer actually moves vehicle
        llSetVehicleVectorParam(VEHICLE_LINEAR_MOTOR_DIRECTION, <speed,0,0>);
        llSetVehicleVectorParam(VEHICLE_ANGULAR_MOTOR_DIRECTION, angular_motor);
        // reset turning angle or you would go around in circles
        angular_motor=<0,0,0>;
    }    
}
