integer AUTO = 0;
integer OPEN = 1;
integer CLOSED = 2;


integer g_Access;
integer g_Count;
integer g_DChan = -0x36F29AD0;
integer g_CChan = -0x36F29AC0;
integer g_Daytime;
integer g_DListen;

string g_Model;
key g_MyKey;

default
{
    state_entry()
    {   
    
        g_MyKey = llGetKey();
        g_Model = llGetObjectName();
        llMessageLinked(LINK_ALL_CHILDREN,-1,"","");
        llMessageLinked(LINK_THIS,-1,"","");
        state manual;
    }
    
    on_rez(integer parm ) {
          llResetScript();
    }
        

}
 
 
state manual {
    
    state_entry() {
        
        g_Access = CLOSED;
        
        llListen(g_CChan,g_Model,NULL_KEY,"Auto");
        llListen(g_CChan,g_Model,NULL_KEY,"Open");
        llListen(g_CChan,g_Model,NULL_KEY,"Secure");
    }
    
    on_rez(integer parm ) {
        llSetText("",<1,1,1>,0.0);
          llResetScript();
    }
    
    touch_start(integer det)
    {
        if ( llDetectedKey(0) == llGetOwner() ) {
            
            llSetTimerEvent(0.25);
            return;
        } 
        
        if ( g_Access == OPEN ) {
            llMessageLinked(LINK_ALL_CHILDREN,3,"","");
            llMessageLinked(LINK_THIS,3,"","");
        }
    }
    
    touch(integer det ) {
        if ( g_Count > 12 ) {
            // Dialog!
            g_DListen = llListen(g_DChan,"",llGetOwner(),"");
            g_Count = 0;
            llSetTimerEvent(0);
            llDialog(llGetOwner(),"Select Operating Mode!",["Auto","Open","Secure","Help"],g_DChan);
        }
    }
    
    touch_end(integer det) {
        if ( g_Count < 12 && g_DListen == 0) {
            if ( llDetectedKey(0) == llGetOwner()) {
                g_Count = 0;
                llSetTimerEvent(0);
                llMessageLinked(LINK_ALL_CHILDREN,3,"","");
                llMessageLinked(LINK_THIS,3,"","");
            }
        }
    }
    
    listen(integer ch, string nm, key id, string msg) {
        
    
        llListenRemove(g_DListen);
        g_DListen = 0;
        
        if ( ch == g_DChan ) {       
        // From A Dialog
            if( msg == "Auto" ) {
                // Set Auto!
                llShout(g_CChan,msg);
                vector sunPos = llGetSunDirection();
                if ( sunPos.z < 0 ) {
                    g_Daytime = FALSE;
                } else {
                    g_Daytime = TRUE;
                }
                llSetTimerEvent(0);
                g_Count = 0;
                state auto;
            
            } else if ( msg == "Open" ) {
                // Set Open!
                llShout(g_CChan,msg);
                g_Access = OPEN;
            } else if ( msg == "Secure" ) {
                // Set Closed!
                llShout(g_CChan,msg);
                g_Access = CLOSED;
            } else if ( msg == "Help" ) {
                // Give Notecard!
                llGiveInventory(llGetOwner(),"Instructions");
                llSetTimerEvent(0);
                g_Count = 0;
            }
                  
            llListenRemove(g_DListen);
            g_DListen = 0;
            
        } else if ( ch == g_CChan ) {
        // From Other Lamps
            if( msg == "Auto" ) {
                // Set Auto!
                vector sunPos = llGetSunDirection();
                if ( sunPos.z < 0 ) {
                    g_Daytime = FALSE;
                } else {
                    g_Daytime = TRUE;
                }
                
                llSetTimerEvent(0);
                g_Count = 0;
                state auto;
            
            } else if ( msg == "Open" ) {
                // Set Open!
                g_Access = OPEN;
            } else if ( msg == "Secure" ) {
                // Set Closed!
                g_Access = CLOSED;
            } else if ( msg == "Help" ) {
                // Give Notecard!
                llGiveInventory(llGetOwner(),"Instructions");
                llSetTimerEvent(0);
                g_Count = 0;
            }
        }
             
    }
    
    timer() {
        g_Count++;
        if ( g_Count > 18 ) {
            llSetTimerEvent(0);
            g_Count = 0;
        }
    }   
    
    
}
 
//************************************ AUTO **************************************//
state auto {
    
    state_entry(){
       
        llListen(g_CChan,g_Model,NULL_KEY,"Manual");
        llListen(g_CChan,g_Model,NULL_KEY,"Help");
        
        vector sunPos = llGetSunDirection();
        if ( sunPos.z < 0) {
            // it is now night
            llMessageLinked(LINK_THIS,TRUE,"","");
            g_Daytime = FALSE;
        } else if ( sunPos.z > 0) {
            llMessageLinked(LINK_THIS,FALSE,"","");
            g_Daytime = TRUE;
        }
        
        llSetTimerEvent(30);
    }
        
    on_rez(integer parm ) {
          g_Access = CLOSED;
          llResetScript();
    }
    
    touch_start(integer det) {
        if ( llDetectedKey(0) == llGetOwner()) {
            g_DListen = llListen(g_DChan,"",llGetOwner(),"");
            llDialog(llGetOwner(),"Select Operating Mode!",["Manual","Help","Cancel"],g_DChan);
        }
    }
    
    timer() {
        
        vector sunPos = llGetSunDirection();
        
        if( sunPos.z < 0 && g_Daytime == TRUE) {
            // It is night
            llMessageLinked(LINK_THIS,TRUE,"","");
            g_Daytime = FALSE;
        } else if ( sunPos.z > 0 && g_Daytime == FALSE) {
            // It has turned day
            llMessageLinked(LINK_THIS,FALSE,"","");
            g_Daytime = TRUE;
        } 
    }
    
    listen(integer ch, string nm, key id, string msg) {    
        
        llListenRemove(g_DListen);
        g_DListen = 0;
        
        if ( ch == g_DChan ) {
            if ( msg == "Manual" ) {
                // Set Closed!
                g_Access = CLOSED;
                llShout(g_CChan,msg);
                state manual;
            } else if ( msg == "Help" ) {
                // Give Notecard!
                llGiveInventory(llGetOwner(),"Instructions");
            } else if ( msg == "Cancel") {
                return;
            }
        } else {
       
            if ( msg == "Manual" ) {
                // Set Closed!
                g_Access = CLOSED;
                state manual;
            }
        }
    }
}
