integer g_CChan = -467365140;

vector g_OnColorStart = <1.0,1.0,.8>;
vector g_OnColorEnd = <1.0, 0.9, 0.7>;

vector g_OffColorStart = <1.0,1.0,.8>;
vector g_OffColorEnd = <1.0, 0.9, 0.7>;
vector g_GlobeColorOff = <0.40,0.40,0.40>;

list g_ParticleSystem_Off;
list g_ParticleSystem_On;

string g_Model;

default
{
    state_entry()
    {   
        g_Model = llGetObjectName();
        g_ParticleSystem_Off = [ 
           PSYS_SRC_TEXTURE, "", 
           PSYS_PART_START_SCALE, <0.050,0.050,0>,     
           PSYS_PART_END_SCALE, <0.020,0.020,0>, 
           PSYS_PART_START_COLOR, g_OffColorStart,   
           PSYS_PART_END_COLOR, g_OffColorEnd, 
           PSYS_PART_START_ALPHA, 1.0,             
           PSYS_PART_END_ALPHA, 0.40,     
         
           PSYS_SRC_BURST_PART_COUNT, 1, 
           PSYS_SRC_BURST_RATE, 0.1,  
           PSYS_PART_MAX_AGE, 1.0, 
           PSYS_SRC_MAX_AGE, 0.0,  
        
           PSYS_SRC_PATTERN, 2, // 1=DROP, 2=EXPLODE, 4=ANGLE, 8=ANGLE_CONE,
           PSYS_SRC_ACCEL, <0.0,0.0,0.0>,  
           PSYS_SRC_BURST_RADIUS, 0.0,
        
           PSYS_SRC_BURST_SPEED_MIN, 0.300,   
           PSYS_SRC_BURST_SPEED_MAX, 0.800, 
        
           PSYS_SRC_ANGLE_BEGIN,  0.0,       
           PSYS_SRC_ANGLE_END, 0.0,  
           PSYS_SRC_OMEGA, <0.0,0.0,0.0>, 
        
           PSYS_SRC_TARGET_KEY,      llGetLinkKey(llGetLinkNumber()),       
              
           PSYS_PART_FLAGS, ( 0      
                                | PSYS_PART_INTERP_COLOR_MASK   
                                | PSYS_PART_INTERP_SCALE_MASK   
                                | PSYS_PART_EMISSIVE_MASK   
                             // | PSYS_PART_FOLLOW_VELOCITY_MASK
                             // | PSYS_PART_WIND_MASK            
                             // | PSYS_PART_BOUNCE_MASK          
                             // | PSYS_PART_FOLLOW_SRC_MASK     
                                | PSYS_PART_TARGET_POS_MASK     
                             // | PSYS_PART_TARGET_LINEAR_MASK    
            ) ];
            
           g_ParticleSystem_On = [ 
           PSYS_SRC_TEXTURE, "", 
           PSYS_PART_START_SCALE, <0.26,0.26,0>,     
           PSYS_PART_END_SCALE, <0.1,0.1,0>, 
           PSYS_PART_START_COLOR, g_OnColorStart,   
           PSYS_PART_END_COLOR, g_OnColorEnd, 
           PSYS_PART_START_ALPHA, .350,             
           PSYS_PART_END_ALPHA, 0.150,     
         
           PSYS_SRC_BURST_PART_COUNT, 2, 
           PSYS_SRC_BURST_RATE, 0.4,  
           PSYS_PART_MAX_AGE, 8.0, 
           PSYS_SRC_MAX_AGE, 0.0,  
        
           PSYS_SRC_PATTERN, 1, // 1=DROP, 2=EXPLODE, 4=ANGLE, 8=ANGLE_CONE,
           PSYS_SRC_ACCEL, <0.0,0.0,0.0>,  
           PSYS_SRC_BURST_RADIUS, 0.0,
        
           PSYS_SRC_BURST_SPEED_MIN, 1.00,   
           PSYS_SRC_BURST_SPEED_MAX, 1.00, 
        
           PSYS_SRC_ANGLE_BEGIN,  0.0,       
           PSYS_SRC_ANGLE_END, 0.0,  
           PSYS_SRC_OMEGA, <0.0,0.0,0.0>, 
        
        // PSYS_SRC_TARGET_KEY,      llGetLinkKey(llGetLinkNum() + 1),       
              
           PSYS_PART_FLAGS, ( 0      
                                | PSYS_PART_INTERP_COLOR_MASK   
                                | PSYS_PART_INTERP_SCALE_MASK   
                                | PSYS_PART_EMISSIVE_MASK   
                             // | PSYS_PART_FOLLOW_VELOCITY_MASK
                             // | PSYS_PART_WIND_MASK            
                             // | PSYS_PART_BOUNCE_MASK          
                             // | PSYS_PART_FOLLOW_SRC_MASK     
                             // | PSYS_PART_TARGET_POS_MASK     
                             // | PSYS_PART_TARGET_LINEAR_MASK    
            ) ];
             

        vector sun = llGetSunDirection();
        if ( sun.z > 0 ) {
            state on;
        } else {
            state off;
        }
    }
    
    on_rez(integer parm) {
        llResetScript();
    }
    
}

state on {
    
    state_entry() {
        llParticleSystem( g_ParticleSystem_On );
        llSleep(3);
        llSetPrimitiveParams([PRIM_COLOR,ALL_SIDES,g_OnColorStart,0.30,PRIM_BUMP_SHINY,ALL_SIDES,PRIM_SHINY_MEDIUM,PRIM_BUMP_NONE]);
        llListen(g_CChan,g_Model,NULL_KEY,"Off");
    }
    
    link_message(integer src, integer num, string str, key id) {
        
        if( num == FALSE ) {
            state off;
        } else if ( num == 3 ) {
            llShout(g_CChan,"Off");
            state off;
        }  
    }
    
    listen(integer chan, string nam, key id, string msg) {
        state off;
    }
    
    on_rez(integer parm) {
        llResetScript();
    }
    
}

state off {
    
    state_entry() {
        
        llSetPrimitiveParams([PRIM_COLOR,ALL_SIDES,g_GlobeColorOff,0.30]);
        llParticleSystem( g_ParticleSystem_Off );
        llListen(g_CChan,g_Model,NULL_KEY,"On");
    }
    
    on_rez(integer parm) {
        llResetScript();
    }
    
    
    link_message(integer src, integer num, string str, key id) {
        
        if( num == TRUE ) {
            state on;
        } else if ( num == 3 ) {
            llShout(g_CChan,"On");
            state on;
        } 
    }
        
    listen(integer chan, string nam, key id, string msg) {
        state on;
    }
}