//-----
// USER Changeable variables
//-----
float sound_length = 8.9; //In seconds. Each sound *must* be the same length.


//----
//PROGRAM variables, do not change
//----
list sounds = []; //we will put all the sound files names in here
key owner = "";//we will find out the owner on rez

integer lookahead = 5;//how many files to precache ahead.
integer current_sound = 0;
integer playing = FALSE;

default
{
    on_rez(integer param) {
        llResetScript();   
    }
    
    state_entry()
    {
        owner = llGetOwner();
        llSay(0, "Booting...");
       llSay(0, "DO NOT touch until booting is done.");      
        llSetSoundQueueing(TRUE);
        integer total_sounds = llGetInventoryNumber(INVENTORY_SOUND);
        
        integer i;
        for(i = 0; i < total_sounds; i++) {
            string sound = llGetInventoryName(INVENTORY_SOUND, i);
            sounds += sound;
        }
        
        if(llGetListLength(sounds) > 1) {
            for(i = 0; i < lookahead; i++) {
                llPreloadSound(llList2String(sounds, i));
               llSay(0, "Precaching: " + 
                        llList2String(sounds, i));
            }
        }
     //   llInstantMessage(owner, "Boot done."); 
    }

    touch_start(integer total_number)
    {
        integer i =0;
        for(i = 0; i < total_number; i++) {
         //   if(llDetectedKey(i) == owner) {
                if(playing) {
                    llSetTimerEvent(0.0);
                   // llInstantMessage(owner, "Stopping...");
                    llStopSound();
                 //   llInstantMessage(owner, "Done.");
                    playing = FALSE;
                    
                } else {
                  //  llInstantMessage(owner, "Starting...");
                    llSetTimerEvent(sound_length);
                    llPlaySound(llList2String(sounds, 0), 1.0);
                  //  llInstantMessage(owner, "Done.");
                    current_sound ++; 
                    playing = TRUE;
                }  
           // }   
        }
    }
    
    timer() {
        integer total = llGetListLength(sounds);
        if(current_sound >= total) {
            current_sound = 0;
            playing = FALSE;
         //   llInstantMessage(owner, "All sounds have been played.");
           
            llSetTimerEvent(0.0);
            return;  
        }
        llPlaySound(llList2String(sounds, current_sound), 1.0);
        if(current_sound + lookahead < total) {
           llPreloadSound(llList2String(sounds, current_sound + lookahead));
        }
        current_sound++;  
    }
} 