// Sim Memory meter by Adelle Fitzgerald
//If you change the size of the root prim, be sure to reset the script
//Feel free to use as you wish, but please keep this notice at the top of this script, or attribute me if you use any parts of it
//Thanks!

float maxMemMB = 80;
float simMemMB;
float percentCurrMB;

float size;
float red;
float green;
float zSize;

default
{
    state_entry()
    {
        zSize = llGetScale() * <0,0,1>;             //Get the size of the root prim
        llSetTimerEvent(1);                         //Set the timer thang
    }
    timer()
    {
        simMemMB = llGetRegionAgentCount();    //Get Memory
        if (simMemMB > maxMemMB) simMemMB = maxMemMB;       //Cap Memory in case of big wierd spikes
        percentCurrMB = 100 / maxMemMB * simMemMB;          //convert Meomory to percent
        size = 4 * 200 / 100 * percentCurrMB / 100;     //Work out size of meter prim
        

        if (percentCurrMB < 50) red = 0.0;
        else red = 1.0 - ((100 - percentCurrMB) / 50);   
        if (percentCurrMB < 50) green = 1.0 - (percentCurrMB / 50);
        else green = 0.0;
        
        //Set the size and colour of the meter prim
        llSetLinkPrimitiveParams(-4, [PRIM_SIZE, <size, 0.1, 0.2>, PRIM_COLOR, ALL_SIDES, <red, green, 0>, 1.0]);
    }
}