// Simple Walk
// Copyright (c) 2009, the owner of avatar Catherine Pfeffer
// Distributed under GPL license version 2
// See details at http://www.gnu.org/licenses/gpl-2.0.html

string VERSION = "1.0";

string animation;
string old_anim;
key owner;

default
{
    state_entry()
    {
        integer perms = llGetPermissions();
        
        animation = llGetInventoryName(INVENTORY_ANIMATION, 0);
        old_anim = "Standing";
        owner = llGetOwner();

        llSetAlpha(0.0, ALL_SIDES);
        llOwnerSay("version " + VERSION + ".");

        if (perms & PERMISSION_TAKE_CONTROLS)
            state enabled;
        llRequestPermissions(llGetOwner(),
            PERMISSION_TAKE_CONTROLS | PERMISSION_TRIGGER_ANIMATION);
    }

    run_time_permissions(integer perms)
    {
        if (perms & PERMISSION_TAKE_CONTROLS)
        {
            integer desired_controls =
                CONTROL_FWD | CONTROL_BACK | CONTROL_UP | CONTROL_DOWN;

            llTakeControls(desired_controls, TRUE, TRUE);
            state enabled;
        }
    }
}

state enabled
{
    state_entry()
    {
        llOwnerSay("ready.");
    }

    on_rez(integer param)
    {
        llResetScript();
    }

    control(key id, integer held, integer change)
    {
        string new_anim = llGetAnimation(owner);
        
        if (new_anim != old_anim)
        {
            if (new_anim == "Walking")
                llStartAnimation(animation);
            else
                llStopAnimation(animation);

            old_anim = new_anim;
        }        
    }
}
