float distance = 0.5;
float timetotake = 3.6;
float speed;
rotation backrot;
rotation forerot;
rotation stoprot;
integer channel = 1; //change this for the channel you want it to listen on


startSwing()
{
    vector vDir;
   
    speed = distance / timetotake;

    llSetTimerEvent(timetotake);
    vDir = llRot2Up(llGetRot());
    llSetRot(stoprot);
    llTargetOmega( vDir, -distance / ( 2 * timetotake ), 1.0 );
}

swingchange()
{
    vector vDir = llRot2Up(llGetRot());
   

    if( speed < 0 ) {
        llSetRot(backrot);
    } else {
        llSetRot(forerot);
    }
    llTargetOmega( vDir, speed, 1.0 );
    speed = 0 - speed;
}

integer swinging = 0;

default
{
    on_rez(integer sp)
    {
        llResetScript();
    }
       
    state_entry()
    {
        rotation rrot = llGetRot();
        vector vrot = llRot2Euler( rrot );
        stoprot = rrot;
        vrot.z += distance/2;
        backrot = llEuler2Rot( vrot );
        vrot.z -= distance;
        forerot = llEuler2Rot( vrot );

        llTargetOmega(<0,0,0>, 0, 0.0);
        swinging = 0;
        llListen(channel, "", NULL_KEY, "" );
                llSitTarget(<-1.3,.3,-.21>,<-1,-1,1,1>);//Lafe added
    }
       
    changed(integer change)
    {
    key avatar = llAvatarOnSitTarget();
    if (change & CHANGED_LINK)
        {
            if ( avatar != NULL_KEY )
            {
            swinging = 1;
            startSwing();
            }
           else
           {
            swinging = 0;
            llSetTimerEvent(0.0);
            llTargetOmega(<0,0,0>, 0, 0.0 );
            llSetRot(stoprot);
            llTargetOmega(<0,0,0>, 0, 0.0 );
           }
        }
       else
       {
            swinging = 0;
            llSetTimerEvent(0.0);
            llTargetOmega(<0,0,0>, 0, 0.0 );
            llSetRot(stoprot);
            llTargetOmega(<0,0,0>, 0, 0.0 );
       }
    }

    timer()
    {
        swingchange();
    }
      
    listen(integer number, string name, key id, string message)
    {
        if(message=="swing")
        {
            swinging = 1;
            startSwing();
        }
       
        if(message=="stop")
        {
            swinging = 0;
            llSetTimerEvent(0.0);
            llTargetOmega(<0,0,0>, 0, 0.0 );
            llSetRot(stoprot);
            llTargetOmega(<0,0,0>, 0, 0.0 );
        }
           
    }
   
   
    moving_end()
    {
        llSleep(2.0);
        llResetScript();
    }
}
