// A basic OpenSimulator Walk and Stand animation override
// All Modifications are Copyright 2010-2013 by Doug Osborn.

// This script is Licensed under the Creative Commons Attribution-Share Alike 3.0 License
//  For a copy of the license terms  please see  http://creativecommons.org/licenses/by-sa/3.0
 
// This work uses content from the Second Life® Wiki article llGetAnimation. (http://wiki.secondlife.com/wiki/LlGetAnimation)
// Copyright © 2007-2009 Linden Research, Inc. Licensed under the Creative Commons Attribution-Share Alike 3.0 License

// This AO is optimized for OpenSimulator and DOES NOT POLL the animation list multiple times a second
// It relies instead on the CHANGED ANIMATION event.  The timer is ONLY active when your avatar is swapping between stands.

// It is NOT optimized code.  Yes it could be smaller and probably faster.  This is simple, and is intended to provide a working object
// instead of a lasting tribute to anyones programming prowess.  Feel free to Optimize and re-distribute to your hearts content.

// To use:   Place this script in an object that will be attached to your avatar
//           Place the animations in the same prim
//           Change the CUSTOMIZATION section to reflect the names of YOUR animations.
//           Attach to your avatar or a HUD position
//           Click (Touch) to toggle on and off

// To Reset  Detach and re-attach the object    or   Edit the object and Reset the script

// All of the overrides available via the traditional ZHAO can be controlled via this script.  
// The following Animation Types can be used
//
// [ Standing ]
// [ Walking ]
// [ Sitting ]
// [ Sitting On Ground ]
// [ Crouching ]
// [ Crouch Walking ]
// [ Landing ]
// [ Standing Up ]
// [ Falling ]
// [ Flying Down ]
// [ Flying Up ]
// [ Flying ]
// [ Flying Slow ]
// [ Hovering ]
// [ Jumping ]
// [ Pre Jumping ]
// [ Running ]
// [ Turning Right ]
// [ Turning Left ]
// [ Floating ]
// [ Swimming Forward ]
// [ Swimming Up ]
// [ Swimming Down ]



//  **************************   Customize YOUR AO  by  changing the names of the Animations, and the cycle time for your stands here.

// Change the folling lines to reflect the animation names you want to use
list StandNames = ["rugged-stand-1", "rugged-stand-2", "rugged-stand-3"];
integer StandTime = 12;  //  change this number to the number of seconds between stands

string WalkAnimation = "Walk-Male-Medium";   //  Change this string to the name of the walk animation you want to use

string TrnRight = "AO-TurnRight-Male";      // Change this strigng to the name of your turn right animation

string TrnLeft = "AO-TurnLeft-Male";      // Change this strigng to the name of your turn left animation

string RunAnimation = "AO-Run-Male";   //  Change this string to the name of the walk animation you want to use

string SitAnimation = "AO-Sit2-Male";   //  Change this string to the name of the crouch animation you want to use
integer OverrideSit = FALSE;            //  Default to NO sit override for NPC's  

string CrouchAnimation = "AO-Crouch-Male";    //  Change this string to the name of the crouch animation you want to use

string CrouchWalkAnimation = "AO-CrouchWalk1-Male";    //  Change this string to the name of the crouch walk animation you want to use

string FlyAnimation = "AO-Fly1-Male";   //  Change this string to the name of the fly animation you want to use

string HoverAnimation = "AO-Hover-Male";   //  Change this string to the name of the hover animation you want to use

string SoftLandAnimation = "AO-Softlanding-Male";   //  Change this string to the name of the softland animation you want to use
integer LandingTime = 3;                          //  Change this to reflect the length of the standing animation in seconds.

string JumpAnimation = "AO-JumpFlip1-Male";   //  Change this string to the name of the walk animation you want to use

//  *******************************************************************************************************************************

// *****  Below there be dragons  <wink>   not really!  *******  

//  You should not need to change anything below these lines
//  You are welcome to.  If you break it, you get to keep all the parts!
//   

key Owner; // the wearer's key

string LastAnimation = ""; // last llGetAnimation value seen

string LastAnimName = "";

string WhichAnimType = "";

float StandCount = 0.0;

integer PowerStatus = 1;

vector onColor = <42,255,42>;           // all nice and green

vector offColor = <128,128,128>;        // and grey

list AnimationStates = ["Standing", "Walking", "Sitting", "Sitting On Ground", "Crouching", "Crouch Walking", "Landing", "Standing Up", "Falling", "Flying Down","Flying Up", "Flying", "Flying Slow","Hovering", "Jumping", "Pre Jumping", "Running", "Turning Right", "Turning Left", "Floating", "Swimming Forward", "Swimming Up", "Swimming Down"   ];

list DefaultAnimations= [];
  
// User functions
 
Initialize(key id) 
{
    if (id == NULL_KEY)                         // detaching
    { 
        llSetTimerEvent(0.0);                       // stop the timer
    }
    else                                        // attached, or reset while worn
    { 
        llRequestPermissions(id, PERMISSION_TRIGGER_ANIMATION);
        Owner = id;
        vector color = offColor;
        StandCount = (float) llGetListLength(StandNames);
        if(PowerStatus)
        {
            WhichAnimType = llGetAnimation(Owner);            
            StartAnimation();
            color = onColor;
        }
        llSetColor(color/255.0, ALL_SIDES);
    }
}
 
OnOff()
{
    vector color;
    
    if (PowerStatus == 0) 
    {
        PowerStatus = 1;
        WhichAnimType = llGetAnimation(Owner);
        LastAnimation = "";
        StartAnimation();
        llOwnerSay("Over-ride active");
        color = onColor;
    }
    else
    {
        PowerStatus = 0;
        llStopAnimation(LastAnimName);
        llOwnerSay("Over-ride off");
        color = offColor;
    }
    
    llSetColor(color/255.0, ALL_SIDES);
}

StartAnimation()
{
    if(PowerStatus)
    {
            if (LastAnimation != WhichAnimType)    
            { 
                if (WhichAnimType == "Walking") 
                { 
                    llStopAnimation(LastAnimName);

                    if(WalkAnimation != "")
                    {                      
                        LastAnimName = WalkAnimation;
 
                        llStartAnimation(LastAnimName);
                    }
                    
                    llSetTimerEvent(0);
                }
                
                if (WhichAnimType == "Running") 
                { 
                    llStopAnimation(LastAnimName);
                    
                    if(RunAnimation != "")
                    {                    
                        LastAnimName = RunAnimation;
 
                        llStartAnimation(LastAnimName);
                    }
                    
                    llSetTimerEvent(0);
                    
                }                                
                
                if (WhichAnimType == "Standing") 
                { 
                    llStopAnimation(LastAnimName);
                    
                    if(StandCount > 0.0)
                    {
                    
                        integer whichone = (integer)llFrand(StandCount);// pick a new stand
                    
                        LastAnimName = llList2String (StandNames,whichone);
 
                        llStartAnimation(LastAnimName);
                    
                        llSetTimerEvent(StandTime);
                    }                    
                    else
                    {
                        llSetTimerEvent(0);
                    }                        
                }  
                
                if (WhichAnimType == "Sitting") 
                { 
                    llStopAnimation(LastAnimName);
                    
                    if(SitAnimation != "" && OverrideSit)
                    {                    
                        LastAnimName = SitAnimation;
 
                        llStartAnimation(LastAnimName);
                    }                    
                    llSetTimerEvent(0);
                    
                }  
                                                            
                if (WhichAnimType == "Flying") 
                { 
                    llStopAnimation(LastAnimName);
                    
                    if(FlyAnimation != "")
                    {                    
                        LastAnimName = FlyAnimation;
 
                        llStartAnimation(LastAnimName);
                    }
                    
                    llSetTimerEvent(0);
                    
                }
                  
                if (WhichAnimType == "Hovering") 
                { 
                    llStopAnimation(LastAnimName);
                    
                    if(HoverAnimation != "")
                    {                    
                        LastAnimName = HoverAnimation;
 
                        llStartAnimation(LastAnimName);
                    }
                    
                    llSetTimerEvent(0);
                    
                }

                if (WhichAnimType == "Soft Landing") 
                { 
                    llStopAnimation(LastAnimName);
                    
                    if(SoftLandAnimation != "")
                    {                    
                        LastAnimName = SoftLandAnimation;
 
                        llStartAnimation(LastAnimName);
                        
                        llSetTimerEvent(LandingTime);
                    }
                    
                    llSetTimerEvent(0);
                    
                }
                                                
                if (WhichAnimType == "Crouching") 
                { 
                    llStopAnimation(LastAnimName);
                    
                    if(CrouchAnimation != "")
                    {                    
                        LastAnimName = CrouchAnimation;
 
                        llStartAnimation(LastAnimName);
                    }
                    
                    llSetTimerEvent(0);
                    
                }                
                
                if (WhichAnimType == "Crouch Walkinging") 
                { 
                    llStopAnimation(LastAnimName);
                    
                    if(CrouchWalkAnimation != "")
                    {                    
                        LastAnimName = CrouchWalkAnimation;
 
                        llStartAnimation(LastAnimName);
                    }
                    
                    llSetTimerEvent(0);
                    
                }                                

                if (WhichAnimType == "Jumping") 
                { 
                    llStopAnimation(LastAnimName);
                    
                    if(JumpAnimation != "")
                    {                    
                        LastAnimName = JumpAnimation;
 
                        llStartAnimation(LastAnimName);
                    }
                    
                    llSetTimerEvent(0);
                    
                } 
                
                if (WhichAnimType == "Turning Right") 
                { 
                    llStopAnimation(LastAnimName);
                    
                    if(TrnRight != "")
                    {                    
                        LastAnimName = TrnRight;
 
                        llStartAnimation(LastAnimName);
                    }
                    
                    llSetTimerEvent(0);
                    
                }                 
                
                if (WhichAnimType == "Turning Left") 
                { 
                    llStopAnimation(LastAnimName);
                    
                    if(TrnLeft != "")
                    {                    
                        LastAnimName = TrnLeft;
 
                        llStartAnimation(LastAnimName);
                    }
                    
                    llSetTimerEvent(0);
                    
                }                 
                                
            }                                                         
}
}  

                            
// Event handlers
 
default
{
    state_entry() {
        // script was reset while already attached
        if (llGetAttached() != 0) {
            Initialize(llGetOwner());
        }
    }
 
    attach(key id) {
        Initialize(id);
    }
 
    run_time_permissions(integer perm) 
    {
        if (perm & PERMISSION_TRIGGER_ANIMATION) {
            llOwnerSay("Over-ride active"); 
        }
    }
    
    touch_start(integer whodunit)
    {
        OnOff();
    }
    
    timer()
    {
        llStopAnimation(LastAnimName);
                    
        integer whichone = (integer)llFrand(StandCount);      // pick the new stand at random
        
        LastAnimName = llList2String (StandNames,whichone);
 
        llStartAnimation(LastAnimName);
                    
//        llOwnerSay( "using " + LastAnimName);    // uncomment this to see which stand gets trigger by the timer
                    
        llSetTimerEvent(StandTime);
    }        
 
    changed (integer change)
    {
        if (change & CHANGED_ANIMATION)
        {
            
            WhichAnimType = llGetAnimation(Owner);
            
            StartAnimation();

            LastAnimation = WhichAnimType; // so we can check for changes
            
//            llOwnerSay("started " + WhichAnimType);  // uncomment this to see the event types you can respond to 
                
//            llOwnerSay( "using " + LastAnimName);  // uncomment this to see which animations are being used
        
            
        }
    }
}