// ______           _  ______            _           _
// |  ___|         | | |  ___|          | |         (_)
// | |_ ___ _ __ __| | | |_ _ __ ___  __| | ___ _ __ ___  __
// |  _/ _ \ '__/ _` | |  _| '__/ _ \/ _` |/ _ \ '__| \ \/ /
// | ||  __/ | | (_| | | | | | |  __/ (_| |  __/ |  | |>  <
// \_| \___|_|  \__,_| \_| |_|  \___|\__,_|\___|_|  |_/_/\_\
//
// fred@mitsi.com
// Copyright 2012
// Mesh Horse project
// 5-24-2010


// menu  script
 
//opensim compatible

integer debug = FALSE;

integer listen_handle ; 

integer iPlayChannel = 1;     // to the animator
integer iWalkChannel=2;       // from the speed controller
integer iMenuChannel=3;       // from the menu controller 
integer iSaddleChannel=4;     // from the Saddle controller


integer LINK_RESET_SIZE = 5;
integer LINK_PLUS = 6;
integer LINK_MINUS = 7;
integer DUST_ON = 8;
integer DUST_OFF = 9;
integer iArmorChannel=10;     // for the Armor controller

list buttons;
list colorcodes ;
integer colorindex = 0;

string type      = "Horse";
string glow      = "Glow On";
string fetlock   = "Fetlock On";
string sound     = "Sound Off";
string rez       = "Trail On";
string dusty     = "Dust On";
string feetsies  = "Prints On";
integer armor = FALSE;

integer menuStart = 0;
integer menuEnd = 9;

integer playchannel = 1;    // the playback channel, this is the channel you use in LinkMessages
float Size = .010;





doTexture(integer start, integer end)
{
    string message = "Pick a skin type for your equine";
    integer count = llGetInventoryNumber(INVENTORY_TEXTURE);

    if (debug) llOwnerSay("Ntextures = " + (string) count);

    buttons = [];

    if (debug) llOwnerSay("start = " + (string) start);
    if (debug) llOwnerSay("end = " + (string) end);

    if (start == 0)
        buttons += ["-","Menu"];
    else
        buttons += ["<<<","Menu"];

    if (end < count)
        buttons += [">>>"];
    else
        buttons += ["-"];

    integer textureCounter = 0;
    integer i = 0;
    while (i  <= count)
    {
        string invname = llGetInventoryName(INVENTORY_TEXTURE,i);
        if (llStringLength(invname))
        {
            list parse = llParseString2List(invname,[" "],[""]);
            string strtype = llList2String(parse,0);
            string name = llList2String(parse,1) ;

            if (strtype == "Horse")
            {
                textureCounter++;
                if (textureCounter >=  start && textureCounter <= end)
                {
                    buttons += name;
                }
            }
        }
        i++;
    }

    

    if (debug) llOwnerSay("menuStart = " + (string) start);
    if (debug) llOwnerSay("menuEnd = " + (string) end);


    buttons = llDeleteSubList(buttons,12,99);

    integer channel = (integer) llFrand(8787) + 85687;
    listen_handle = llListen(channel, "", llGetOwner(), "");
    llDialog( llGetOwner(), message,  buttons, channel );
    llSetTimerEvent(30);

}

changeHairColor ()
{
    integer x;
    integer colorcount = llGetListLength(colorcodes);
    if (colorindex >= colorcount)
        colorindex = 0;

    vector colorcode = llList2Vector(colorcodes,colorindex);
    //llOwnerSay( (string) colorcode);

    for(x = 1; x < llGetNumberOfPrims()+ 1; x++)
    {
        string primname = llGetLinkName(x);
        if (primname == "hair")
            llSetLinkColor(x, colorcode, ALL_SIDES);    // and set the color
    }
    colorindex++;
}



changeSkin(string skin)
{
    // if (debug) llOwnerSay("Paintskin " + skin);
    integer textureNumber = llGetInventoryNumber(INVENTORY_TEXTURE) ;

    //if (debug) llOwnerSay("found  " + (string) textureNumber + " textures");

    string bodyName;

    integer i;
    for (i = 0; i < textureNumber; i++)
    {
        string textureName = llGetInventoryName(INVENTORY_TEXTURE,i);
        list delim = llParseString2List(textureName,[" "],[]);    // texture name-head-1-1 => ["texture name","head","1","1"]

        string primType = llList2String(delim,0);
        string primName  = llList2String(delim,1);

        //  if (debug) llOwnerSay("textureName:" + primName);

        if (primType == "Horse" && skin == primName)
        {
            bodyName = textureName;
            // if (debug) llOwnerSay("remembering for body texture named :" + textureName);
        }
    }
    integer x;
    integer primCount = llGetNumberOfPrims() ;

    for(x = 1; x <= primCount; x++)
    {
        string linkName = llGetLinkName(x);

        if (linkName == "body") {
            // if (debug) llOwnerSay("prim name:" + linkName);
            // if (debug) llOwnerSay("prim #" + (string) x);
            //    if (debug) llOwnerSay("applying texture:" + bodyName );
            //    if (debug) llOwnerSay("applying offsets :<" + (string) foffsetX + "," + (string) foffsetY + ",0>" );

            //string texture, vector repeats, vector offsets, float rotation_in_radian
            llSetLinkPrimitiveParamsFast(x,[PRIM_TEXTURE,ALL_SIDES, bodyName, <1,1,0>,<0,0,0>,0]);
        }
    }
}


menuSaddle()
{
    string message = "Pick a saddle for your equine";
    buttons = ["Menu","Help","None","Blue","Brown","Grey","Maroon","Red","Viking","Tooled"];
    dialog(message,buttons);
}

SizeMenu()
{
    string message = "Horse Size: make larger/smaller\n";
    list buttons = ["Menu","-", "Help","Bigger","Smaller"];
    dialog(message,buttons);

}

dialog (string message, list buttons)
{
    integer channel = (integer) llFrand(999999) + 85687;
    listen_handle = llListen(channel, "", llGetOwner(), "");
    llDialog( llGetOwner(), message,  buttons, channel );
    llSetTimerEvent(30);
}

menuColors()
{
    string message = "Pick an item to change:\n" +
        "Choose colors for saddle \n" +
        "Hair: makes the mane and tail darker/lighter\n" +
        "Coat: changes the skin\n"+
        "Saddle : changes the saddle\n"+
        "Blanket: change the horse blanket" +
        "Armor:  add or subract metalic armor";

    list buttons = ["Menu", "-", "Help","Armor","Blanket","Coat", "Hair","Saddle"];
    dialog(message,buttons);

}

Menu()
{
    string message = "Pick an item to change:\n" +

        "Pose your animal\n" +
        "Horse or Unicorn" +
        "Shrink/Grow\n" +
        "Pose the animal\n" +
        "Various special effects\n" +
        "Colors for saddle and horse\n" +
        "Camera Control";

    list buttons = ["Help","Effects","Colors","-","Pose",type];
    dialog(message,buttons);

}

menuEffects()
{
    string message = "Pick an effect:\n" +
        "Sounds can be on/off\n" +

        "Dust in your trail\n" +
        "Hoofprints on/off\n" +
        "Unicorn tip glows\n" +
        "Trail spinning disks behind";

    list buttons = ["Menu", "-", "Help",sound,  dusty, feetsies, glow, rez];
    dialog(message,buttons);
}



MenuPose()
{
    string message = "Pick a pose:\n";
    list buttons = ["Menu", "Stand", "Gallop", "Walk", "Stomp", "Balk", "Fly", "Land",  "Graze","Nod"];
    dialog(message,buttons);
}


default
{
    state_entry()
    {
        colorcodes += <0,0,0>;
        colorcodes += <0.58,0.58,0.58>;
        colorcodes += <0.298,0.176,0.125>;
        colorcodes += <0.37,0.15,0.019>;
        colorcodes += <0.26,0.14,0.117>;
        colorcodes += <1,1,1>;
    }

    touch_start(integer who)
    {
        if (llDetectedKey(0)== llGetOwner() )
        {
            Menu();
        }
    }

    listen( integer channel, string name, key id, string message )
    {
        llListenRemove(listen_handle);
        if (message == "Menu")
        {
            Menu();
        }
        else if (message == "Hair")
        {
            changeHairColor();
            menuColors();
        }
        else if (message == "Colors")
        {
            menuColors();
        }
        else if (message == "Coat")
        {
            menuStart = 0;
            menuEnd = 9;
            doTexture(menuStart,menuEnd);
        }
        else if (message == ">>>")
        {
            menuStart += 9;
            menuEnd += 9;
            doTexture(menuStart,menuEnd);
        }
        else if (message == "<<<")
        {
            menuStart -= 9;
            menuEnd -= 9;
            
            if (menuStart < 0) 
            {
                menuStart = 0;
                menuEnd = 9;
            }
          
            doTexture(menuStart,menuEnd);
        }
        else if (message == "Horse")
        {
            llMessageLinked(LINK_SET,iMenuChannel,"unicorn","");
            type = "Unicorn";
            Menu();
        }
        else if (message == "Unicorn")
        {
            llMessageLinked(LINK_SET,iMenuChannel,"horse","");
            type = "Horse";
            glow  = "Glow On";
            Menu();
        }

        // EFFECTS

        else if (message == "Effects")
        {
            menuEffects();
        }
        else if (message == "Armor")
        {
            armor = ~ armor;
            if (!armor)
                llMessageLinked(LINK_SET,iArmorChannel,"Armor","");
            else
                llMessageLinked(LINK_SET,iArmorChannel,"none","");
            menuColors();
        }
        else if (message == "Blanket")
        {
            llMessageLinked(LINK_SET,iMenuChannel,"blanket","");
            menuColors();
        }

        else if (message == "Glow Off")
        {
            llMessageLinked(LINK_SET,iMenuChannel,"glow","");
            glow  = "Glow On";
            llOwnerSay(glow);
            menuEffects();
        }
        else if (message == "Glow On")
        {
            llMessageLinked(LINK_SET,iMenuChannel,"noglow","");
            glow  = "Glow Off";
            llOwnerSay(glow);
            menuEffects();
        }
        else if (message == "Fetlock On")
        {
            llMessageLinked(LINK_SET,iMenuChannel,"nofetlock","");
            fetlock  = "Fetlock Off";
            menuEffects();
        }
        else if (message == "Fetlock Off")
        {
            llMessageLinked(LINK_SET,iMenuChannel,"fetlock","");
            fetlock  = "Fetlock On";
            menuEffects();
        }
        else if (message == "Sound Off")
        {
            llMessageLinked(LINK_SET,iMenuChannel,"soundon","");
            sound  = "Sound On";
            llOwnerSay(sound);
            menuEffects();
        }
        else if (message == "Sound On")
        {
            llMessageLinked(LINK_SET,iMenuChannel,"soundoff","");
            sound = "Sound Off";
            llOwnerSay(sound);
            menuEffects();
        }
        else if (message == "Trail Off")
        {
            llMessageLinked(LINK_SET,iMenuChannel,"trailon","");
            rez = "Trail On";
            llOwnerSay(rez);
            menuEffects();
        }
        else if (message == "Trail On")
        {
            llMessageLinked(LINK_SET,iMenuChannel,"trailoff","");
            rez = "Trail Off";
            llOwnerSay(rez);
            menuEffects();
        }
        else if (message == "Prints Off")
        {
            llMessageLinked(LINK_SET,iMenuChannel,"feetsieson","");
            feetsies = "Prints On";
            llOwnerSay(feetsies);
            menuEffects();
        }
        else if (message == "Prints On")
        {
            llMessageLinked(LINK_SET,iMenuChannel,"feetsiesoff","");
            feetsies = "Prints Off";
            llOwnerSay(feetsies);
            menuEffects();
        }
        else if (message == "Dust Off")
        {
            llMessageLinked(LINK_SET,iMenuChannel,"duston","");
            dusty = "Dust On";
            llOwnerSay(dusty);
            menuEffects();
        }
        else if (message == "Dust On")
        {
            llMessageLinked(LINK_SET,iMenuChannel,"dustoff","");
            dusty = "Dust Off";
            llOwnerSay(dusty);
            menuEffects();
        }

        // SIZE

        else if (message == "Size")
        {
            SizeMenu();
        }
        else if (message == "Bigger")
        {
            llMessageLinked(LINK_SET,LINK_PLUS,"","");
            SizeMenu();
        }
        else if (message == "Smaller")
        {
            llMessageLinked(LINK_SET,LINK_MINUS,"","");
            SizeMenu();
        }

        

        // POSES

        else if (message == "Pose")
        {
            MenuPose();
        }
        else if (message == "Stand")
        {
            llMessageLinked(LINK_SET,iPlayChannel,"stand","");
        }
        else if (message == "Walk")
        {
            llMessageLinked(LINK_SET,iPlayChannel,"stand","");
            llMessageLinked(LINK_SET,iWalkChannel,"StartWalk","");    // trigger Walk Script
            MenuPose();
        }
        else if (message == "Gallop")
        {
            llMessageLinked(LINK_SET,iWalkChannel,"stand","");
            llMessageLinked(LINK_SET,iWalkChannel,"StartRun","");    // trigger gallop Script
            MenuPose();
        }
        else if (message == "Stomp")
        {
            llMessageLinked(LINK_SET,iPlayChannel,"stand","");
            llMessageLinked(LINK_SET,iPlayChannel,"stomp","");    // trigger stomp Script
            MenuPose();
        }
        else if (message == "Balk")
        {
            llMessageLinked(LINK_SET,iPlayChannel,"stand","");
            llMessageLinked(LINK_SET,iPlayChannel,"balk","");           // trigger Walk Script
            MenuPose();
        }
        else if (message == "Fly")
        {
            llMessageLinked(LINK_SET,iPlayChannel,"stand","");
            llMessageLinked(LINK_SET,iPlayChannel,"fly","");            // play direct
            MenuPose();
        }
        else if (message == "Land")
        {
            llMessageLinked(LINK_SET,iPlayChannel,"stand","");
            llMessageLinked(LINK_SET,iPlayChannel,"land","");            // play direct
            MenuPose();
        }
        else if (message == "Graze")
        {
            llMessageLinked(LINK_SET,iPlayChannel,"stand","");
            llMessageLinked(LINK_SET,iPlayChannel,"graze","");            // play direct
            MenuPose();
        }
        else if (message == "Nod")
        {
            llMessageLinked(LINK_SET,iWalkChannel,"StartStand","");
            llMessageLinked(LINK_SET,iPlayChannel,"shake","");            // play direct
            MenuPose();
        }


        // SADDLE

        else if (message == "Saddle")
        {
            menuSaddle();
        }

        else if (message == "None")
        {
            llMessageLinked(LINK_SET,iSaddleChannel,"None","");            // play direct
            menuSaddle();
            //"None","Blue","Brown","Grey","Maroon","Red","Tooled"
        }
        else if (message == "Blue")
        {
            llMessageLinked(LINK_SET,iSaddleChannel,"Blue","");            // play direct
            menuSaddle();
        }
        else if (message == "Brown")
        {
            llMessageLinked(LINK_SET,iSaddleChannel,"Brown","");            // play direct
            menuSaddle();
        }
        else if (message == "Grey")
        {
            llMessageLinked(LINK_SET,iSaddleChannel,"Grey","");            // play direct
            menuSaddle();
        }
        else if (message == "Maroon")
        {
            llMessageLinked(LINK_SET,iSaddleChannel,"Maroon","");            // play direct
            menuSaddle();
        }
        else if (message == "Red")
        {
            llMessageLinked(LINK_SET,iSaddleChannel,"Red","");            // play direct
            menuSaddle();
        }
        else if (message == "Tooled")
        {
            llMessageLinked(LINK_SET,iSaddleChannel,"Tooled","");            // play direct
            menuSaddle();
        }
        else if (message == "Viking")
        {
            llMessageLinked(LINK_SET,iSaddleChannel,"Viking","");            // play direct
            menuSaddle();
        }
        // HELP

        else if (message == "Help")
        {
            llLoadURL(llGetOwner(),"Get online Help","http://metaverse.mitsi.com/Secondlife/Posts/Mesh-horse");
        }

        else
        {
            integer isSkin = llListFindList(buttons,[message]);
            if (isSkin > -1)
            {
                //llOwnerSay("Change skin to " + message);
                changeSkin(message);
                doTexture(menuStart,menuEnd);
            }
        }
    }

    // from the sit script, when we are attached
    link_message(integer sender_num, integer num, string message, key id)
    {
        if (message == "MENU")
            Menu();

    }



    timer()
    {
        llOwnerSay("Menu timed out, click horse for a menu");
        llListenRemove(listen_handle);
        llSetTimerEvent(0);
    }



    on_rez(integer param)
    {
       // Menu();
    }

}// end program

