

// This script will play a sound picked at random from the object's inventory.
//
// 2012, Balpien Hammerer, freely redistributable, maintain attributions.

float   TimeBetweenSounds   = 60;       // seconds
float   SoundVolume         = 1.0;      // from 0.0 to 1.0

default
{
    state_entry()
    {
        llSetTimerEvent(TimeBetweenSounds);
    }
    
    timer()
    {
        // Get number of sound files
        integer max = llGetInventoryNumber(INVENTORY_SOUND);
        
        // Pick a number at random to select one of the sound files.
        integer sel = llFloor(llFrand(max));
        
        // Get the name of the selected sound file.
        string  snd = llGetInventoryName(INVENTORY_SOUND, sel);
        
        // Play the sound file.
        llTriggerSound(snd, SoundVolume);
    }
}