
// ______           _  ______            _           _
// |  ___|         | | |  ___|          | |         (_)
// | |_ ___ _ __ __| | | |_ _ __ ___  __| | ___ _ __ ___  __
// |  _/ _ \ '__/ _` | |  _| '__/ _ \/ _` |/ _ \ '__| \ \/ /
// | ||  __/ | | (_| | | | | | |  __/ (_| |  __/ |  | |>  <
// \_| \___|_|  \__,_| \_| |_|  \___|\__,_|\___|_|  |_/_/\_\
//
// fred@mitsi.com
// Copyright 2012
// Mesh Horse project
// 4-27-2012

// Poseball script for both pose balls


integer iPlayChannel = 2;

string current;
string STANDING = "horse_sit";        // !!!  change these
string WALKING = "horse_sit walk";
string RUNNING = "horse_sit gallop";
string REARING = "horse_sit";

integer worn = FALSE;

integer seated;

//               L/R              up down
vector TARGET = <0.10,0.2,-.55>;        // 1/2 meter up, back a tenth.
vector ROT = <0, -1, 90>;    //rotated 90 degrees

default
{
    state_entry()
    {
        rotation rot     = llEuler2Rot(ROT * DEG_TO_RAD);     // convert the degrees to radians
        llSitTarget(TARGET, rot); // where they sit
    }

    attach( key id)
    {
        //llOwnerSay("attached to" +  (string) id);
        if (id) //evaluated as true if not NULL_KEY or invalid
        {
            worn = TRUE;
            llRequestPermissions(id, PERMISSION_TRIGGER_ANIMATION);
        }
        else
        {
            worn = FALSE;
            if (llGetAttached() == 0)
            {
                llStopAnimation(current);
                seated = FALSE;
            }
        }


    }    // attach


    link_message(integer sender_num, integer num, string message, key id)
    {

        if (num == iPlayChannel && seated)
        {
            // llOwnerSay("heard " + message);
            if (message == "StartStand")
            {
                llStopAnimation(current);
                llStartAnimation(STANDING);
                current = STANDING;
            }
            else if (message == "StartWalk" )
            {
                llStopAnimation(current);
                llStartAnimation(WALKING);
                current = WALKING;
            }
            else if ( message =="StartRun")            {
                llStopAnimation(current);
                llStartAnimation(RUNNING);
                current = RUNNING;
            }

        }
    }



    run_time_permissions(integer perm)
    {
        if(PERMISSION_TRIGGER_ANIMATION & perm)
        {
            llStopAnimation("sit");
            llStartAnimation(STANDING);    // you can choose a different animation for sitting
            current = STANDING;
            llMessageLinked(LINK_SET,0,"MENU","");    // tell the main script we are ready.
            seated = TRUE;
        }

    }

}
