// If door is locked, the name of the avatar who locked it.
// If door is not locked, the empty string ("").
string gLockedBy = "";

// This number must match the channel number of the lock
// and unlock objects you want to use.  If multiple doors
// have the same channel, then a single lock can lock all of
// them at once.
integer gLockChannel = 243;

openDoor()
{
    llTriggerSound("hinges_loud.wav 1", 10.0);

    rotation rot = llGetRot();
    rotation delta = llEuler2Rot(<0,0,-PI/4>);
    rot = delta * rot;
    llSetRot(rot);
    llSleep(0.25);
    rot = delta * rot;
    llSetRot(rot);
}
closeDoor()
{
    llTriggerSound("hinges_loud.wav 1", 10.0);

    rotation rot = llGetRot();
    rotation delta = llEuler2Rot(<0,0,PI/4>);
    rot = delta * rot;
    llSetRot(rot);

    llSleep(0.25);
    rot = delta * rot;
    llSetRot(rot);
}

default
{
    state_entry()
    {
        llSay(0, "Door 1.0");
        llListen(gLockChannel, "", NULL_KEY, "");
        state closed;
    }
}



state closed
{
    listen(integer channel, string name, key id, string message)
    {
        if (channel == gLockChannel)
        {
            if (message == "")
            {
                gLockedBy = "";
                //                llTriggerSound("door heavy slide slamk", 10.0);
                llSay(0, "unlocked");
            }
            else
            {
                gLockedBy = message;
                //                llTriggerSound("door heavy slide slam", 10.0);
                llSay(0, "locked");
            }
        }
    }

    touch_start(integer total_number)
    {
        string name = llDetectedName(0);
        if (name == gLockedBy || gLockedBy == "")
        {
            openDoor();
            state open;
        }
        else
        {
            //            llTriggerSound("door heavy slide slam", 10.0);
        }
    }
}

state open
{
    state_entry()
    {
        llSetTimerEvent(60);
    }
    touch_start(integer num)
    {
        closeDoor();
        state closed;
    }
    timer()
    {
        closeDoor();
        state closed;
    }
}
