1
// Script Name: Super_Prim_Animator_Motion_Compiler.lsl
// Author: Ferd Frederix
// Based on an excellent script by Allen Firethorn
// This is free software, it is not for sale at any price


// Set this to an empty string if you don't want to use the fast animation 
string fast="Fast";

integer debug = FALSE;
 
list animations;
list notecardLines;
integer notecardLine;
integer scaleset = FALSE;

//print out a line of code with the timestamp and object name commented out
SayCode(string code){
    llSleep(0.1);
    llOwnerSay(code);
}
default
{
    state_entry(){
        
    }
    
    
    // -1 is data: stand|9|<0.026306,-0.150208,0.191069>|<-0.000008,0.956309,-0.292356,0.000000>|<0.074010,0.074010,0.074010>
    // -2 is Compiler start
    
    link_message(integer sender_num,integer num, string msg, key id)
    {
        
        if (num == -1)  // clear
        {
            animations = [];
            notecardLines = [];
            notecardLine = 0;
            scaleset = FALSE;
            llOwnerSay("Compiler Ready");
        }
        else if (num == -2)  // data
        {
            // Split the line up so we can strip off the timestamp and object name
            
            notecardLines+=msg;
            notecardLine++;
            // Store the name of the animation if it is not already stored
            list primList = llParseString2List(msg,["|"],[]);
            string name = llList2String(primList,0);
            integer i = llListFindList(animations, [name]);
            
            if( i < 0 && name != llToLower("ossifrage")){
                
                if (debug) llOwnerSay("Adding Animation named " + name);
                animations+= name;
            }            
        }
        else if (num == -3) // finish, compile it
        {
            string code;
            integer i;
           
            llOwnerSay("Compiler pass 2: processing " + (string)(notecardLine + 1) + " movements and " + (string) llGetListLength(animations) + " animations");
            
           // DEBUG !!! 
            for(i = 0; i < llGetListLength(animations); i ++){
                integer j;
                string animationName = llList2String(animations, i);
                llOwnerSay("Processing " + animationName);
            }
            
            
            vector scale;
            list primList = llParseString2List(llList2String(notecardLines,0),["|"],[]);
             if(llToLower(llList2String(primList,0)) == "ossifrage" && ! scaleset)
             {
                scale =  llList2String(primList,1);
                scaleset++;
             }
             
             if (!scaleset)
             {
                llOwnerSay("Compile error: scale was not set");
                return;
             }
             
            llOwnerSay("Copy everything below this line and paste it into a new script\n");
            llOwnerSay("// Prim animation compiler by Ferd Frederix //\n\n");
            SayCode("integer playbackchannel = 1; // The default llMessageLinked number");

            SayCode("rotation calcChildRot(rotation rdeltaRot){\n"+
            "\tif (llGetAttached())\n"+
            "\t\treturn rdeltaRot/llGetLocalRot();\n"+
            "\telse\n"+
            "\t\treturn rdeltaRot/llGetRootRotation();\n"+
            "}");
            
            // Find "ossifrage" to get the original scale
             
            
             SayCode("vector originalScale = " + (string) scale +";");
             
            // Go through each animation and create a function for each one
            for(i = 0; i < llGetListLength(animations); i++){
                integer j;
                string animationName = llList2String(animations, i);
                
                if (debug)
                    llOwnerSay("Processing " + animationName);
                

                code= animationName+"(){\n"+
                    "\tvector currentSize = llGetScale();\n"+
                    "\tfloat scaleby = currentSize.x/originalScale.x;\n";
                SayCode(code);

                //Read through the list and print out the instructions for this animation
                for(j=0; j< llGetListLength(notecardLines);j++){
                    string line = llList2String(notecardLines,j);
                    list data = llParseString2List(line,["|"],[]);
                    integer primNum = llList2Integer(data,1);
                    
                    // Fixme negative numbers are supposed to be read as a delay
                    if(llList2String(data,0) == animationName){
                        if(primNum >1){
                            code = "\tllSetLinkPrimitiveParams"+fast+"("+llList2String(data,1)+
                                ", [PRIM_POSITION, "+llList2String(data,2)+"*scaleby, "+
                                "PRIM_ROTATION,calcChildRot("+llList2String(data,3)+"), "+
                                "PRIM_SIZE, "+llList2String(data,4)+"*scaleby]);";
                            SayCode(code);

                        } else {

                            SayCode("\tllSleep("+(string)(primNum*-1)+");");

                        }
                    }
                }
                code="}";
                SayCode(code);

            }
            
            code="default{\n"+
                "\tstate_entry(){\n";
            
            // alloow  512 bytes of stack for subroutine calls
             code += "\t\tllSetMemoryLimit(llGetUsedMemory() + 512);\n\t}\n";
                
            SayCode(code);
            
            for(i=0; i<llGetListLength(animations);i++){
                code+="\t\t"+llList2String(animations,i)+"();\n"+
                "\t\tllSleep(0.1);\n";
            }
            

            code = "link_message(integer sender_num, integer num, string message, key id){\n"+
            "\t\tif(num == playbackchannel){\n";
            for(i=0; i<llGetListLength(animations);i++){
                code+="\t\t\tif(message == \""+llList2String(animations,i)+"\"){\n"+
                "\t\t\t\t"+llList2String(animations,i)+"();\n"+
                "\t\t\t}\n";
            }
            code += "\t\t}\n"+
            "\t}\n}";
            SayCode(code);

            SayCode("Done!  Copy everything above to a new script, and delete the time stamp and object name on the left");
            
        }
    }
 
   
}

