// ______           _  ______            _           _
// |  ___|         | | |  ___|          | |         (_)
// | |_ ___ _ __ __| | | |_ _ __ ___  __| | ___ _ __ ___  __
// |  _/ _ \ '__/ _` | |  _| '__/ _ \/ _` |/ _ \ '__| \ \/ /
// | ||  __/ | | (_| | | | | | |  __/ (_| |  __/ |  | |>  <
// \_| \___|_|  \__,_| \_| |_|  \___|\__,_|\___|_|  |_/_/\_\
//
// fred@mitsi.com
// Copyright 2012
// Mesh Horse project
// 4-29-2012

// resizer


integer LINK_RESET_SIZE = 5;
integer LINK_PLUS = 6;
integer LINK_MINUS = 7;


float GROWTH_AMOUNT = 0.10; // 10% size increase



integer debug = FALSE;



DEBUG(string msg)
{
    if (debug)
        llOwnerSay(llGetScriptName() + " : " + msg);
}


float   cur_scale = 1.0;
list link_scales = [];
list link_positions = [];


integer scanLinkset()
{
    integer link_qty = llGetNumberOfPrims();
    integer link_idx;
    vector link_pos;
    vector link_scale;

    //script made specifically for linksets, not for single prims
    if (link_qty > 1)
    {
        //link numbering in linksets starts with 1
        for (link_idx=1; link_idx <= link_qty; link_idx++)
        {
            link_pos=llList2Vector(llGetLinkPrimitiveParams(link_idx,[PRIM_POSITION]),0);
            link_scale=llList2Vector(llGetLinkPrimitiveParams(link_idx,[PRIM_SIZE]),0);

            link_scales    += [link_scale];
            link_positions += [(link_pos-llGetRootPosition())/llGetRootRotation()];
        }
    }
    else
    {
        llOwnerSay("error: this script doesn't work for non-linked objects");
        return FALSE;
    }


    return TRUE;
}

resizeObject(float scale)
{
    integer link_qty = llGetNumberOfPrims();
    integer link_idx;
    vector new_size;
    vector new_pos;

    if (link_qty > 1)
    {
        //link numbering in linksets starts with 1
        for (link_idx=1; link_idx <= link_qty; link_idx++)
        {
            new_size   = scale * llList2Vector(link_scales, link_idx-1);
            new_pos    = scale * llList2Vector(link_positions, link_idx-1);

            if (link_idx == 1)
            {
                //because we don't really want to move the root prim as it moves the whole object
                llSetLinkPrimitiveParamsFast(link_idx, [PRIM_SIZE, new_size]);
            }
            else
            {
                llSetLinkPrimitiveParamsFast(link_idx, [PRIM_SIZE, new_size, PRIM_POSITION, new_pos]);
            }
        }
    }
}

default
{
    state_entry()
    {
        scanLinkset();
    }

    link_message(integer sender, integer num, string str, key id)
    {

        if (num == LINK_RESET_SIZE)
        {
            cur_scale = 1.0;
            resizeObject(cur_scale);
        }
        else if (num == LINK_PLUS)
        {
            cur_scale = cur_scale * (GROWTH_AMOUNT + 1.0);     // new size is 110%, 120%, etc of the original size
            DEBUG("Growing " + (string) cur_scale);
            resizeObject(cur_scale);
        }
        else if (num == LINK_MINUS)
        {
            cur_scale = cur_scale * (1 - GROWTH_AMOUNT );     // new size is 110%, 120%, etc of the original size
            DEBUG("Shrinking " + (string) cur_scale);
            resizeObject(cur_scale);
        }
    }
}


