// Arcadia's Sit Script 2013 by Aaack Aardvark
// Welcome, curious one, this is basically an animation script
// it sends a dialog to the user that sits on the chair to choose
// the sit pose.  If it chooses another it stops the previous pose
// animation and starts the next (to prevent animation mixing).
// Since I can't change the sit target on the fly I made six
// animations that shares the same center, so the avie doesn't
// fly around between poses.

// Variables you can touch safely:

// Menu Time out, by default if you don't touch the menu it kills the
// listener after 30 seconds, you can change this behaviour here:

float timeout = 30.0;

// Sit target: You can fine tune the position of your avatar on the
// chair, for perfect adjust, this varies wildly between avatars tho
// so what it fits fine for you it may look horrible for others.  Gotta
// love virtuality...

// The more the front, the less the back the avatar goes:

float fb = 0.05;

// The more the higher the less the lower the avie will be:

float ud = -0.2;

// That's it, if you touch the rest you can break it bad, but hey, it's
// free! so experiment and have fun! =D
// The Arcadia Family.

integer fono;
integer level;
integer escuchador;
list menu;
string anim;
key avie;
string current;
default
{
    state_entry()
    {
        menu = ["-", "Close", "Unsit", "Female 01", "Female 02", "Desktop", "Male 01", "Male 02", "Unisex"];
        fono = (integer)("0x" + llGetSubString((string)llGetKey(),-1,-8));
        llSitTarget(<0.0, fb, ud>, llEuler2Rot(<0, 0, -90> * DEG_TO_RAD));
        level = 0;
    }
    changed(integer change)
    {
        if (change & CHANGED_LINK)
        {
            avie = llAvatarOnSitTarget();
            escuchador = llListen(fono, "", avie, "");
            llSetTimerEvent(timeout);
            if (avie != NULL_KEY)
            {
                llDialog (avie, "Choose your sit:", menu, fono);
                anim = "Sit01";
                current = "sit";
                llRequestPermissions(avie, PERMISSION_TRIGGER_ANIMATION);
            }
            else
            {
                if (anim)
                {
                    llStopAnimation(anim);
                }
                llListenRemove(escuchador);
                llResetScript();
            }
        }
    }
    touch_start(integer x)
    {
        if (llDetectedKey(0) == avie)
        {
            escuchador = llListen(fono, "", avie, "");
            llSetTimerEvent(timeout);
            llDialog (avie, "Choose your sit:", menu, fono);
        }
    }
    listen (integer ww, string name, key id, string xxx)
    {
        if (level == 0)
        {
            if (xxx == "Close")
            {
                llSetTimerEvent(0);
                llListenRemove(escuchador);
            }
            if (xxx == "-")
            {
                llDialog(id, "Choose your sit:", menu, fono);
                llSetTimerEvent(timeout);
            }
            if (xxx == "Unsit")
            {
                llSetTimerEvent(0);
                llListenRemove(escuchador);
                if (anim)
                {
                    llStopAnimation(anim);
                }
                llUnSit(avie);
                llResetScript();
            }
            if (xxx == "Male 01")
            {
                llDialog(id, "Choose your sit:", menu, fono);
                anim = "Sit01";
                llRequestPermissions(id, PERMISSION_TRIGGER_ANIMATION);
                llSetTimerEvent(timeout);
            }
            if (xxx == "Unisex")
            {
                llDialog(id, "Choose your sit:", menu, fono);
                anim = "Sit02";
                llRequestPermissions(id, PERMISSION_TRIGGER_ANIMATION);
                llSetTimerEvent(timeout);
            }
            if (xxx == "Male 02")
            {
                llDialog(id, "Choose your sit:", menu, fono);
                anim = "Sit03";
                llRequestPermissions(id, PERMISSION_TRIGGER_ANIMATION);
                llSetTimerEvent(timeout);
            }
            if (xxx == "Female 01")
            {
                llDialog(id, "Choose your sit:", menu, fono);
                anim = "Sit04";
                llRequestPermissions(id, PERMISSION_TRIGGER_ANIMATION);
                llSetTimerEvent(timeout);
            }
            if (xxx == "Female 02")
            {
                llDialog(id, "Choose your sit:", menu, fono);
                anim = "Sit05";
                llRequestPermissions(id, PERMISSION_TRIGGER_ANIMATION);
                llSetTimerEvent(timeout);
            }
            if (xxx == "Desktop")
            {
                llDialog(id, "Choose your sit:", menu, fono);
                anim = "Sit06";
                llRequestPermissions(id, PERMISSION_TRIGGER_ANIMATION);
                llSetTimerEvent(timeout);
            }
        }
    }
    run_time_permissions(integer perm)
    {
        if (perm & PERMISSION_TRIGGER_ANIMATION)
        {
            if (anim)
            {
                llStopAnimation(current);
                llStartAnimation(anim);
                current = anim;
            }
        }
    }
    timer()
    {
        llListenRemove(escuchador);
        llSetTimerEvent(0);
    }
} 