1// Animator front-end for Compiler Script

integer runtime = TRUE; // set to TRUE after making the scripts
integer playchannel = 1;    // the playback channel, this is the channel you use in LinkMessages
integer debug = FALSE;          // if set to TRUE, debug info appears


// database 
string priorname;               // the prior animation name so we can spot differences as we read them in
integer move = 0;               // N movements rea from the notecard
//communications
integer dialogchannel ;         // dialog boxes 

integer nPrims;                 // total number of prims
integer PrimsCounter = 0;       // how many have checked in

integer wantname;               // flag indicating we are waiting for a name to be chatted


// the list of coords 
list masterlist;        // master list of all positions
list llastPrimList;      // storage of the last prim position we learned
string curranimation;   // what we are playing

integer STRIDE = 5;     // size of the master list
integer lastSTRIDE = 3; // size of the last prim list

integer listener;       // temp listener when we are waiting for them to give us a name

vector InitSize;        // the initial size when the prims were recorded
list LoadedAnims;       // animations read from the notecard added to the Menu display



Record()
{
    if (llStringLength(curranimation) > 0)
    {
        integer foundmovement = 0;      // will be set if any child moved
        integer PrimCounter ;        // skip past the root prim
        for (PrimCounter =2; PrimCounter <= nPrims; PrimCounter++ )
        {
            
            //if (debug) llOwnerSay("Checking Prim " + (string) PrimCounter);
            
            list my_list = llGetLinkPrimitiveParams(PrimCounter,[PRIM_POSITION,PRIM_ROTATION, PRIM_SIZE ]);
            // position is always in region coordinates, even if the prim is a child or the root prim of an attachment.
            // rot is always the global rotation, even if the prim is a child or the root prim of an attachment.               
            // get current prim pos, rot and size
            vector      vrealPrimPos    = llList2Vector (my_list,0) - llGetPos();   // position subtract Global Pos
            vrealPrimPos /= llGetRot();
            rotation    rrealPrimRot    = llList2Rot    (my_list,1) / llGetRot();   // rotation subtract Global Rot
            vector      vrealPrimSize   = llList2Vector (my_list,2);                 // size  
            
            // compare it to the last one we had
            integer iindex = (PrimCounter - 2) * lastSTRIDE;    // zeroth position is PrimCounter - start, or 2
            
            // get the last thing we remembered about this prim
            vector      vlastPrimPos    = llList2Vector     (llastPrimList, iindex);
            rotation    rlastPrimRot    = llList2Rot        (llastPrimList, iindex+1);
            vector      vlastPrimSize   = llList2Vector     (llastPrimList, iindex+2);
            
             // show developer any changes they made
            if (debug)    
            {
                llOwnerSay("prim:" + (string) PrimCounter);
            
                if (vlastPrimPos != vrealPrimPos)
                    llOwnerSay((string) vrealPrimPos + ":" + (string) vlastPrimPos + "pos delta :" + (string) (vrealPrimPos - vlastPrimPos));
                    
                if (rlastPrimRot != rrealPrimRot)
                    llOwnerSay("rot delta:" + (string) (llRot2Euler (rrealPrimRot - rlastPrimRot) * RAD_TO_DEG));                   
                    
                if (vlastPrimSize != vrealPrimSize)
                    llOwnerSay("size delta:" + (string) (vrealPrimSize - vlastPrimSize));
            }
                
            // if anything changed on this prim, we must record it.
            if (vlastPrimPos != vrealPrimPos ||
                rlastPrimRot != rrealPrimRot ||
                vlastPrimSize!= vrealPrimSize  
            )
            {                        
                foundmovement++;
                
                //Save changes in the master list of all animations
                masterlist += curranimation;
                masterlist += PrimCounter;
                masterlist += vrealPrimPos;
                masterlist += rrealPrimRot;
                masterlist += vrealPrimSize;
              
                // update the last movement list
                llastPrimList = llListReplaceList(llastPrimList,[vrealPrimPos],iindex,iindex);
                llastPrimList = llListReplaceList(llastPrimList,[rrealPrimRot],iindex+1,iindex+1);
                llastPrimList = llListReplaceList(llastPrimList,[vrealPrimSize],iindex+2,iindex+2);
                 
            } // if
            else
            {
                if (debug)   llOwnerSay("No movement in prim " + (string) PrimCounter);
            }
        } // for
       
         if (debug)    llOwnerSay("history:" + llDumpList2String(llastPrimList,":"));                   
        
        if (foundmovement)
        {
            llOwnerSay("Recorded " + (string) foundmovement + " prims" );
        }
        else
        {
            llOwnerSay("You must move at least one child prim.");
        }
    }         
    else
    {
        llOwnerSay("You must name your animation.");
        llOwnerSay("Type the new animation name on channel /" + (string) dialogchannel);
        wantname++;
    }
}

// on reset, record the base position in history so we can see changes
Clear()
{
    llMessageLinked(LINK_SET,-1,"","");
    LoadedAnims = [];           // wipe out Menu
    masterlist = [];            // wipe all recordings
    llastPrimList = [];         // wipe last animations
    integer PrimCounter ;       // skip 1, which is the root prim
    integer counter = 0;
    // save all the current settings in memory
    for (PrimCounter=2; PrimCounter <= nPrims; PrimCounter++ )
    {
        list my_list = llGetLinkPrimitiveParams(PrimCounter,[PRIM_POSITION,PRIM_ROTATION, PRIM_SIZE ]);
        
        // save the local  pos and rot, since llGetLinkPrimitiveParams returns global pos and rot
        vector primpos      = llList2Vector (my_list,0) - llGetPos();
        primpos /= llGetRot();
        rotation primrot    = llList2Rot    (my_list,1) / llGetRot();
        vector primsize     = llList2Vector (my_list,2) ;
        

        llastPrimList += primpos;
        llastPrimList += primrot;
        llastPrimList += primsize;
        counter++;
    }
    llOwnerSay("There are " + (string) counter + " animatable prims");
}

DumpBack ()
{
    integer i;
    integer imax = llGetListLength(masterlist);
    integer howmany = imax / STRIDE ;
    float sleep = 0.1;
    integer amount = llCeil(sleep * howmany);
    llOwnerSay("Preprocessing " + (string) howmany + " movements. Please wait " + (string) (amount+1)  + " seconds" );
    
    // tell the compiler the original size

    llMessageLinked(LINK_SET,-2, "|ossifrage|" + (string) llGetScale(),"");
    
    integer flag = 0;
    for (i = 0; i < imax; i+= STRIDE)
    {
             
        string saniName = llList2String(masterlist,i);
        curranimation = saniName;

        float fprimNum = llList2Float(masterlist,     i+1);
        integer iprimNum = (integer) fprimNum;
        vector  vprimPos  = llList2Vector(masterlist,   i+2);
        rotation rprimRot = llList2Rot(masterlist,      i+3) ;
        vector  vprimSize  = llList2Vector(masterlist,  i+4);

        string msg =  saniName + "|" + (string) iprimNum + "|" + (string) vprimPos + "|" + (string) rprimRot + "|" + (string) vprimSize ;
        
        llMessageLinked(LINK_SET,-2,msg,"");
        if (debug) llOwnerSay(msg);
        llSleep(sleep);   //  be nice
        flag++;
    }
    
    if (flag)
    {
        llSleep(1);
        llOwnerSay("Compiling " + (string) flag + " movements");
        llMessageLinked(LINK_SET,-3,"","");
    }
    else 
        llOwnerSay("No recording was made, nothing to compile!" );
}


rotation calcChildRot(rotation rdeltaRot)
{
    
    if (llGetAttached())
        return rdeltaRot/llGetLocalRot();
    else
        return rdeltaRot/llGetRootRotation();
   
}


PlayBack (string name)
{
    integer i;
    integer imax = llGetListLength(masterlist);

    integer linknum = 0;

    for (i = 0; i < imax; i+= STRIDE)
    {
        string saniName = llList2String(masterlist,i);
        if (saniName == name)
        {
            float fprimNum      = llList2Float(masterlist,i+1);
            vector  vPos    = llList2Vector(masterlist,i+2);
            rotation rRot = llList2Rot(masterlist,i+3) ;
            vector vprimSize    = llList2Vector(masterlist,i+4) ;
            
            vector scale = llGetScale();
            float delta =  scale.x / InitSize.x ;   // see if the root prim has grown or shrunk as a percentage      
            
            vPos *= delta;                           // add any difference in size to it positions there
            vprimSize *= delta;                      // grow the child prim, too
        
            // support negative prim numbers as a delay
            if (fprimNum < 0)
            {
                if (debug) llOwnerSay("Sleeping " + (string) (fprimNum * -1));
                llSleep((float) fprimNum * -1);
            }
            else
            {            
                // set the local pos and locat rot to the prims orientation and position
                rRot  = calcChildRot(rRot);
    
                list actions = [PRIM_POSITION,vPos,PRIM_ROTATION,rRot,PRIM_SIZE,vprimSize];
                if (debug) llOwnerSay("Moving prim :" + (string) fprimNum + ":" + llDumpList2String(actions,":"));
            
                llSetLinkPrimitiveParamsFast((integer) fprimNum,actions);
            }
        }
    }
}

MakeMenu()
{
    list amenu = ["Reset","Record","Help","Name","Compile","Pause", "Finish"] + LoadedAnims;

    llListenRemove(listener);
    listener = llListen(dialogchannel,"","","");
    
    amenu = llDeleteSubList(amenu,12,99);
    
    llDialog(llGetOwner(), "Pick a command",amenu,dialogchannel);
}



default
{
    state_entry()
    {
        InitSize = llGetScale();            // save the size  when we recorded the prims
        nPrims = llGetNumberOfPrims();      // how many we are recording
        llOwnerSay("Prim count = " + (string) nPrims);
        Clear();                            
        
        dialogchannel = (integer) (llFrand(100) +600);
        MakeMenu();

    }


    touch_start(integer total_number)
    {
        
        
    
        
        if (llDetectedKey(0) == llGetOwner() && ! runtime)
        {
            llOwnerSay("FreeMemory="+(string)llGetFreeMemory());
            MakeMenu();
        }
        
        // add any control code here
        // example:
        // llMessageLinked(LINK_SET,playchannel,"All","");  // will play Animation named "All"
        
    }

    listen( integer channel, string name, key id, string message )
    {

        if (channel == dialogchannel)
        {
            
            if (message == "Finish") 
            {
                runtime = TRUE;
            }
            else if (message == "Reset")
            {
                llResetScript();
            }
            else if (message =="Pause")
            {
                masterlist += curranimation;
                masterlist += -1;
                masterlist += <0,0,0>;  // pos
                masterlist += <0,0,0,1>;// rot
                masterlist += <0,0,0>;  // size
                MakeMenu();
            }
            else if (message == "Record")
            {
                Record();
                MakeMenu();
            }
            else if (message == "Name")
            {
                llOwnerSay("Enter a new name, or type the animation name on channel /" + (string) dialogchannel);
                
                wantname++;
                MakeMenu();
                llTextBox(llGetOwner(),"Enter an Animation Name",dialogchannel);
            }
            else if (message =="Menu")
            {
                MakeMenu();
            }
            else if (message == "Compile")
            {
                DumpBack();
                MakeMenu();
            }
            else if (message == "Help")
            {
                llLoadURL(llGetOwner(),"View online help", "http://secondlife.mitsi.com/secondlife/Posts/Prim-Compiler");
            }
            else if (wantname)
            {
                curranimation = message;
            
                LoadedAnims += message;
                
                MakeMenu();
                llOwnerSay("Recording is ready for animation '" + curranimation + "'");
                llOwnerSay("Position any child  prims, then select the menu item 'Record', and repeat as necessary. When finished, click 'Compile' to save the animation, or click the animation name to play it back.  Click 'Name' to start a new animation sequence");
                wantname = 0;
                PrimsCounter = 0;
            }
            else
            {
                if (llListFindList(LoadedAnims,[message]) != -1)
                {
                    PlayBack(message);
                    MakeMenu();
                }
            }
                
                
        }
    }

}


 