
// ______           _  ______            _           _
// |  ___|         | | |  ___|          | |         (_)
// | |_ ___ _ __ __| | | |_ _ __ ___  __| | ___ _ __ ___  __
// |  _/ _ \ '__/ _` | |  _| '__/ _ \/ _` |/ _ \ '__| \ \/ /
// | ||  __/ | | (_| | | | | | |  __/ (_| |  __/ |  | |>  <
// \_| \___|_|  \__,_| \_| |_|  \___|\__,_|\___|_|  |_/_/\_\
//
// fred@mitsi.com
// Copyright 2012
// Mesh Horse project
// 5-25-2010
 


integer debug = FALSE;

integer soundon = TRUE;
integer iPlayChannel = 1; // to the animator
integer iWalkChannel=2;     // from the speed controller

integer flag;
float t_time; // holds the timer so we can start faster
integer WALK = 1;
integer GALLOP = 2;
integer NONE = 0;

integer DUST_ON = 8;
integer DUST_OFF = 9;

key WALKSOUND = "horse_gallop3";
key GALLOPSOUND = "horse_walk1";


integer ok;  // to start anims
stand()
{
    llSleep(0.5);
    llMessageLinked(LINK_ROOT,iPlayChannel,"stand","");
}

DEBUG(string msg)
{
    if (debug) llOwnerSay(msg);
}


default
{
    on_rez(integer param)
    {
        llResetScript();
    }
    
    state_entry() {
        stand();
    

    }
    

    timer()
    {
        if (flag == WALK)
        {
            if (soundon)
                llTriggerSound(WALKSOUND,1.0);            // walk sound
            llMessageLinked(LINK_ROOT,iPlayChannel,"walk","");
            llSetTimerEvent(t_time);
        }
        else if (flag == GALLOP)
        {
            if (soundon)
                llTriggerSound(GALLOPSOUND,1.0);            // gallop sound
            llMessageLinked(LINK_ROOT,iPlayChannel,"gallop","");
            llSetTimerEvent(t_time);
        }
        else
        {
            llSetTimerEvent(0);
        }
    
        
    }
    
   
   link_message(integer sender_num, integer num, string message, key id)
    {
        
        if (message == "soundon")
            soundon = TRUE;
        else if (message == "soundoff")
            soundon = FALSE;
            
        if (num != iWalkChannel)
            return;
            
        DEBUG(message);
        if (message == "StartStand") 
        {
            llSetTimerEvent(0);
            flag = 0;
            stand();
        }
        
        else if (message == "StartWalk")
        {
            t_time = 0.9;
            llSetTimerEvent(.01);
            flag = WALK;
        }
        
        else if (message == "StartRun")
        {
            t_time = 0.8;
            llSetTimerEvent(.01);
            flag = GALLOP;
        }
        

        else 
        {
            flag = 0;
            llSetTimerEvent(0);
        }
        
       

    }
    
 
}
        
            
