// Arcadia's Sit Script 2013 by Aaack Aardvark
// Welcome, curious one, this is basically an animation script
// it sends a dialog to the user that sits on the chair to choose
// the sit pose.  If it chooses another it stops the previous pose
// animation and starts the next (to prevent animation mixing).
// Since I can't change the sit target on the fly I made six
// animations that shares the same center, so the avie doesn't
// fly around between poses.

// Variables you can touch safely:

// Menu Time out, by default if you don't touch the menu it kills the
// listener after 30 seconds, you can change this behaviour here:

float timeout = 30.0;

// That's it, if you touch the rest you can break it bad, but hey, it's
// free! so experiment and have fun! =D
// The Arcadia Family.

integer fono;
integer level;
integer escuchador;
list menu;
string anim;
key avie;
string current;
default
{
    state_entry()
    {
        menu = ["Unsit", "-", "Close", "Female", "Male", "-"];
        fono = (integer)("0x" + llGetSubString((string)llGetKey(),-1,-8));
        llSitTarget(<-0.046174,0.015707,-0.3>, <-0.002783,-0.043269,0.130512,-0.890498>);
        level = 0;
    }
    changed(integer change)
    {
        if (change & CHANGED_LINK)
        {
            avie = llAvatarOnSitTarget();
            escuchador = llListen(fono, "", avie, "");
            llSetTimerEvent(timeout);
            if (avie != NULL_KEY)
            {
                llDialog (avie, "Choose your sit:", menu, fono);
                anim = "Arcadia's ArtDeco Chair - Male";
                current = "sit";
                llRequestPermissions(avie, PERMISSION_TRIGGER_ANIMATION);
            }
            else
            {
                if (anim)
                {
                    llStopAnimation(anim);
                }
                llListenRemove(escuchador);
                llResetScript();
            }
        }
    }
    touch_start(integer x)
    {
        if (llDetectedKey(0) == avie)
        {
            escuchador = llListen(fono, "", avie, "");
            llSetTimerEvent(timeout);
            llDialog (avie, "Choose your sit:", menu, fono);
        }
    }
    listen (integer ww, string name, key id, string xxx)
    {
        if (level == 0)
        {
            if (xxx == "Close")
            {
                llSetTimerEvent(0);
                llListenRemove(escuchador);
            }
            if (xxx == "-")
            {
                llDialog(id, "Choose your sit:", menu, fono);
                llSetTimerEvent(timeout);
            }
            if (xxx == "Unsit")
            {
                llSetTimerEvent(0);
                llListenRemove(escuchador);
                if (anim)
                {
                    llStopAnimation(anim);
                }
                llUnSit(avie);
                llResetScript();
            }
            if (xxx == "Male")
            {
                llDialog(id, "Choose your sit:", menu, fono);
                anim = "Arcadia's ArtDeco Chair - Male";
                llRequestPermissions(id, PERMISSION_TRIGGER_ANIMATION);
                llSetTimerEvent(timeout);
            }
            if (xxx == "Female")
            {
                llDialog(id, "Choose your sit:", menu, fono);
                anim = "Arcadia's ArtDeco Chair - Female";
                llRequestPermissions(id, PERMISSION_TRIGGER_ANIMATION);
                llSetTimerEvent(timeout);
            }
        }
    }
    run_time_permissions(integer perm)
    {
        if (perm & PERMISSION_TRIGGER_ANIMATION)
        {
            if (anim)
            {
                llStopAnimation(current);
                llStartAnimation(anim);
                current = anim;
            }
        }
    }
    timer()
    {
        llListenRemove(escuchador);
        llSetTimerEvent(0);
    }
}