// ______           _  ______            _           _
// |  ___|         | | |  ___|          | |         (_)
// | |_ ___ _ __ __| | | |_ _ __ ___  __| | ___ _ __ ___  __
// |  _/ _ \ '__/ _` | |  _| '__/ _ \/ _` |/ _ \ '__| \ \/ /
// | ||  __/ | | (_| | | | | | |  __/ (_| |  __/ |  | |>  <
// \_| \___|_|  \__,_| \_| |_|  \___|\__,_|\___|_|  |_/_/\_\
//
// fred@mitsi.com
// Copyright 2012
// Mesh Horse project
//2-19-2012


// high level movement script

integer debug = FALSE;

// sounds
string gallopSound = "horse_gallop3";
string walkSound =  "horse_walk1";
string blow = "blow1";
string balk = "whinny1";


vector priorpos; // last position we were at
integer soundtimer = 0; // a counter that controls idel anims

// movement states
integer mystate = 0;
integer STAND = 0;
integer WALK = 1;
integer GALLOP = 2;
integer FLY = 3;


key owner; // you

integer soundon = TRUE;
// Link messages
integer iPlayChannel = 1; // to the animator
integer iWalkChannel = 2; // from the speed controller

integer DUST_ON = 8;
integer DUST_OFF = 9;


DEBUG(string msg)
{
    if (debug) llOwnerSay(msg);
}

playSound(string name)
{
    if (soundon)
    {
        DEBUG(name);
        llTriggerSound(name,1.0);
    }
}


default
{
    state_entry()
    {
        owner = llGetOwner();
        llSetTimerEvent(0.5);
        priorpos = llGetPos();
        soundon = TRUE;
    }
    
    on_rez(integer p)
    {
        llResetScript();
    }

    timer()
    {
        vector pos = llGetPos();
        integer  avistate = llGetAgentInfo(owner);

        // down arrow
        if (avistate & AGENT_CROUCHING)
        {
            playSound(balk);

            llMessageLinked(LINK_SET,DUST_ON,"","");
            llMessageLinked(LINK_SET,iPlayChannel,"balk","");
            llSleep(1);
            llMessageLinked(LINK_SET,DUST_OFF,"","");
            priorpos = pos;
            return;
        }

        // start flying
        if (avistate & (AGENT_FLYING) )
        {
            if ( mystate != FLY) 
            {
               // DEBUG("flying");

                llMessageLinked(LINK_SET,iPlayChannel,"fly","");
                llMessageLinked(LINK_SET,iWalkChannel,"fly","");
                llMessageLinked(LINK_SET,DUST_OFF,"","");
                mystate = FLY ;
                priorpos = pos;
            }
            return;
        }
        
    
        // landing
        if (! (avistate & (AGENT_FLYING)) && mystate == FLY)
        {
           // DEBUG("Landing");
            mystate = STAND;
            llMessageLinked(LINK_SET,iPlayChannel,"land","");
            llSleep(1.0);
            llMessageLinked(LINK_SET,iPlayChannel,"stand","");
            llMessageLinked(LINK_SET,DUST_ON,"","");
            priorpos = pos;
            return;
        }


        if (avistate & AGENT_IN_AIR)
        {
            return;
        }

        // not crouching or flying       
        float distance = llVecDist(pos, priorpos);
        priorpos = pos;
          
        if (distance > 2 && mystate != GALLOP)
        {
            //DEBUG("Gallop");
            mystate = GALLOP;
            llMessageLinked(LINK_SET,iWalkChannel,"StartRun","");
            llMessageLinked(LINK_SET,DUST_ON,"","");
            return;
        }
        else if (distance > 0.01  && distance <= 2 && mystate != WALK)
        {
           // DEBUG("Walk");
            mystate = WALK;
            llMessageLinked(LINK_SET,iWalkChannel,"StartWalk","");
            llMessageLinked(LINK_SET,DUST_ON,"","");
            return;
        }
        else if (distance <= 0.1 && mystate != 0)
        {
           // DEBUG("Stand");
            llMessageLinked(LINK_SET,iWalkChannel,"StartStand","");
            mystate = STAND;
            llMessageLinked(LINK_SET,DUST_OFF,"","");
        }

        // every 20 seconds.... assuming we are doing nothing else
        if (mystate == STAND && soundtimer++ % 5 == 0)
        {
           // DEBUG("Idle timer");
            integer random = llCeil(llFrand(10.0));  // 5/10 (50% chance)
            if (random ==1) 
            {
                //DEBUG("Shake");
                playSound(blow);
                llMessageLinked(LINK_SET,iPlayChannel,"shake","");
                llSleep(1);
                llMessageLinked(LINK_SET,iPlayChannel,"stand","");
            }
            else if (random == 2)
            {
                //DEBUG("Graze");
                llMessageLinked(LINK_SET,iPlayChannel,"graze","");
                llSleep(5);
                llMessageLinked(LINK_SET,iPlayChannel,"stand","");
            }
   
            else if (random == 3|| random == 4 || random == 5)
            {
                //DEBUG("Blink");
               llMessageLinked(LINK_SET,0,"blink","");
            }
            else if (random == 6)
            {
                //DEBUG("Stomp");
                playSound(balk);
                llMessageLinked(LINK_SET,DUST_ON,"","");
                llMessageLinked(LINK_SET,iPlayChannel,"stomp","");
                llSleep(1);
                 llMessageLinked(LINK_SET,DUST_OFF,"","");
            }
            
        }
       
    }    // timer
   

    link_message(integer sender, integer num, string str, key id)
    {
        //DEBUG((string) num + ":" + str);

        if (str == "soundon")
            soundon = TRUE;
        else if (str == "soundoff")
            soundon = FALSE;
    }

}


