float delay=0.1; 
vector      m_NEXTPOS;
vector      m_NEXTFWD;
rotation    m_NEXTROT;
integer     m_STEPS = 64;

motionTo(vector dest,rotation rot) {
    integer i;
    vector currentpos   = llGetPos();
    vector step         = (dest - currentpos) / m_STEPS;
   
    for (i = 1;i <= m_STEPS; i++) 
    {       
        if (i == (m_STEPS / 2)) 
        {
            llSetRot(rot);
        }
        llSetPos(currentpos + (step * i));
        //llSleep(delay);
    }
        llSensor("Track",NULL_KEY,ACTIVE | PASSIVE,10,PI/4);
}

default {
    state_entry()    {
        llSensor("Track",NULL_KEY,ACTIVE | PASSIVE,10,PI/4);
    }
   
    sensor(integer n) {
        m_NEXTPOS = llDetectedPos(0);
        m_NEXTROT = llDetectedRot(0);
        m_NEXTFWD = llRot2Fwd(m_NEXTROT) / 10;
       
        motionTo(m_NEXTPOS + m_NEXTFWD,m_NEXTROT);
    }
    no_sensor()
    {
        llSleep(10);
        llSensor("Track",NULL_KEY,ACTIVE | PASSIVE,10,PI/4);
    }
}