integer primed;
vector color;
float elapsed;
float total_run_time;
vector my_vel;
vector my_pos;

get_color()
{
    list L = llParseString2List(llGetTimestamp(), ["T",":","Z"], []);
    float Time = llList2Float(L, 3);
    color =  <llPow(llCos(Time * PI / 1.5) + 1, 1.58) / 3.0,
        llPow(llCos((Time + 2) * PI / 1.5) + 1, 1.58) / 3.0,
        llPow(llCos((Time + 1) * PI / 1.5) + 1, 1.58) / 3.0>;
}

die()
{
    if(primed)
    {
        llSetTimerEvent(0.0);
        llSetAlpha(0.0, ALL_SIDES);
        llParticleSystem(
        [
            PSYS_SRC_PATTERN, PSYS_SRC_PATTERN_EXPLODE,
            PSYS_SRC_BURST_RADIUS, 5,
            PSYS_PART_START_COLOR, color,
            PSYS_PART_END_COLOR, color,
            PSYS_PART_START_ALPHA, 1.0,
            PSYS_PART_END_ALPHA, 0.0,
            PSYS_PART_START_SCALE, <5.0, 0.5, 0.0>,
            PSYS_PART_END_SCALE, <0.5, 4.0, 0.0>,
            PSYS_SRC_TEXTURE, "",
            PSYS_SRC_MAX_AGE, 0.0,
            PSYS_PART_MAX_AGE, 5.0,
            PSYS_SRC_BURST_RATE, 0.0,
            PSYS_SRC_BURST_PART_COUNT, 9,
            PSYS_SRC_BURST_SPEED_MIN, 2.0,
            PSYS_SRC_BURST_SPEED_MAX, 7.0,
            PSYS_PART_FLAGS,
                PSYS_PART_EMISSIVE_MASK |
                PSYS_PART_FOLLOW_VELOCITY_MASK |
                PSYS_PART_INTERP_COLOR_MASK |
                PSYS_PART_INTERP_SCALE_MASK
        ]);
        llSleep(1.0);
        llDie();
    }
}

default
{
    on_rez(integer start_param)
    {
        primed = (start_param > 0);
        if(primed)
        {
            get_color();
            my_vel = (<start_param, 0.0, 0.0> * llGetRootRotation());
            my_pos = llGetRootPosition();
            llResetTime();
            llSetTimerEvent(0.1);
            llParticleSystem(
            [
                PSYS_SRC_PATTERN, PSYS_SRC_PATTERN_EXPLODE,
                PSYS_PART_START_COLOR, <0.95, 1.0, 0.98>,
                PSYS_PART_END_COLOR, <1.0, 1.0, 1.0>,
                PSYS_PART_START_ALPHA, 1.0,
                PSYS_PART_END_ALPHA, 0.0,
                PSYS_PART_START_SCALE,<1.25, 0.25, 0.0>,
                PSYS_PART_END_SCALE,<0.5, 0.5, 0.0>,
                PSYS_SRC_TEXTURE, "6278e369-c9cb-4d93-9913-71b0f0bafb24",
                PSYS_SRC_MAX_AGE, 0.0,
                PSYS_PART_MAX_AGE, 3.0,
                PSYS_SRC_BURST_RATE, 0.0,
                PSYS_SRC_BURST_PART_COUNT, 8,
                PSYS_SRC_BURST_SPEED_MIN,0.125,
                PSYS_SRC_BURST_SPEED_MAX,0.125,
                PSYS_PART_FLAGS,
                    PSYS_PART_EMISSIVE_MASK |
                    PSYS_PART_FOLLOW_VELOCITY_MASK |
                    PSYS_PART_INTERP_COLOR_MASK
            ]);
        }
    }
    
    timer()
    {
        elapsed = llGetAndResetTime();
        total_run_time = total_run_time + elapsed;
        if((total_run_time >= 180.0) || (my_vel.z < 0.0))
            die();
        my_vel = my_vel - (<0.0, 0.0, 9.8> * elapsed);
        my_pos = llGetPos() + my_vel * elapsed;
        llSetLinkPrimitiveParamsFast(LINK_THIS, [PRIM_POSITION, my_pos, PRIM_ROTATION, llRotBetween(<1.0, 0.0, 0.0>, my_vel)]);
    }
}