/////////////////////////////////////////////////
//                                             //
//            Created  by Jeff Cost            //
//            http://myopengrid.com            //
//                 License MIT                 //
//                                             //
///////////////////////////////////////////////// 

vector focus = <134.75,182.25,29.5>;
vector pos = <135.0,161.25,30.3>;

setCameraPosition(integer perms)
{
    if(perms & PERMISSION_CONTROL_CAMERA)
    {
        vector camPos = pos;
        vector camFocus = focus;
        llClearCameraParams();
        llSetCameraParams([
            CAMERA_ACTIVE, 1,
            CAMERA_FOCUS, camFocus,
            CAMERA_FOCUS_LOCKED, TRUE,
            CAMERA_POSITION, camPos,
            CAMERA_POSITION_LOCKED, TRUE
        ]);
    }
}

default
{
    state_entry()
    {
        llSitTarget(<-0.0,-0.50,-1.1>, llEuler2Rot(<180.0,0.0,90.0>*DEG_TO_RAD));
    }
    changed(integer change)
    {
        if(change & CHANGED_LINK)
        {
            key agent = llAvatarOnSitTarget();

            if(agent)
            {
                llRequestPermissions(llAvatarOnSitTarget(), PERMISSION_CONTROL_CAMERA);
            }
        }
    }
    run_time_permissions(integer perms)
    {
        setCameraPosition(perms);
    }

}