integer screen_channel = 3333;
integer camera_channel = 5555;
integer browser_channel = 6666;
integer off = 1;

default
{
    state_entry()
    {
        llSay(0, "Script running");
        llListen(screen_channel, "", NULL_KEY, "");
    }
    
    changed(integer change) {
        if (change & CHANGED_MEDIA) {
            list params = llGetPrimMediaParams(0, [PRIM_MEDIA_CURRENT_URL]);
            if (llGetListLength(params) > 0) {
                string url = llList2String(params, 0);
                llRegionSay(browser_channel, url);
                if (off == 1) {
                    llRegionSay(camera_channel, "browser");
                    llRegionSay(screen_channel, "off");
                    off = 0;
                }
            }
        }
    }
    
    listen(integer channel, string name, key id, string message) {
        // heard something sent to the screen
        if (message != "off") {
            off = 1;
        }
    }
}