// Script created by Crista Lopes aka Diva Canto
// http://metaverseink.com
//
// This work is licensed under the 
// Creative Commons Attribution-NonCommercial-ShareAlike 3.0 Unported License. 
// To view a copy of this license, visit 
// http://creativecommons.org/licenses/by-nc-sa/3.0/

vector myPosition;
vector camera_position;
vector target;
vector camera_offset = <0, -0.3, 1>;
vector target_offset = <0, -8.766, -2.5>;

integer control_channel = 2222;

lookCenter() {
    //llOwnerSay("Cam " + (string)camera_position + " target " + (string)target);
    llClearCameraParams();
    llSetCameraParams([
        CAMERA_ACTIVE, 1,
        CAMERA_POSITION_LOCKED, TRUE,
        CAMERA_POSITION, camera_position,
        CAMERA_FOCUS_LOCKED, TRUE,
        CAMERA_FOCUS_LAG, 2.0,
        CAMERA_FOCUS, target
    ]);
}

default
{
    state_entry()
    {
        llSay(0,"started");
        vector rot=<0.0, 0.0, -90.0>*DEG_TO_RAD;
        rotation finalrot=llEuler2Rot(rot);
        myPosition = llGetPos();
        camera_position = myPosition + camera_offset;
        target = myPosition + target_offset;
        
        //llSay(0,""+(string)myPosition);
        llSitTarget(<-0.0, -0.3, 0.3>, finalrot);
    }
    
    changed(integer change) { // something changed
        if (change & CHANGED_LINK) { // and it was a link change
            key avatar = llAvatarOnSitTarget() ;
            if (avatar != NULL_KEY)
                llRequestPermissions(avatar, PERMISSION_CONTROL_CAMERA);
                
            llSay(control_channel, (string)avatar);
        }
    }
    
    run_time_permissions(integer perm) {
        if (perm & PERMISSION_CONTROL_CAMERA) {
            lookCenter();
        }
    }

}