/////////////////////////////////////////////////
//                                             //
//            Created  by Crista Lopes         //
//            http://myopengrid.com            //
//                 License MIT                 //
//                                             //
///////////////////////////////////////////////// 

integer control_channel = 2222;
integer view = 0;

vector pos0 = <133.875,182.375,25.8475>;
vector focus0 = <133.35,172.375,25.1475>;
vector pos1 = <134.0,177.5,26.0256>;
vector focus1 = <134.0,170.5,24.0>;

key agent;
integer perms;

setCameraPosition()
{
    if (agent != NULL_KEY)
    {
        if (perms & PERMISSION_CONTROL_CAMERA)
        {
            vector pos;
            vector focus;
            if (view == 0) {
                pos = pos0;
                focus = focus0;
            }
            else {
                pos = pos1;
                focus = focus1;
            }
        
            llClearCameraParams();
            llSetCameraParams([
                CAMERA_ACTIVE, 1,
                CAMERA_FOCUS, focus,
                CAMERA_FOCUS_LOCKED, TRUE,
                CAMERA_POSITION, pos,
                CAMERA_FOCUS_LAG, 2.0,
                CAMERA_POSITION_LAG, 3.0,
                CAMERA_POSITION_LOCKED, TRUE
            ]);
        }
    }
}

default
{
    state_entry()
    {
        llListen(control_channel, "", NULL_KEY, "");
    }

    changed(integer change)
    {
        if(change & CHANGED_LINK)
        {
            agent = llAvatarOnSitTarget();

            if(agent)
            {
                llRequestPermissions(llAvatarOnSitTarget(), PERMISSION_CONTROL_CAMERA);
            }
            else
                perms = 0;
        }
    }
    
    run_time_permissions(integer perm)
    {
        perms = perm;
        setCameraPosition();
    }

    listen(integer channel, string name, key id, string message)
    {
        //llOwnerSay("Heard " + message);
        key av = (key)message;
        if (av == NULL_KEY) { // Avie stood up
            view = 0;
            setCameraPosition();
        } else { // Avie sat down
            view = 1;
            setCameraPosition();
        }
    }
}