// Script created by Crista Lopes aka Diva Canto
// http://metaverseink.com
//
// This work is licensed under the 
// Creative Commons Attribution-NonCommercial-ShareAlike 3.0 Unported License. 
// To view a copy of this license, visit 
// http://creativecommons.org/licenses/by-nc-sa/3.0/

integer control_channel = 2222;
integer screen_channel = 3333;
integer next_slide_channel = 3334;
integer pointer_channel = 4444;
integer camera_channel = 5555;
integer browser_channel = 6666;
integer dialog_channel = 123;
integer dialog_handle;

// OSCC textures. Keeping this here so that archiving grabs them too.
// But these are overridden in state_entry
key uc_texture_key="1789f415-d0c3-443d-bb45-f2ab6d125855";
key my_default_texture = "73505b83-f50b-4001-a73c-e184b3f88420";

key presenter_key = NULL_KEY;
key owner_key = NULL_KEY;
integer NumberOfTextures = 0;
integer CurrentTexture = 0;
string control_on_msg =  "You have gained control of the presentation. Number of slides: ";
string control_off_msg =  "You are no longer in control of the presentation";

integer off = 0; 
integer action; // 0 = home; 1 = delete slides

release() {
    reset();
    llRegionSay(screen_channel, "off");
    presenter_key = NULL_KEY;
    llMessageLinked(LINK_ALL_OTHERS, 0, "presenter", NULL_KEY);
}

reset() {
    llSay(0, "Reset");
    llRegionSay(screen_channel, (string)uc_texture_key);
    llRegionSay(next_slide_channel, (string)my_default_texture);
    llRegionSay(pointer_channel, "hide");
    llRegionSay(camera_channel, "screen");
    llRegionSay(browser_channel, "off");
    llSetTexture(my_default_texture, 0);
    off = 0;
    CurrentTexture = 0;
    NumberOfTextures = llGetInventoryNumber(INVENTORY_TEXTURE);
}

presenterInControl(key avatar_key) {
    presenter_key = avatar_key;
    NumberOfTextures = llGetInventoryNumber(INVENTORY_TEXTURE);
    llInstantMessage(presenter_key, control_on_msg + (string)NumberOfTextures);
    llRegionSay(camera_channel, "screen");
    llRegionSay(browser_channel, "off");
    llMessageLinked(LINK_ALL_OTHERS, 0, "presenter", presenter_key);
    off = 0;

    displayme();
}

displayme() {
    string texture_name = llGetInventoryName(INVENTORY_TEXTURE, CurrentTexture);
    if (texture_name == "") {
        reset();
    }
    else {
        key texture_key = llGetInventoryKey(texture_name);
        // Announce to receivers
        llRegionSay(screen_channel, (string)texture_key);
        llRegionSay(pointer_channel, "hide");

        // Display it on the main face
        llSetTexture(texture_name, 0);
        llInstantMessage(presenter_key, "Slide " + (string)(CurrentTexture+1) + " of " + (string)NumberOfTextures);

        // Load the next one on the next slide panel, to make it faster
        if (CurrentTexture + 1 < NumberOfTextures) {
            //llSetTexture(llGetInventoryName(INVENTORY_TEXTURE, CurrentTexture + 1), 5);
            string next_texture_name = llGetInventoryName(INVENTORY_TEXTURE, CurrentTexture + 1);
            key next_texture_key = llGetInventoryKey(next_texture_name);
            llRegionSay(next_slide_channel, (string)next_texture_key);
        }  
    }
}

NextSlide() {
    //llSay(0, "Next");
    if (CurrentTexture < NumberOfTextures - 1) {
        CurrentTexture++;
    } else {
        CurrentTexture = 0;
    }    
    displayme();
}

PreviousSlide() {
    //llSay(0, "Previous");
    if (CurrentTexture > 0) {
        CurrentTexture--;
    } 
    displayme();
}

BeginDeleteSlides(key avatar) {
    dialog_handle = llListen(dialog_channel, "", avatar, ""); 
    llDialog(avatar, "Delete entire presentation?", ["Yes", "No"], dialog_channel);
}

DeleteSlides(key avatar) {
    integer nSlides = llGetInventoryNumber(INVENTORY_TEXTURE);
    while (nSlides > 0) {
        --nSlides;
        string name = llGetInventoryName(INVENTORY_TEXTURE, 0);
        llRemoveInventory(name);
    }
    llInstantMessage(avatar, "All slides were deleted");
    llListenRemove(dialog_handle);
    displayme();   
}

BeginHome(key avatar) {
    dialog_handle = llListen(dialog_channel, "", avatar, ""); 
    llDialog(avatar, "Go to the beginning?", ["Yes", "No"], dialog_channel);
}

Home(key avatar) {
    CurrentTexture = 0;
    NumberOfTextures = llGetInventoryNumber(INVENTORY_TEXTURE);
    displayme();
    llListenRemove(dialog_handle);
}

default
{
    state_entry()
    {
        // Universal Campus texture default
        uc_texture_key="5c0f7d9b-c082-4431-80df-3653cb7eebf3";
        my_default_texture = "5c0f7d9b-c082-4431-80df-3653cb7eebf3";
        owner_key = llGetOwner();
        llAllowInventoryDrop(TRUE);
        llListen(control_channel, "Presenter's Chair", NULL_KEY, "");
        llListen(browser_channel, "", NULL_KEY, "");
        reset();
        llRegionSay(screen_channel, "off");
    }
    
    touch_start(integer agent)
    {
        integer touchedFace = llDetectedTouchFace(0);
        key avatar_key = llDetectedKey(0);
        //llSay(0, "Detected Face: " + (string)touchedFace);
        
        // delete?
        if (((avatar_key == presenter_key) || (avatar_key == owner_key)) && touchedFace == 1) {
            action = 1;
            BeginDeleteSlides(avatar_key);
        }
        // slide change
        else if (avatar_key == presenter_key) { 
            // Home?
            if (touchedFace == 3) {
                action = 0;
                BeginHome(avatar_key);
            } else if (touchedFace == 4) {
                PreviousSlide();
            } else if (touchedFace == 2) {
                NextSlide();
            } else if (touchedFace == 0) {
                vector touchedpos = llDetectedTouchST(0);
                llRegionSay(pointer_channel, (string)touchedpos.x + ":" + touchedpos.y);
                //llSay(0, (string)touchedpos.x + ":" + touchedpos.y);
                //if (off == 1) {
                //    llRegionSay(screen_channel, "on");
                //}
            }
            if (off == 1) {
                //llOwnerSay("was off; going on");
                llRegionSay(camera_channel, "screen");
                llRegionSay(browser_channel, "off");
                llRegionSay(screen_channel, "on");
                off = 0;
            }
        }       
    }
    
    listen(integer channel, string name, key id, string message ) {
        if (channel == browser_channel) {
            // heard something sent to the browser
            if (message != off) {
                off = 1;
            }
        } else if (channel == dialog_channel) {
            if (message == "Yes") {
                if (action == 1)
                    DeleteSlides(id);
                else
                    Home(id);
            }
            else {
                llInstantMessage(id, "Slides were not deleted");
            }
        } else if (channel == control_channel) {
            //llSay(0, message);
            key av = (key)message;
            if (av == NULL_KEY) {
                if (presenter_key != NULL_KEY) {
                    llInstantMessage(presenter_key, control_off_msg);
                    release();
                }
            } else {
               presenterInControl((key)message);
            }
        }
    }   
    
    link_message(integer sender_num, integer num, string msg, key id) {
        if (msg == "reset") {
            NumberOfTextures = llGetInventoryNumber(INVENTORY_TEXTURE);
            displayme();
        }
    }
    
//    changed(integer change)
//    {
//        //PUBLIC_CHANNEL has the integer value 0
//        if ((change & (CHANGED_ALLOWED_DROP | CHANGED_INVENTORY)) && presenter_key != NULL_KEY) {
//            presenterInControl(presenter_key);
//        }
//    }
}