// Script created by Crista Lopes aka Diva Canto
// http://metaverseink.com
//
// This work is licensed under the 
// Creative Commons Attribution-NonCommercial-ShareAlike 3.0 Unported License. 
// To view a copy of this license, visit 
// http://creativecommons.org/licenses/by-nc-sa/3.0/

integer laser_pointer_channel = 4444;
float max_z = 6.8;
float min_z = -6.8;
float max_y = 1;
float min_y = 0;
float max_x = -10.2;
float min_x = 10.2;

float z_offset = 0;
float x_offset = -0.25;
float y_offset = 0.2;

default
{
    state_entry()
    {
        llSetAlpha(0.0, ALL_SIDES);
        llListen(laser_pointer_channel, "", NULL_KEY, "");
    }
    
    listen(integer channel, string name, key id, string message) {
        if (message == "hide") {
            llSetAlpha(0.0, ALL_SIDES);
        } else {
            //llOwnerSay("Heard " + message);
            list coords = llParseString2List(message, [":"], []);
            float x_factor = llList2Float(coords, 0);
            float z_factor = llList2Float(coords, 1);
            float x = (max_x-min_x)*x_factor;
            float z = (max_z-min_z)*z_factor;
            float y = y_offset+z_factor*0.1;

            vector pos = <min_x+x+x_offset, min_y+y, min_z+z+z_offset>;
            //llOwnerSay((string)pos);
            llSetPos(pos);
            llSetPos(pos);
            llSetAlpha(0.75, ALL_SIDES);
        }        
    }
    
}