// Kristen Mynx 2011
// Inspired by and some parts used from:
// .lsDanceXec 08099 lsDancemachine Animation (c) Kephra Nurmi 2007
// published under Creative Commons Attribution-Share Alike 3.0 License


integer me;
key dancer = NULL_KEY;
string dance = "";
integer waitingPerms = FALSE;

newdance()
{
    if (dancer == NULL_KEY) return; // no dancer
    if (llGetAgentInfo(dancer) == 0) // dancer gone
    {
        dancer = NULL_KEY;
        return;
    }
    if ((llGetPermissions() & PERMISSION_TRIGGER_ANIMATION) &&
        (llGetPermissionsKey() == dancer)) {
        waitingPerms = FALSE;
        list anims = llGetAnimationList(dancer);
        integer len = llGetListLength(anims);
        integer i;
        for (i = 0; i < len; ++i) llStopAnimation(llList2Key(anims, i));
        if (len > 0) llSleep(0.1);
        if (dance == "")
        {
            llStartAnimation("stand");
            llSetTimerEvent(0.0);
        }
        else
        {
            llStartAnimation(dance);
            llSetTimerEvent(60.0);
        }
    }
    else
    {
        if (dance != "")
        {
            waitingPerms = TRUE;
            llRequestPermissions(dancer, PERMISSION_TRIGGER_ANIMATION);
            llSetTimerEvent(10.0);
        }
    }
}

status()
{
    llMessageLinked(LINK_THIS,me+2000,dance,dancer);
}

default
{
    state_entry()
    {
        list p = llParseString2List(llGetScriptName(),[ ",", " " ], []);
        me = (integer)llList2String(p,llGetListLength(p)-1);
        //llOwnerSay((string)me);
    }
    timer()
    {
        if (waitingPerms)
        {
            waitingPerms = FALSE;
            // timed out waiting for permission
            // clear dancer and forget it
            dance = "";
            dancer = NULL_KEY;
            status();
            return;
        }
        if (llGetAgentInfo(dancer) == 0) // dancer gone
        {
            dance = "";
            dancer = NULL_KEY;
            status();
            return;
        }
    }
            
    run_time_permissions(integer perms) {
        llSetTimerEvent(60.0);
        waitingPerms = FALSE;
        if (perms & PERMISSION_TRIGGER_ANIMATION)
        {
            newdance();
            status();
        }
        else
        {
            dance = "";
            dancer = NULL_KEY;
            status();
        }
    }
    link_message(integer sender, integer num, string message, key id)
    {
        if (num == (me + 1000))
        {
           dance = message;
           dancer = id;
           newdance();
           status(); 
        }
    }
}
