// Kristen Mynx 2010
//

integer numAnimators = 0;
integer numDancers = 0;

list dancers;
list dances;
list types;

list guyDances;
list girlDances;
list tinyDances;
list quadDances;

list translateIn;
list translateOut;

string guyGroup;
string girlGroup;
string tinyGroup;
string quadGroup;


integer randomTalk = TRUE;
integer groupTalk = TRUE;
float changeTime = 180.0;

//== dialog control stuff

// READ ME:
// To see this sample in action;
// Put "Nargus Dialog Control" along with this script in a prim and touch.
 
// ********** DIALOG FUNCTIONS **********
// Dialog constants
integer lnkDialog = 14001;
integer lnkDialogNotify = 14004;
integer lnkDialogResponse = 14002;
integer lnkDialogTimeOut = 14003;
 
integer lnkDialogReshow = 14011;
integer lnkDialogCancel = 14012;

integer lnkMenuClear = 15001;
integer lnkMenuAdd = 15002;
integer lnkMenuShow = 15003;

string seperator = "||";
integer dialogTimeOut = 0;

string packDialogMessage(string message, list buttons, list returns){
    string packed_message = message + seperator + (string)dialogTimeOut;
 
    integer i;
    integer count = llGetListLength(buttons);
    for(i=0; i<count; i++){
        string button = llList2String(buttons, i);
        if(llStringLength(button) > 24) button = llGetSubString(button, 0, 23);
        packed_message += seperator + button + seperator + llList2String(returns, i);
    }
 
    return packed_message;
}
 
dialogReshow(){llMessageLinked(LINK_THIS, lnkDialogReshow, "", NULL_KEY);}
dialogCancel(){
    llMessageLinked(LINK_THIS, lnkDialogCancel, "", NULL_KEY);
    llSleep(1);
}
 
dialog(key id, string message, list buttons, list returns){
    llMessageLinked(LINK_THIS, lnkDialog, packDialogMessage(message, buttons, returns), id);
}
 
dialogNotify(key id, string message){
    list rows;
 
    llMessageLinked(LINK_THIS, lnkDialogNotify,
        message + seperator + (string)dialogTimeOut + seperator,
        id);
}
// ********** END DIALOG FUNCTIONS **********

doMessage(key id, string msg)
{
    llDialog(id,msg,[],-100000);
}

string tran(string s)
{
    integer tr = llListFindList(translateIn,[ s ]);
    if (tr > -1) s = llList2String(translateOut,tr);
    return(s);
}
setupMenus()
{
    llMessageLinked(LINK_THIS, lnkMenuClear, "", NULL_KEY);
    
    list b1;
    list b2;

        
    integer n = llGetInventoryNumber(INVENTORY_ANIMATION);

    guyDances = [];
    girlDances = [];
    tinyDances = [];
    quadDances = [];
    integer i;
    
    for (i = 0; i < n; i++)
    {
        string aa = llGetInventoryName(INVENTORY_ANIMATION,i);
        string aaa = llToLower(llGetSubString(tran(aa),0,2));
        if (aaa == "gir") girlDances += [ aa ];
        if (aaa == "guy") guyDances += [ aa ];
        if (aaa == "tin") tinyDances += [ aa ];
        if (aaa == "qua") quadDances += [ aa ];
        
    }

    // make main menu
    

    if (llGetListLength(guyDances) > 0)
    {
        b1 += [ "Guy Menu" ];
        b2 += [ "MENU_GUY" ];
    }
    if (llGetListLength(girlDances) > 0)
    {
        b1 += [ "Girl Menu" ];
        b2 += [ "MENU_GIRL" ];
    }
    if (llGetListLength(tinyDances) > 0)
    {
        b1 += [ "Tiny Menu" ];
        b2 += [ "MENU_TINY" ];
    }
    if (llGetListLength(quadDances) > 0)
    {
        b1 += [ "Quad Menu" ];
        b2 += [ "MENU_QUAD" ];
    }
    
    
    b1 += [ "Stop", "Exit" ];
    b2 += [ "STOP", "EXIT" ];
    
    llMessageLinked(LINK_THIS, lnkMenuAdd, packDialogMessage(
            "[ Dance Main Menu ]\n" +
            " Choose",
            b1,
            b2
        ), "MainMenu");
    
    // make girl menu
    n = llGetListLength(girlDances);
    b1 = [ "Main Menu", "Stop", "Random", "Group" ];
    b2 = [ "MENU_MainMenu", "STOP", "IRANDOM", "IGROUP" ];
    for (i = 0; i < n; i++)
    {
        string gi = llList2String(girlDances,i);
        b1 += [ llStringTrim(llGetSubString(tran(gi),5,25),STRING_TRIM) ];
        b2 += [ "girl,"+gi ];
    }
    b1 += [ "Exit" ];
    b2 += [ "EXIT" ];
    
    llMessageLinked(LINK_THIS, lnkMenuAdd, packDialogMessage(
            "[ Girl Dance Menu ]\n" +
            "Choose",
            b1,
            b2
        ), "GIRL");
    
    // make guy menu
    n = llGetListLength(guyDances);
    b1 = [ "Main Menu", "Stop", "Random", "Group" ];
    b2 = [ "MENU_MainMenu", "STOP", "URANDOM", "UGROUP" ];
    for (i = 0; i < n; i++)
    {
        string gu = llList2String(guyDances,i);
        b1 += [ llStringTrim(llGetSubString(tran(gu),4,24),STRING_TRIM) ];
        b2 += [ "guy,"+gu ];
    }
    b1 += [ "Exit" ];
    b2 += [ "EXIT" ];
    
    llMessageLinked(LINK_THIS, lnkMenuAdd, packDialogMessage(
            "[ Guy Dance Menu ]\n" +
            "Choose",
            b1,
            b2
        ), "GUY");
    
    // make tiny menu
    n = llGetListLength(tinyDances);
    b1 = [ "Main Menu", "Stop", "Random", "Group" ];
    b2 = [ "MENU_MainMenu", "STOP", "TRANDOM", "TGROUP" ];
    for (i = 0; i < n; i++)
    {
        string ti = llList2String(tinyDances,i);
        b1 += [ llStringTrim(llGetSubString(tran(ti),5,24),STRING_TRIM) ];
        b2 += [ "tiny,"+ti ];
    }
    b1 += [ "Exit" ];
    b2 += [ "EXIT" ];
    
    llMessageLinked(LINK_THIS, lnkMenuAdd, packDialogMessage(
            "[ Tiny Dance Menu ]\n" +
            "Choose",
            b1,
            b2
        ), "TINY");
        
    // make quad menu
    n = llGetListLength(quadDances);
    b1 = [ "Main Menu", "Stop", "Random", "Group" ];
    b2 = [ "MENU_MainMenu", "STOP", "TRANDOM", "TGROUP" ];
    for (i = 0; i < n; i++)
    {
        string fu = llList2String(quadDances,i);
        b1 += [ llStringTrim(llGetSubString(tran(fu),5,24),STRING_TRIM) ];
        b2 += [ "quad,"+fu ];
    }
    b1 += [ "Exit" ];
    b2 += [ "EXIT" ];
    
    llMessageLinked(LINK_THIS, lnkMenuAdd, packDialogMessage(
            "[ Quad Dance Menu ]\n" +
            "Choose",
            b1,
            b2
        ), "QUAD");
        
}

countAnimators()
{
    numAnimators = 0;
    integer n = llGetInventoryNumber(INVENTORY_SCRIPT);
    integer i;
    string animScriptName = "dance animator";
    
    for (i = 0; i < n; i++)
    {
        string aa = llGetInventoryName(INVENTORY_SCRIPT,i);
        string aaa = llToLower(llGetSubString(aa,0,llStringLength(animScriptName)-1));
        if (aaa == animScriptName)
        {
            integer sn = (integer)llGetSubString(aa,llStringLength(animScriptName)+1,99);
            if (sn > numAnimators) numAnimators = sn;
        }
    }
    dancers = [];
    dances = [];
    types = [];
    numDancers = 0;
    
    for (i = 0; i < numAnimators; i++)
    {
        dancers += [ NULL_KEY ];
        dances += [ "" ];
        types += [ "" ];
    }
}

doText()
{
    string d;
    if (llGetListLength(girlDances) > 0) d += "\n"+(string)llGetListLength(girlDances)+ " girl dances";
    if (llGetListLength(guyDances) > 0) d += "\n"+(string)llGetListLength(guyDances)+ " guy dances";
    if (llGetListLength(tinyDances) > 0) d += "\n"+(string)llGetListLength(tinyDances)+ " tiny dances";
    if (llGetListLength(quadDances) > 0) d += "\n"+(string)llGetListLength(quadDances)+ " quad dances";
    
    llSetText((string)numDancers+" Dancers of "+(string)numAnimators+d
    ,<1,1,1>,1.0);
}

setStatus(integer slot, string dance, key dancer, string type)
{
    key prior = llList2Key(dancers,slot);
    if (dance == "" || dancer == NULL_KEY)
    {
        if (prior != NULL_KEY) numDancers--;
        dancers = llListReplaceList(dancers, [ NULL_KEY ], slot, slot); 
        types = llListReplaceList(types, [ "" ], slot, slot);
        dances = llListReplaceList(dance, [ "" ], slot, slot);
    }
    else
    {
        if (prior == NULL_KEY) numDancers++;
        dancers = llListReplaceList(dancers, [ dancer ], slot, slot); 
        dances = llListReplaceList(dance, [ dance ], slot, slot);
        if (type != "~~~")
        {
            types = llListReplaceList(types, [ type ], slot, slot);
        }
    }
    doText();
}

integer findSlot()
{
    integer s = llListFindList(dancers, [ NULL_KEY ]);
    return s;
}
integer findDancer(key dancer)
{
    integer s = llListFindList(dancers, [ dancer ]);
    return s;
}

doRandom(integer n, key dancer, list d, string type)
{
    integer r = (integer)llFrand((float)llGetListLength(d));
    string dance = llList2String(d,r);
    setStatus(n,dancer,dance,type);
    llMessageLinked(LINK_THIS,1001+n,dance,dancer);
    if (randomTalk) llInstantMessage(dancer,"Dance set to:"+tran(dance));
}
doRandoms(string type, list d)
{
    integer n = llGetListLength(dancers);
    while(--n >= 0)
    {
        if (type == llList2String(types,n))
        {
            key dancer = llList2Key(dancers,n);
            doRandom(n,dancer,d,type);
        }
    }
}

string doGroup(string type, list d)
{
    integer r = (integer)llFrand((float)llGetListLength(d));
    string dance = llList2String(d,r);
    integer n = llGetListLength(dancers);
    integer g = 0;
    while(--n >= 0)
    {
        if (type == llList2String(types,n))
        {
            key dancer = llList2Key(dancers,n);
            setStatus(n,dancer,dance,type);
            llMessageLinked(LINK_THIS,1001+n,dance,dancer);
            g++;
        }
    }
    if (groupTalk && g)
    {
        string m = "Guy";
        if (type == "igroup") m = "Girl";
        llSay(0,m+" group dance set to:"+tran(dance));
    }

    return dance;
}

init()
{
    countAnimators();
    setupMenus();
    girlGroup = doGroup("igroup",girlDances);
    guyGroup = doGroup("ugroup",guyDances);
    llSetTimerEvent(changeTime);
    doText();
}


list notecards = [ ".config", ".translate" ];
integer ncNumber;
integer ncLineNum;
key ncQid;
string ncName;

ncNext()
{
    integer t = -1;
    while(t == -1)
    {
        ncName = llList2String(notecards,ncNumber);
        ncNumber++;
        if (ncName == "")
        {
            t = -2;
        }
        else
        {
            t = llGetInventoryType(ncName);
        }
    }
    if (t == -2) state ready;
    ncLineNum = 0;
    ncQid = llGetNotecardLine(ncName,ncLineNum);
}

integer ncBool(string s)
{
    s = llToLower(llGetSubString(s,0,0));
    if (s == "y" || s == "1" || s == "t") return TRUE;
    return FALSE;
}
    
ncLine(string name, integer line, string data)
{
    //llOwnerSay(data);
    integer p = llSubStringIndex(data,"=");
    string p1;
    string p2;
    if (p > -1)
    {
        p1 = llGetSubString(data,0,p-1);
        p2 = llGetSubString(data,p+1,-1);
    }
    else
    {
        p1 = data;
    }
    if (name == ".translate")
    {
        translateIn += [ llStringTrim(p1,STRING_TRIM) ];
        translateOut += [ llStringTrim(p2,STRING_TRIM) ];
    }
    if (name == ".config")
    {
        p1 = llToLower(llStringTrim(p1,STRING_TRIM));
        p2 = llStringTrim(p2,STRING_TRIM);
        if (p1 == "randomtalk") randomTalk = ncBool(p2);
        if (p1 == "grouptalk") groupTalk = ncBool(p2);
        if (p1 == "changetime") changeTime = (float)p2;
    }
}

default
{
    state_entry()
    {
        state load;
    }
}

state load
{
    state_entry()
    {
        llSetText("Loading...",<1,1,1>,1.0);

        ncNumber = 0;
        ncNext();
    }
    dataserver(key qid, string data)
    {
        if (qid == ncQid)
        {
            if (data == EOF)
            {
                ncNext();
                return;
            }
            if (llStringLength(data) > 3 && llGetSubString(data,0,0) != "#")
                ncLine(ncName,ncLineNum,data);
            ncLineNum++;
            ncQid = llGetNotecardLine(ncName,ncLineNum);
        }
            
    }
}


state ready
{
    state_entry()
    {
        init();
    }
    touch_start(integer num)
    {
        llMessageLinked(LINK_THIS, lnkMenuShow, "MainMenu", llDetectedKey(0));
    }
    link_message(integer sender_num, integer num, string str, key id)
    {
        if(num == lnkDialogTimeOut){
            dialogNotify(llGetOwner(), "Menu time-out. Please try again.");
        }
        else
        if(num == lnkDialogResponse)
        {
            //llOwnerSay( str);
            integer p = llSubStringIndex(str,",");
            integer s;
            string cmd;
            string rest;
            if (p > -1)
            {
                cmd = llToLower(llGetSubString(str,0,p-1));
                rest = llGetSubString(str,p+1,-1);
            }
            else
            {
                cmd = llToLower(str);
            }
            if (cmd == "exit") return;
            if (cmd == "stop")
            {
                s = findDancer(id);
                if (s < 0) return;
                setStatus(s,"",NULL_KEY,"");
                llMessageLinked(LINK_THIS,1001+s,"",id);
                return;
            }
            s = findDancer(id);
            if (s < 0) s = findSlot();
            if (s < 0)
            {
                doMessage(id,"Sorry, the dance animator is full.");
                return;
            }
            if (cmd == "girl")
            {
                setStatus(s,rest,id,"girl");
                llMessageLinked(LINK_THIS,1001+s,rest,id);
            }
            if (cmd == "irandom")
            {
                doRandom(s,id,girlDances,"irandom");
            }                
            if (cmd == "igroup")
            {
                setStatus(s,girlGroup,id,"igroup");
                llMessageLinked(LINK_THIS,1001+s,girlGroup,id);
                if (groupTalk) llInstantMessage(id,"Girl group dance set to:"+tran(girlGroup));
            }
            if (cmd == "guy")
            {
                setStatus(s,rest,id,"guy");
                llMessageLinked(LINK_THIS,1001+s,rest,id);
            }
            if (cmd == "urandom")
            {
                doRandom(s,id,guyDances,"urandom");
            }                
            if (cmd == "ugroup")
            {
                setStatus(s,guyGroup,id,"igroup");
                llMessageLinked(LINK_THIS,1001+s,guyGroup,id);
                if (groupTalk) llInstantMessage(id,"Guy group dance set to:"+tran(girlGroup));
            }
            
            if (cmd == "tiny")
            {
                setStatus(s,rest,id,"tiny");
                llMessageLinked(LINK_THIS,1001+s,rest,id);
            }
            if (cmd == "trandom")
            {
                doRandom(s,id,tinyDances,"trandom");
            }                
            if (cmd == "tgroup")
            {
                setStatus(s,tinyGroup,id,"tgroup");
                llMessageLinked(LINK_THIS,1001+s,tinyGroup,id);
                if (groupTalk) llInstantMessage(id,"Tiny group dance set to:"+tran(tinyGroup));
            }
            
            if (cmd == "quad")
            {
                setStatus(s,rest,id,"quad");
                llMessageLinked(LINK_THIS,1001+s,rest,id);
            }
            if (cmd == "frandom")
            {
                doRandom(s,id,quadDances,"frandom");
            }                
            if (cmd == "fgroup")
            {
                setStatus(s,quadGroup,id,"fgroup");
                llMessageLinked(LINK_THIS,1001+s,quadGroup,id);
                if (groupTalk) llInstantMessage(id,"Quad group dance set to:"+tran(quadGroup));
            }
                
                
        }
        else
        if (num > 2000 && num <= (2000+numAnimators))
        {
            setStatus(num - 2001,str,id,"~~~");
        }
    }
    changed(integer change)
    {
        if (change & CHANGED_INVENTORY)
        {
            llSetTimerEvent(0.0);
            llSleep(2.0);
            state load;
        }
    }
    timer()
    {
        doRandoms("irandom",girlDances);
        doRandoms("urandom",guyDances);
        doRandoms("trandom",tinyDances);
        doRandoms("rrandom",quadDances);
        girlGroup = doGroup("igroup",girlDances);
        guyGroup = doGroup("ugroup",guyDances);
        tinyGroup = doGroup("tgroup",tinyDances);
        quadGroup = doGroup("fgroup",quadDances);
    }
    on_rez(integer num) 
    {
        llSetTimerEvent(0.0);
        state load;
    }
}