string font = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz1234567890(){}[]<>|\\/.,;:'!?\"£$%^&*_+-=~#@ ";
// A accurate representation of the characters featured on the texture used to display the text.
 
vector GetOffset(string s)
{
    if(s == "") // If there is no text
        s = " "; // Use a space
    integer i = llSubStringIndex(font, s); // Find the character
    if(i == -1) // If we can't find it
        i = 94; // Use a space
    return <(-0.45 + ((i % 10) * 0.1)), (0.45 - (llRound(i / 10) * 0.1)), 0.0>;
} // Return the offset needed to display the correct section of the texture by doing the mathematics *coughs*
 
integer me; // Used to store the Link number
 
integer my_ss_5; // Used to store the index of the feed text we display on face 5
 
integer my_ss_6; // Used to store the index of the feed text we display on face 6
 
default
{
    state_entry()
    {
        me = llGetLinkNumber();
        my_ss_6 = ((me - 1) * 2); // Whatever link we are (in a correctly built object) establish the index to grab
        my_ss_5 = (my_ss_6 + 1); // And also grab the next
    }
    link_message(integer sender, integer num, string msg, key id)
    {
        llSetLinkPrimitiveParamsFast(me, [17, 5, id, <0.1, 0.1, 0.0>, GetOffset(llGetSubString(msg, my_ss_5, my_ss_5)), 0.0,
                                          17, 6, id, <0.1, 0.1, 0.0>, GetOffset(llGetSubString(msg, my_ss_6, my_ss_6)), 0.0]);
    } // Set the texture to the correct offset to display the correct characters
}