// message whispered when new people arrive
string GreetMsg = "TYPE IN YOUR MESSAGE HERE";
string VisitText = ""; // diplays above w/name
integer textname = TRUE;    // displays last visitor overhead
vector textcol = <1,1,0>; // in this color
//-- Don't Change Below This unless you know what you're doing --\\
list MenuList = ["Silent", "Whisper", "Say", "Shout",
                 "Stats", "List", "Clear", "0 Totals", "Test"];
integer volume = 1; //0:off 1:whisper 2:say 3:shout
integer switch = 0;
integer newlist = 0;
integer menu_channel;
integer menu_handler = 0;
key data_request = NULL_KEY;
key name;
string MyName;
string LastName;
integer pcount; // count purged entries, might be dupes
integer vcount; // running total of visitors not on list
// reset script to clear list
list name_list;
//- - - - - - - - - - - - - - - - 
integer isIn(list test_list, list test_item) // Looks for test_item
{                                            // in test_list
    integer i;
    if (llListFindList(test_list, test_item) != -1) return TRUE;
    return FALSE;
}
//- - - - - - - - - - - - - - - - 
menu(key user,string title,list buttons) 
{ // pick a channel and destroy it after 5 seconds
    // different channel at each use
    menu_channel = (integer)(llFrand(99999.0) * -1);    
    if (menu_handler) {
        llSetTimerEvent(0.0);
        llListenRemove(menu_handler);
    }
    menu_handler = llListen(menu_channel,"",user,"");
    llDialog(user,title,buttons,menu_channel);
    llSetTimerEvent(15.0);
}
//--------------------------------------
giveallnotes(key who)
{
    integer InvNum;
    string NoteName;
    integer NumCards = 
        llGetInventoryNumber(INVENTORY_NOTECARD);
    for ( InvNum = 0; InvNum < NumCards; InvNum++) {
        NoteName = llGetInventoryName(INVENTORY_NOTECARD, InvNum);
        llGiveInventory(who, NoteName);
    }
}
default
{
    state_entry()
    {
        llVolumeDetect(TRUE);
        newlist = FALSE;
    }
    changed(integer chg)
    {
        if (chg & CHANGED_INVENTORY) llResetScript();
    }
 
    listen(integer ch, string nm, key id, string msg)
    {
        if (menu_handler) {
            llSetTimerEvent(0.0);
            llListenRemove(menu_handler);
        }
        if (msg == "List") {
            if (llGetListLength(name_list) > 0) {
                switch = 0;
                data_request = llRequestAgentData(llList2String(name_list, 0), DATA_NAME);
            } else llOwnerSay("List is empty.");
        } else if (msg == "Clear") {
            integer L = llGetListLength(name_list);
            pcount += L;
            name_list = [];
            llOwnerSay("List purged of " + (string)L + " entries.");
        } else if (msg == "Stats") {
            msg = "Visitors Greeted: " + (string)vcount;
            msg += ", On Current List: ";
            msg += (string)llGetListLength(name_list);
            msg += ", Purged: " + (string)pcount;
            msg += ", Memory Free: ";
            msg += (string)llGetFreeMemory();
            llOwnerSay(msg);
        } else if (msg == "0 Totals") {
            pcount = 0;
            vcount = 0;
            llOwnerSay("Running totals reset.");
        } else if (msg == "Test") {
            llWhisper(0,GreetMsg);
            giveallnotes(llGetOwner());
        } else if (msg == "Silent") {
            volume = 0;
            llOwnerSay(msg + " greeting mode set.");
        } else if (msg == "Whisper") {
            volume = 1;
            llOwnerSay(msg + " greeting mode set.");
        } else if (msg == "Say") {
            volume = 2;
            llOwnerSay(msg + " greeting mode set.");
        } else if (msg == "Shout") {
            volume = 3;
            llOwnerSay(msg + " greeting mode set.");
        } else if (msg == "Text On") {
            textname = TRUE;
            llOwnerSay("Float text enabled.");
            if (LastName != "") {
                llSetText(VisitText + LastName, textcol, 1.0);
            }
        } else if (msg == "Text Off") {
            textname = FALSE;
            llOwnerSay("Float text disabled");
            llSetText("",<1,1,1>,1);
        }
    }
 
    collision_start(integer total_number)
    {
        integer j;
        integer count = total_number;
        list dnames = [];
        string aname;
        newlist = FALSE;
        for (j = 0; j < count; j++)
        {
            if (llDetectedType(j) & AGENT) 
            {
                aname = llDetectedKey(j);        
                if(aname != NULL_KEY)
                {
                    // - KEYS now instead of names
                    if (!isIn(name_list, (list)aname)) {
                        if (!newlist) {
                            if (volume == 1) 
                                llWhisper(0,GreetMsg);
                            else if (volume == 2)
                                llSay(0,GreetMsg);
                            else if (volume == 3)
                                llShout(0,GreetMsg);
                            newlist = TRUE;
                        }
                        vcount++;
                        name_list += (list)aname;
                        giveallnotes(aname);
                    }
                    LastName = llKey2Name(aname);
                    if (textname && (LastName != "")) {
                        llSetText(VisitText + LastName, textcol, 1.0);
                    }
                }
            }
        }
        while (llGetFreeMemory() < 512)
        {
            name_list = llList2List(name_list, 1, -1);
            pcount++;
        }
    }
    timer() // so the menu timeout and close its listener
    {
        llSetTimerEvent(0.0);
        if (menu_handler) {
            llListenRemove(menu_handler);
            llOwnerSay("Menu timed out, please click again to reactivate.");
        }
    }
    touch_start(integer n)
    {
        if (llDetectedKey(0) != llGetOwner()) return;
        list btn = MenuList;
        string msg = "Greeter Control Menu";
        msg += "Greet volume is \"";
        msg += llList2String(MenuList, volume) + "\".";
        btn += [llList2String(["Text On","Text Off"], textname)];
        menu(llDetectedKey(0),msg,btn);
    }
 
    dataserver(key id, string data)
    {
        if (id != data_request) return;
        data_request = NULL_KEY;
        if (!switch) {
            MyName = llGetObjectName();
            llOwnerSay("-----List has " + 
                (string)llGetListLength(name_list) + 
                " entries:");
            llSetObjectName("");
        }
        llOwnerSay("/me " + data);
        if (++switch < llGetListLength(name_list))
            data_request = llRequestAgentData(llList2Key(name_list, switch), DATA_NAME);
        else {
            llSetObjectName(MyName);
            llOwnerSay("-----End of list.");
        }
    }
 
}