//d'Elle Tech Sync Poseball Script (Slave) by Adelle Fitzgerald


//Licenced under Creative Commons Attribution-Share Alike 3.0 Unported - http://creativecommons.org/licenses/by-sa/3.0/


//You are free:

//    * to Share — to copy, distribute and transmit the work
//    * to Remix — to adapt the work

//Under the following conditions:

//    * Attribution — You must attribute the work in the manner specified by the author or licensor (but not in any way that suggests that they endorse you or your use of the work).

//    * Share Alike — If you alter, transform, or build upon this work, you may distribute the resulting work only under the same, similar or a compatible license.

//With the understanding that:

//    * Waiver — Any of the above conditions can be waived if you get permission from the copyright holder.
//    * Public Domain — Where the work or any of its elements is in the public domain under applicable law, that status is in no way affected by the license.
//    * Other Rights — In no way are any of the following rights affected by the license:
//          o Your fair dealing or fair use rights, or other applicable copyright exceptions and limitations;
//          o The author's moral rights;
//          o Rights other persons may have either in the work itself or in how the work is used, such as publicity or privacy rights.
//    * Notice — For any reuse or distribution, you must make clear to others the license terms of this work. The best way to do this is with a link to this web page.

//Disclaimer

//The Commons Deed is not a license. It is simply a handy reference for understanding the Legal Code (the full license) — it is a human-readable expression of some of its key terms. Think of it as the user-friendly interface to the Legal Code beneath. This Deed itself has no legal value, and its contents do not appear in the actual license.

//Creative Commons is not a law firm and does not provide legal services. Distributing of, displaying of, or linking to this Commons Deed does not create an attorney-client relationship.



string animation;
string text = "Sit";
vector target = <-0.5,0,-0.2>;
vector rot = <0,-90,180>;
integer debug = FALSE;

default
{
    on_rez(integer start_param)
    {
        llResetScript();
    }

    state_entry()
    {
        animation = llGetInventoryName(INVENTORY_ANIMATION, 0);
        llSetText(text,<1,1,1>,1);
        llSetAlpha(1.0,ALL_SIDES);
        llSitTarget(target,llEuler2Rot(rot*DEG_TO_RAD));
    }
   
    link_message(integer int,integer num,string str,key id)
    {                   
        if(str == "sync")
        {
            if (debug) llSay(0,"Re-syncing slave");
            llStopAnimation(animation);
            llStartAnimation(animation);
        }         
        if(str == "show")
        {
            llSetAlpha(1.0,ALL_SIDES);
            llSetText(text,<1,1,1>,1);
        }           
        if(str == "hide")
        {
            llSetAlpha(0.0,ALL_SIDES);
            llSetText("",<1,1,1>,1);
        }
    }

    changed(integer change)
    {
        if(change & CHANGED_LINK)
        {
            key avatar = llAvatarOnSitTarget();
            if(avatar != NULL_KEY)
            {
                llRequestPermissions(avatar,PERMISSION_TRIGGER_ANIMATION);
            }
            else
            {
                if (llGetPermissionsKey() != NULL_KEY)
                {
                    llStopAnimation(animation);
                    llResetScript();
                }
            }
        }       
    }

    run_time_permissions(integer parm)
    {
        if(parm == PERMISSION_TRIGGER_ANIMATION)
        {
            llStopAnimation("sit");
            llMessageLinked(LINK_ALL_OTHERS, 0, "otherAvie", llAvatarOnSitTarget());
            llMessageLinked(LINK_ALL_OTHERS, 0, "sync", "NULL_KEY");
            llStartAnimation(animation);
            llSetAlpha(0.0,ALL_SIDES);
            llSetText("",<1,1,1>,1);
        }
    }   
}