//MLP MULTI-LOVE-POSE V1.2 - Copyright (c) 2006, by Miffy Fluffy (BSD License)
integer a;
integer ch;
integer p;
integer swap;
integer z;
string pr1;
string pr2;
list plist;
list positions1;
list positions2;
list rotations1;
list rotations2;
vector pos;
vector pos0;
vector pos1;
vector pos2;
vector rot1;
vector rot2;
rotation rot;

getRefPos() {   //reference position
    pos = llGetPos();
    rot = llGetRot();
    pos0 = pos;
    z = (integer)llGetObjectDesc();
    pos.z += (float)z/100;
}
getPos() {
    pos1 = (vector)llList2String(positions1, p);
    pos2 = (vector)llList2String(positions2, p);
    rot1 = (vector)llList2String(rotations1, p);
    rot2 = (vector)llList2String(rotations2, p);
}
setPos() {
    pr1 = (string)(pos1*rot + pos);
    pr2 = (string)(pos2*rot + pos);
    pr1 += (string)(llEuler2Rot(rot1*DEG_TO_RAD) * rot);
    pr2 += (string)(llEuler2Rot(rot2*DEG_TO_RAD) * rot);
    llSay(ch+swap,pr1);     //msg to ball1/2
    llSay(ch+!swap,pr2);
}
default {
    state_entry() {
        getRefPos();
        ch = (integer)("0x"+llGetSubString((string)llGetKey(),-4,-1));          //fixed channel for prim
    }
    link_message(integer from, integer num, string pdata, key akey) {
        if (pdata == "PRIMTOUCH"){
            return;
        }
        if (num != 3) return;
        if ((integer)((string)akey) != a) { llOwnerSay("debug ~pos mismatch a "+(string)akey+" "+(string)a); return; }//
        if (pdata == "LOADED") state on;
        plist = llParseString2List(pdata,[" "],[]);
        positions1 += llList2List(plist,0,0);
        positions2 += llList2List(plist,2,2);
        rotations1 += llList2List(plist,1,1);
        rotations2 += llList2List(plist,3,3);
        //positions1 = llList2List(plist,0,0) + (positions1 = []) + positions1;   //trick to save memory
        //positions2 = llList2List(plist,2,2) + (positions2 = []) + positions2;   //but not useful after
        //rotations1 = llList2List(plist,1,1) + (rotations1 = []) + rotations1;   // replacing positions
        //rotations2 = llList2List(plist,3,3) + (rotations2 = []) + rotations2;
        ++a;
    }
    state_exit() {
        llOwnerSay((string)a+" positions loaded ("+llGetScriptName()+": "+(string)llGetFreeMemory()+" bytes free)");
    }
}
state on {    
    link_message(integer from, integer num, string cmd, key pkey) {
        if (cmd == "PRIMTOUCH"){
            return;
      }
        if (num) return;
        if (cmd == "POSE") {
            p = (integer)((string)pkey);
            //p = -(integer)((string)pkey) - 1;   //read reversed when using memory saving trick above ^
            getPos();
            setPos();
        } else if (cmd == "SWAP") {
            swap = !swap;
            llSay(ch+swap,pr1);         //msg to ball1/2
            llSay(ch+!swap,pr2);
        } else if (cmd == "REPOS") {
            getRefPos();
        } else if (llGetSubString(cmd, 0, 0) == "Z") {
            z += (integer)llGetSubString(cmd, 1, -1);
            pos.z = pos0.z + (float)z/100;
            setPos();
            llOwnerSay("Height Adjustment Z "+(string)z+"cm");
            llSetObjectDesc((string)z);
        } else if (cmd == "GETREFPOS") {
            llMessageLinked(LINK_THIS,8,(string)pos,(string)rot);   //send reference position to pose
        } else if (cmd == "SAVE2") {                                //replace positions
            plist = llParseString2List((string)pkey,[" "],[]);
            positions1 = llListReplaceList(positions1,llList2List(plist,0,0),p,p);
            positions2 = llListReplaceList(positions2,llList2List(plist,2,2),p,p);
            rotations1 = llListReplaceList(rotations1,llList2List(plist,1,1),p,p);
            rotations2 = llListReplaceList(rotations2,llList2List(plist,3,3),p,p);
            llOwnerSay("("+llGetScriptName()+": "+(string)llGetFreeMemory()+" bytes free, "+(string)a+" positions)");
            getPos();
            setPos();
        }
    }
} 