// Script Name: Visitor_List_Maker.lsl
// Author: Anonymous
//Visitor List Maker.lsl

// Downloaded from : http://www.free-lsl-scripts.com/cgi/freescripts.plx?ID=1223

// This program is free software; you can redistribute it and/or modify it.
// Additional Licenes may apply that prevent you from selling this code
// and these licenses may require you to publish any changes you make on request.
//
// There are literally thousands of hours of work in these scripts. Please respect
// the creators wishes and Copyright law and follow their license requirements.
//
// License information included herein must be included in any script you give out or use.
// Licenses may also be included in the script or comments by the original author, in which case
// the authors license must be followed, and  their licenses override any licenses outlined in this header.
//
// You cannot attach a license to any of these scripts to make any license more or less restrictive.
//
// All scripts by avatar Ferd Frederix, unless stated otherwise in the script, are licensed as Creative Commons By Attribution and Non-Commercial.
// Commercial use is NOT allowed - no resale of my scripts in any form.  
// This means you cannot sell my scripts but you can give them away if they are FREE.  
// Scripts by Ferd Frederix may be sold when included in a new object that actually uses these scripts. Putting my script in a prim and selling it on marketplace does not constitute a build.
// For any reuse or distribution, you must make clear to others the license terms of my works. This is done by leaving headers intact.
// See http://creativecommons.org/licenses/by-nc/3.0/ for more details and the actual license agreement.
// You must leave any author credits and any headers intact in any script you use or publish.
///////////////////////////////////////////////////////////////////////////////////////////////////
// If you don't like these restrictions and licenses, then don't use these scripts.
//////////////////////// ORIGINAL AUTHORS CODE BEGINS ////////////////////////////////////////////

// CATEGORY:Visitor Counter
// DESCRIPTION:Visitor List Maker.lsl
// ARCHIVED BY:Ferd Frederix

// Global variables
list visitor_list;
float range = 250.0; // in meters
float rate = 1.0; // in seconds
 
 
// Functions
integer isNameOnList( string name )
{
    integer len = llGetListLength( visitor_list );
    integer i;
    for( i = 0; i < len; i++ )
    {
        if( llList2String(visitor_list, i) == name )
        {
            return TRUE;
        }
    }
    return FALSE;
}
 
// States
default
{
    state_entry()
    {
        llSay(0, "Visitor List Maker started...");
        llSay(0, "The owner can say 'help' for instructions."); 
        llSensorRepeat( "", "", AGENT, range, TWO_PI, rate );
        llListen(0, "", llGetOwner(), "");
    }
      
                
    sensor( integer number_detected )
    {
        integer i;
        for( i = 0; i < number_detected; i++ )
        {
            if( llDetectedKey( i ) != llGetOwner() )
            {
                string detected_name = llDetectedName( i );
                if( isNameOnList( detected_name ) == FALSE )
                {
                    visitor_list += detected_name;
                }
            }
        }    
    }
    
    listen( integer channel, string name, key id, string message )
    {
        if( id != llGetOwner() )
        {
            return;
        }
        
        if( message == "help" )
        {
            llSay( 0, "This object records the names of everyone who" );
            llSay( 0, "comes within "+ (string)range + " meters." );
            llSay( 0, "Commands the owner can say:" );
            llSay( 0, "'help'  - Shows these instructions." );
            llSay( 0, "'say list'   - Says the names of all visitors on the list.");
            llSay( 0, "'reset list' - Removes all the names from the list." );
        }
        else
        if( message == "say list" )
        {
            llSay( 0, "Visitor List:" );
            integer len = llGetListLength( visitor_list );
            integer i;
            for( i = 0; i < len; i++ )
            {
                llSay( 0, llList2String(visitor_list, i) );
            }
            llSay( 0, "Total = " + (string)len ); 
        }
        else
        if( message == "reset list" )
        {
            visitor_list = llDeleteSubList(visitor_list, 0, llGetListLength(visitor_list));
            llSay( 0, "Done resetting.");
        }
    }        
}

// END //


