
// relay detection routine Dirk Mathers
integer RLV_cmd_channel = -1812221819;
integer detectChan;
integer listener;
float hangtime=4.0;
key target;

default
{
    link_message(integer source, integer num, string str, key id)
    {
        if (num=8889)
        {
            target=id;
            state checking;
        }
    }
}

state checking
{
    state_entry()
    {
        detectChan = (integer)((llFrand(100000000) + 100000000));  
        listener=llListen(detectChan, "", NULL_KEY, "");
        string cmd_line = llGetObjectName() + "," + (string)target +","+ "@version=" + (string)detectChan;
        llSay(RLV_cmd_channel,cmd_line);
        llSetTimerEvent(hangtime);
    }

    timer()
    {
        llListenRemove(listener);
        llSetTimerEvent(0);
        llMessageLinked(LINK_THIS, 8888, "0", target);
        state default;
    }

    listen(integer chan, string name, key id, string msg)
    {
        llListenRemove(listener);
        if ((chan==detectChan) && (llGetSubString(msg,0,13)=="RestrainedLife"))
        {
            // An RLV relay responded back
            llMessageLinked(LINK_THIS, 8888, "1", target);
            state default;
        }
    }
}