//MLP MULTI-LOVE-POSE V1.2 - Copyright (c) 2006, by Miffy Fluffy (BSD License)
integer PINK1 = 1;  //0001 binary
integer BLUE1 = 2;  //0010 binary
integer PINK2 = 4;  //0100 binary
integer BLUE2 = 8;  //1000 binary
integer a;
integer alive;
integer b;
integer b0;
integer ballusers;
integer c;
integer ch;
integer chat = 1;
integer group;
integer hear;
integer i;
integer line;
integer menu;
integer menuusers;
integer redo = 1;
integer rez;
integer swap;
integer visible;
float alpha;
string cmd;
string pose;
string pose0;
key owner;
key user;
key user0;
list buttons;
list buttonindex;
list commands;
list menus;
list balls;
list users;

//menu partly based on Menu Engine by Zonax Delorean (BSD License)
//llDialog(user, menuname, buttons(from index to nextindex-1), channel)  
doMenu() {
    b0 = llList2Integer(buttonindex, menu);         //position of first button for this (sub)menu
    b = llList2Integer(buttonindex, menu+1);        //position of first button for next (sub)menu
    llDialog(user, llList2String(menus,menu), llList2List(buttons, b0, b - 1), ch - 1);
    c = llList2Integer(balls,menu);         //ballcolors
    if (c) {                                //if submenu includes ballcolor(s):
        if (!rez) rezBalls();               //if no balls present: create balls
        llSay(ch,(string)(c & 3));          //ball1color: mask with 3 = 0011 binary
        llSay(ch+1,(string)(c >> 2));       //ball2color: shift 2 bits to the right
        if (ballusers) setBalls("GROUP");   //if group access only
    }
    llResetTime();
    //if (user != llGetOwner()) llOwnerSay("("+llKey2Name(user)+" selects "+llList2String(menus,menu)+")");     //owner will receive info
}
say(string str) {
    if (menuusers) llWhisper(0,str);
    else llOwnerSay(str);
}
setBalls(string cmd) {
    llSay(ch,cmd);      //msg to balls
    llSay(ch+1,cmd);
}
rezBalls() {
    setBalls("DIE");
    llRezObject("~ball",llGetPos(),ZERO_VECTOR,ZERO_ROTATION,ch);
    llRezObject("~ball",llGetPos(),ZERO_VECTOR,ZERO_ROTATION,ch+1);
    llMessageLinked(LINK_THIS,0,"REPOS",NULL_KEY);  //msg to pos
    llMessageLinked(LINK_THIS,0,"POSE","0");        //msg to pos/pose
    rez = 1;
    alive = 2;
    pose = pose0;
    llSetTimerEvent(60);
    if (chat) say("Balls ready");
}

default {
    state_entry() {
        //llSetScriptState("~run", TRUE);
        llResetOtherScript("~pos");
        llResetOtherScript("~pose");
        llResetOtherScript("~pose1");
        llResetOtherScript("~pose2");
        ch = (integer)("0x"+llGetSubString((string)llGetKey(),-4,-1));  //fixed channel for prim
        setBalls("DIE");
        alpha = llGetAlpha(0);                                          //store object transparancy (alpha)
        if (alpha < 0.1) alpha = 0.5; else visible = 1;                 //if invisible store a visible alpha
        llMessageLinked(LINK_THIS,1,"OK?",NULL_KEY);                    //msg to memory: ask if ready
    }
    link_message(integer from, integer num, string str, key id) {
        if (num == 2) {
            if (str == "OK") state load;                                //memory ready
        }
    }
}           
state load {
    state_entry() {
        llGetNotecardLine(".MENUITEMS",0);                              //read first line of menuitems notecard
    }
    dataserver(key query_id, string data) {                                 
        if (data == EOF) state on;
        i = llSubStringIndex(data,"//");                                //remove comments
        if (i != -1) {
            if (i == 0) data = "";
            else data = llGetSubString(data, 0, i - 1);
        }
        while (llGetSubString(data, -1, -1) == " ") data = llDeleteSubString(data, -1, -1); //remove spaces from end
        if (data != "") {
            i = llSubStringIndex(data," ");
            cmd = data;                      
            if (i != -1) {                                              //split command from data
                cmd = llGetSubString(data, 0, i - 1);
                data = llGetSubString(data, i+1, -1);
            }
            list ldata = llParseString2List(data,["  |  ","  | "," |  "," | "," |","| ","|"],[]);
            data = llList2String(ldata, 0);
            if (cmd == "MENU") {
                if (a < 2) {
                    llOwnerSay("warning: first item in .MENUITEMS must be: POSE stand");
                    llOwnerSay("warning: second item in .MENUITEMS must be: POSE default");
                }
                llOwnerSay("loading data for '"+data+"'");             
                if (llList2String(ldata, 1) == "GROUP") menu = 1;       //access to submenus
                else if (llList2String(ldata, 1) != "OWNER") menu = 2;  //0=owner 1=group 2=all
                pose = llList2String(ldata, 2);
                if (pose == "PINK") rez = PINK1;
                else if (pose == "BLUE") rez = BLUE1;
                pose = llList2String(ldata, 3);
                if (pose == "PINK") rez += PINK2;
                else if (pose == "BLUE") rez += BLUE2;
                menus += [ data ];
                balls += [ rez ];
                buttonindex += [ b ];
                users += [ menu ];
                rez = 0;
                b0 = 0;
                menu = 0;
            } else if (b0 < 12) {                                       //maximum 12 buttons per menu
                if (cmd == "POSE") {
                    llMessageLinked(LINK_THIS,1,data,(string)a);        //msg to memory
                    llMessageLinked(LINK_THIS,9+a,llList2String(ldata, 1),llList2String(ldata, 2));  //msg to pose
                    if (!a) pose0 = data;
                    cmd = (string)a;
                    ++a;
                } else if (cmd == "REDO") {
                    if (llList2String(ldata, 1) != "OFF") redo = 1;
                } else if (cmd == "CHAT") {
                    if (llList2String(ldata, 1) != "OFF") chat = 1;
                } else if (cmd == "BALLUSERS") {
                    if (llList2String(ldata, 1) == "GROUP") ballusers = 1;
                } else if (cmd == "MENUUSERS") {
                    if (llList2String(ldata, 1) == "GROUP") menuusers = 1;
                    else if (llList2String(ldata, 1) != "OWNER") menuusers = 2;
                }   
                commands += [ cmd ];
                buttons += [ data ];
                ++b;
                ++b0;
            }
        }
        ++line;
        llGetNotecardLine(".MENUITEMS",line);                           //read next line of menuitems notecard
    }
    state_exit() {
        buttonindex += [ b ];                                           //enter last buttonindex
        commands += [ "" ];                                             //empty command for undefined buttons (-1)
        llOwnerSay("READY");
        llOwnerSay((string)b+" menuitems loaded ("+llGetScriptName()+": "+(string)llGetFreeMemory()+" bytes free)");
        llMessageLinked(LINK_THIS,1,"LOADED",(string)a);                //msg to memory
        llMessageLinked(LINK_THIS,9+a,"LOADED",NULL_KEY);               //msg to pose
    }
}
state on {
    state_entry() {
        owner = llGetOwner();
        llSetTimerEvent(0);
        llListenRemove(hear);
        hear = llListen(ch - 1, "", NULL_KEY, "");                      //listen for pressed buttons
    }
    touch_start(integer i) {
        user0 = llDetectedKey(0);
        if (user0 == owner || (menuusers == 1 && llDetectedGroup(0)) || menuusers == 2) {   //0=owner 1=group 2=all
            if (user0 != user) {
                if (llGetTime() < 60) {
                    llDialog(user0, "\n"+llKey2Name(user)+" has just selected the menu, do you want to continue?", ["Yes","Cancel"], ch - 1);
                    return;
                }
                user = user0;
                group = llDetectedGroup(0);
            }
            menu = 0; doMenu();                                         //mainmenu
        }                 
    }
    
    listen(integer channel, string name, key user0, string button) {
        if (user0 != user) {
            if (button == "Yes") {
                user = user0;
                group = llSameGroup(user0);
                menu = 0; doMenu();
            } else if (button != "Cancel") {
                llDialog(user0, "\nSelection cancelled because "+llKey2Name(user)+" has just selected the menu, do you want to operate the menu again?", ["Yes","Cancel"], ch - 1);
            }
            return;
        }
        b = llListFindList(buttons,[ button ]);                         //find position of cmd
        string cmd = llList2String(commands,b);                         //get command
        //llSay(0,button+" "+cmd);                                      //debug
        if (cmd == "TOMENU") {                                             
            menu = llListFindList(menus,[ button ]);                    //find submenu
            if (menu == -1) return;
            i = llList2Integer(users, menu); 
            if (user == owner || (i == 1 && group) || i == 2) {         //0=owner 1=group 2=all
                doMenu(); return;
            }
            if (i == 1) llDialog(user0, "\n"+button+" menu deactivated\n(access by group only)", ["OK"], ch - 1);
            else llDialog(user0, "\n"+button+" menu deactivated\n(access by owner only)", ["OK"], ch - 1);
            menu = 0;
            return;
        } else if (cmd == "BACK") {
            menu = 0; doMenu();                                         //mainmenu
            return;
        } else if ((integer)cmd > 0) {                                  //POSE
            llMessageLinked(LINK_THIS,0,"POSE",cmd);                    //msg to pos/pose
            if (chat) say(button);
            pose = button;
        } else if (cmd == "SWAP") {
            llMessageLinked(LINK_THIS,0,"SWAP",NULL_KEY);               //msg to pos/pose
            swap = !swap;
        } else if (cmd == "STAND") {
            llMessageLinked(LINK_THIS,0,"POSE","0");                    //STAND msg to pos/pose
            if (chat) say(button);
            menu = 0;
            pose = pose0;
        } else if (cmd == "STOP") {
            llMessageLinked(LINK_THIS,0,"POSE","0");                    //STAND msg to pos/pose
            if (chat) say(button);
            setBalls("DIE");
            if (chat && rez) say("Balls removed");
            rez = 0;
            llSetTimerEvent(0);
            return;
        } else if (cmd == "ADJUST") {
            setBalls("ADJUST");
        } else if (cmd == "HIDE") {
            setBalls("0");
        } else if (cmd == "SHOW") {
            setBalls("SHOW");
        } else if (cmd == "DUMP") {
            llMessageLinked(LINK_THIS,1,"DUMP",NULL_KEY);
        } else if (cmd == "INVISIBLE") {
            visible = !visible;
            llSetAlpha((float)visible*alpha, ALL_SIDES);
        } else if (cmd == "REDO") {
            redo = !redo;
            if (redo) say(button+" ON"); else say(button+" OFF");
        } else if (cmd == "CHAT") {
            chat = !chat;
            if (chat) say(button+" ON"); else say(button+" OFF");
        } else if (cmd == "BALLUSERS") {
            ballusers = !ballusers;
            if (ballusers) {
                llOwnerSay(button+" GROUP");
                setBalls("GROUP");
            } else {    
                llOwnerSay(button+" ALL");
                setBalls("ALL");
            }
        } else if (cmd == "MENUUSERS") {
            if (user == owner) {
                if (!menuusers) {
                    menuusers = 1;
                    llOwnerSay(button+" GROUP");
                } else if (menuusers == 1) {
                    menuusers = 2;
                    llOwnerSay(button+" ALL");
                } else if (menuusers == 2) {
                    menuusers = 0;
                    llOwnerSay(button+" OWNER");
                }
            } else llWhisper(0,button+" (can be switched by owner only)");
        } else if (cmd == "RESET") {
            llMessageLinked(LINK_THIS,0,"POSE","0");                    //STAND msg to pos/pose
            setBalls("DIE");
            //llSleep(0.5);        
            if (chat) say(button);
            llResetScript();
        } else if (cmd == "OFF") {
            llMessageLinked(LINK_THIS,0,"POSE","0");                    //STAND msg to pos/pose
            setBalls("DIE");
            //llSleep(0.5);
            if (user == owner) {
                llOwnerSay(button);
                llResetOtherScript("~run");
                llResetScript();
            }
            llDialog(user0, "\n"+button+" button deactivated\n(access by owner only)", ["OK"], -1);
            return;
        } else if (llGetSubString(cmd, 0, 0) == "Z" || (cmd == "SAVE")) {    //SAVE //Z-adjust
            llMessageLinked(LINK_THIS,0,cmd,pose);                      //msg to pos/pose
            doMenu();
            return;
        }
        if (redo) doMenu();
    }
    
    
    link_message(integer from, integer num, string str, key id) { 
      if (str == "PRIMTOUCH") {
        user0 = id ;
        integer detected_group = num;    
        if (user0 == owner || (menuusers == 1 && detected_group) || menuusers == 2) {   //0=owner 1=group 2=all
            if (user0 != user) {
                if (llGetTime() < 60) {
                    llDialog(user0, "\n"+llKey2Name(user)+" has just selected the menu, do you want to continue?", ["Yes","Cancel"], ch - 1);
                    return;
                }
                user = user0;
                group = llDetectedGroup(0);
            }
            menu = 0; doMenu();                                         //mainmenu
        }                 
             return;
      }
      
        if (num != 2) return;
        if (str == "ALIVE") {
            ++alive;
        } else if (str == "DIE") {                                      //suicide msg from ball
            setBalls("DIE");
            menu = 0;
            rez = 0;
            llSetTimerEvent(0);
        } 
    }
    on_rez(integer r) {
        if (owner != llGetOwner()) llResetScript();
    }
    timer() {
        if (alive > 1) {    
            alive = 0;
            llSay(ch,"LIVE");           //msg to balls: stay alive
            llSay(ch+1,"LIVE"); 
        } else {                        //balls not rezzed properly anymore
            rezBalls();
            llSay(ch,(string)(c & 3));          //ball1color: mask with 3 = 0011 binary
            llSay(ch+1,(string)(c >> 2));       //ball2color: shift 2 bits to the right
            if (ballusers) setBalls("GROUP");   //if group access only
        }
    }
}    
 