//MLP MULTI-LOVE-POSE V1.2 - Copyright (c) 2006, by Miffy Fluffy (BSD License)
integer a;
integer ch;
integer hear1;
integer hear2;
integer i;
integer swap;
string an1;
string an2;
string pose;
string pr1;
string pr2;
list anims;
vector pos;
rotation rot;

string prStr(string str) {
    i = llSubStringIndex(str,">");
    vector p = ((vector)llGetSubString(str,0,i) - pos) / rot;
    vector r = llRot2Euler((rotation)llGetSubString(str,i+1,-1) / rot)*RAD_TO_DEG;
    return "<"+round(p.x, 3)+","+round(p.y, 3)+","+round(p.z, 3)+"> <"+round(r.x, 1)+","+round(r.y, 1)+","+round(r.z, 1)+">";
}
string round(float number, integer places) {
    float shifted;
    integer rounded;
    string s;
    shifted = number * llPow(10.0,(float)places);
    rounded = llRound(shifted);
    s = (string)((float)rounded / llPow(10.0,(float)places));
    s = llGetSubString(s,0,llSubStringIndex(s, ".")+places);
    //while (llGetSubString(s,-1,-1) == "0") s = llDeleteSubString(s,-1,-1);
    //if (llGetSubString(s,-1,-1) == ".") s = llDeleteSubString(s,-1,-1);
    return s;
}
default {
    state_entry() {
        ch = (integer)("0x"+llGetSubString((string)llGetKey(),-4,-1));  //fixed channel for prim
    }
    link_message(integer from, integer num, string an1str, key an2key) {
        if (num != 9+a) return;
        if (an1str == "LOADED") state on;
        an1 = an1str;
        an2 = (string)an2key;
        if (a>1) {
            if (an1 == "") an1 = llList2String(anims, 2);   //use default
            else if (llGetInventoryType(an1) != INVENTORY_ANIMATION) llSay(0,"animation '"+an1+"' not in inventory (ok for build-in animations, otherwise check)");
            if (an2 == "") an2 = llList2String(anims, 3);   //use default
            else if (llGetInventoryType(an2) != INVENTORY_ANIMATION) llSay(0,"animation '"+an2+"' not in inventory (ok for build-in animations, otherwise check)");
        } else if (a) { //pose1: set default
            if (an1 == "") an1 = "sit_ground";
            if (an2 == "") an2 = "sit_ground";
        } else {        //pose0: set stand
            if (an1 == "") an1 = "stand";
            if (an2 == "") an2 = "stand";
        }
        anims += [ an1, an2 ];
        ++a;
    }
    state_exit() {
        llOwnerSay((string)a+" posepairs loaded ("+llGetScriptName()+": "+(string)llGetFreeMemory()+" bytes free)");
    }
}
state on {
    link_message(integer from, integer num, string cmd, key akey) {
        if (cmd == "PRIMTOUCH"){
            return;
        }
        if (num) return;
        if (cmd == "POSE") {      
            a = (integer)((string)akey) * 2;
            an1 = llList2String(anims, a);
            an2 = llList2String(anims, a+1);
        } else if (cmd == "SWAP") {
            swap = !swap;
        } else if (cmd == "SAVE") {
            pose = (string)akey;
            state save;
        } else return;
        llMessageLinked(LINK_THIS,ch+swap, an1,NULL_KEY);   //msg to pose1/2
        llMessageLinked(LINK_THIS,ch+!swap,an2,NULL_KEY);
    }
}
state save {
    state_entry() {
        llMessageLinked(LINK_THIS,0,"GETREFPOS","");    //msg to pos: ask ref position
        pr1 = "";
        pr2 = "";
        hear1 = llListen(ch+8, "", NULL_KEY, "");
        hear2 = llListen(ch+9, "", NULL_KEY, "");
        llSay(ch,"SAVE");       //msg to balls
        llSay(ch+1,"SAVE");
        llSetTimerEvent(3);
    }
    listen(integer channel, string name, key id, string pr) {
        if (channel == ch+8+swap) pr1 = pr;
        else if (channel == ch+8+!swap) pr2 = pr;
        if (pr1 != "" && pr2 != "") {
            pr = prStr(pr1)+" "+prStr(pr2);
            llOwnerSay("{"+pose+"} "+pr);
            llMessageLinked(LINK_THIS,0,"SAVE2",pr);    //save to pos
            llMessageLinked(LINK_THIS,1,pose,pr);       //write to memory
            state on;
        }
    }
    link_message(integer from, integer num, string posstr, key rotkey) {
        if (posstr == "PRIMTOUCH"){
            return;
        }
        if (num != 8) return;
        pos = (vector)posstr;                   //reveive reference position from pos
        rot = (rotation)((string)rotkey);
    }
    timer() {
        state on;
    } 
     state_exit() {
        llSetTimerEvent(0);
        llListenRemove(hear1);
        llListenRemove(hear2);
    }   
} 