// BFE ISO helmet/Gas Mask Control 0.7.6
//
// Settings for debug/setup
integer rlvEnabled=TRUE;
integer debugMode=FALSE;
string encryptionKey="20110602164521";
// Setting to configure script functionality
string deviceName="Isolation hood";
integer gagFunction=TRUE;
integer hearingFunction=TRUE;
integer blindfoldFunction=TRUE;
integer visionFunction=FALSE;
integer hudFunction=FALSE;
integer leashFunction=TRUE;
integer timerFunction=TRUE;
integer restrictionsFunction=TRUE;
string lockSound="shackleclose";
string unlockSound="shackleopen";
string takeKeysSound="shackleopen";
string leaveKeysSound="shackleopen";
//=======================================================================
// Most settings under here should need to be changed
string blindRLVOn="@setdebug_renderresolutiondivisor:128=force,setenv_scenegamma:0.0=force,showworldmap=n,showminimap=n,showloc=n,showhovertextall=n,setdebug=n,setenv=n";
string blindRLVOff="@setdebug=y,setenv=y,setdebug_renderresolutiondivisor:1=force,setenv_scenegamma:1.0=force,showworldmap=y,showminimap=y,showloc=y,showhovertextall=y";
string linkDescription;
key keyHolder = NULL_KEY;
string keyHolderName;
key wearer = NULL_KEY;
string wearerName;
key toucher = NULL_KEY;
string nameToucher;
integer keysOnStatus = TRUE;
integer lockStatus = FALSE;
integer blindfoldStatus = FALSE;
integer visionLevel= 0;
integer gagLevel = 0;
integer hearingLevel=0;
integer imSendLevel=0;
integer imRecLevel=0;
integer shortEmoteStatus=0;
integer releaseTime;
integer timerRun=FALSE;
integer selfLockedTimer=FALSE;
integer wearerChangeColour=TRUE;
integer leashStatus=FALSE;
key leashTarget=NULL_KEY;
string leashRing="FRONT";
integer flyStatus=TRUE;
integer tplmStatus=TRUE;
integer tplocStatus=TRUE;
integer tplureStatus=TRUE;
integer sittpStatus=TRUE;
integer sitStatus=TRUE;
integer unsitStatus=TRUE;
key sitTarget=NULL_KEY;
integer showinvStatus=TRUE;
integer editStatus=TRUE;
integer rezStatus=TRUE;
integer viewnoteStatus=TRUE;
integer viewtextureStatus=TRUE;
integer viewscriptStatus=TRUE;
integer fartouchStatus=TRUE;
integer addattachStatus=TRUE;
integer addoutfitStatus=TRUE;
integer showworldmapStatus=TRUE;
integer showminimapStatus=TRUE;
integer showlocStatus=TRUE;
integer shownamesStatus=TRUE;
integer showhovertextworldStatus=TRUE;
integer listenHandleMenu;
integer listenHandleRLV;
integer menuChannel;
integer hearingMessageID=9988;
integer gagMessageID=9977;
integer leashMessageID=9922;
string menuMessage;
string statusMessage;
string menuLevel;
string selectedPartName;
integer menuExpireTime;
integer reloadDataTime;
integer reloadedData=FALSE;
list flags;
list rlvStatus1;
list rlvStatus2;
list rlvStatus3;
string value1;
string value2;
string value3;
string value4;
string value5;
string value6;
string retrievedData;
string retrievedMessage;
string data;
integer keyHolderPrim;
integer keyHolderNamePrim;
integer flagsPrim;
integer valuePrim1;
integer valuePrim2;
integer valuePrim3;
integer valuePrim4;
integer valuePrim5;
integer valuePrim6;
list menuMain;
list menuRestrictions=["movement", "clths/atch", "names/maps", "misc"];
//Function to show or hide the locks and change indicator light colour.
showLocks(integer show)
{
    integer i=1;
    while (i <= llGetNumberOfPrims())
    {
        linkDescription=(string)llGetLinkPrimitiveParams(i,[PRIM_DESC]);
        float alpha=(float)show;
        if (linkDescription=="lock") llSetLinkAlpha(i,alpha,ALL_SIDES);
        if (linkDescription=="light")
        {
            if (show==TRUE) llSetLinkColor(i, <255,0,0>, ALL_SIDES);
            else llSetLinkColor(i, <0,255,0>, ALL_SIDES);
        }
        ++i;
    }
}
//Function to generate status message for dialogues
generateStatusMessage()
{
    if (lockStatus==TRUE) statusMessage = deviceName + " is locked, ";
    else statusMessage = deviceName + " is unlocked, ";
    statusMessage += "keys are ";
    if (keysOnStatus==TRUE) statusMessage += "on.";
    else statusMessage += "taken by " + keyHolderName + ".";
    statusMessage += "\n\nWearer ";
    if (wearerChangeColour==TRUE)  statusMessage += "can ";
    else statusMessage += "cannot ";
    statusMessage += "change colours.";
}
//Function to display main Menu
displayMainMenu (key ID)
{
    generateStatusMessage();
    menuMessage=statusMessage;
    menuLevel="mainMenu";
    if (ID==keyHolder || keysOnStatus==TRUE || ID==wearer)
    {
        llListenRemove(listenHandleMenu);
        menuChannel = (integer)(llFrand(-1000000000.0) - 1000000000.0);
        menuMain=[];
        if (selfLockedTimer==FALSE)
        {
            if (ID==keyHolder || keysOnStatus==TRUE)
            {
                if (keysOnStatus==TRUE) menuMain=["take keys"];
                else menuMain=["leave keys"];
                if (lockStatus==TRUE) menuMain += ["unlock"];
                else menuMain += ["lock"];
                if (keysOnStatus==FALSE && wearerChangeColour==TRUE) menuMain += ["no wear clr"];
                else if (keysOnStatus==FALSE && wearerChangeColour==FALSE) menuMain += ["wearer clr"];
                if (lockStatus==TRUE)
                {
                    if (gagFunction==TRUE) menuMain += ["speech"];
                    if (hearingFunction==TRUE) menuMain += ["hearing"];
                    if (blindfoldFunction==TRUE)
                    {
                        if (blindfoldStatus==FALSE) menuMain += ["blindfold"];
                        else menuMain += ["unblindfold"];
                    }
                    if (visionFunction==TRUE) menuMain += ["vision"];
                    if (hudFunction==TRUE) menuMain += ["HUD control"];
                    if (leashFunction==TRUE) menuMain += ["leashing"];
                    if (timerFunction==TRUE) menuMain += ["timer"];
                    if (restrictionsFunction==TRUE) menuMain += ["restrictions"];
                }
            }
        }
        if ((wearerChangeColour==TRUE && ID==wearer) || ID==keyHolder) menuMain += ["colour","reset"];
        else menuMain += ["reset"];
        llDialog(ID, menuMessage, menuMain, menuChannel);
        listenHandleMenu = llListen( menuChannel, "", ID, "");
        menuExpireTime=llGetUnixTime() + 60;
    }
}
displaySpeechMenu (key ID)
{
    generateStatusMessage();
    menuMessage=statusMessage;
    menuMessage += "\n\nChat is: ";
    if (gagLevel==0) menuMessage += "normal.";
    if (gagLevel==1) menuMessage += "distorted.";
    if (gagLevel==2) menuMessage += "garbled.";
    if (gagLevel==3) menuMessage += "unintelligable.";
    if (gagLevel==4) menuMessage += "muted.";
    menuMessage += "\n\nInstant messages are: ";
    if (imSendLevel==0) menuMessage += "allowed.";
    if (imSendLevel==1) menuMessage += "blocked.";
    if (imSendLevel==2) menuMessage += "allowed only to keyholder.";
    menuLevel="speechMenu";
    if (ID==keyHolder || keysOnStatus==TRUE || ID==wearer)
    {
        llListenRemove(listenHandleMenu);
        menuChannel = (integer)(llFrand(-1000000000.0) - 1000000000.0);
        menuMain=[];
        if (ID==keyHolder || keysOnStatus==TRUE)
        {
            menuMain=["normal", "distorted", "garbled", "incoherent", "mute"];
            if (shortEmoteStatus==TRUE) menuMain += ["long emotes"];
            else menuMain+= ["short emotes"];
            if (imSendLevel==0) menuMain += ["no send im"];
            else if (imSendLevel==1) menuMain += ["im to me only"];
            else menuMain += ["send im"];

        }
        menuMain += ["main menu"];
        llDialog(ID, menuMessage, menuMain, menuChannel);
        listenHandleMenu = llListen( menuChannel, "", ID, "");
        menuExpireTime=llGetUnixTime() + 60;
    }
}
displayVisionMenu (key ID)
{
    generateStatusMessage();
    menuMessage=statusMessage;
    menuMessage += "\n\nVision is: ";
    if (visionLevel==0) menuMessage += "normal.";
    if (visionLevel==1) menuMessage += "slightly blurry.";
    if (visionLevel==2) menuMessage += "blurry.";
    if (visionLevel==3) menuMessage += "very blurry.";
    if (visionLevel==4) menuMessage += "poor.";
    menuLevel="visionMenu";
    if (ID==keyHolder || keysOnStatus==TRUE || ID==wearer)
    {
        llListenRemove(listenHandleMenu);
        menuChannel = (integer)(llFrand(-1000000000.0) - 1000000000.0);
        menuMain=[];
        if (ID==keyHolder || keysOnStatus==TRUE) menuMain=["normal", "s. blurry", "blurry", "v. blurry", "poor"];
        menuMain += ["main menu"];
        llDialog(ID, menuMessage, menuMain, menuChannel);
        listenHandleMenu = llListen( menuChannel, "", ID, "");
        menuExpireTime=llGetUnixTime() + 60;
    }
}
displayHearingMenu (key ID)
{
    generateStatusMessage();
    menuMessage=statusMessage;
    menuMessage += "\n\nHearing is: ";
    if (hearingLevel==0) menuMessage += "normal.";
    if (hearingLevel==1) menuMessage += "muffled.";
    if (hearingLevel==2) menuMessage += "blocked.";
    menuMessage += "\n\nInstant messages are: ";
    if (imRecLevel==0) menuMessage += "allowed.";
    if (imRecLevel==1) menuMessage += "blocked.";
    if (imRecLevel==2) menuMessage += "allowed only from keyholder.";
    menuLevel="hearingMenu";
    if (ID==keyHolder || keysOnStatus==TRUE || ID==wearer)
    {
        llListenRemove(listenHandleMenu);
        menuChannel = (integer)(llFrand(-1000000000.0) - 1000000000.0);
        menuMain=[];
        if (ID==keyHolder || keysOnStatus==TRUE)
        {
            menuMain=["normal", "muffled", "deaf"];
            if (imRecLevel==0) menuMain += ["no hear im"];
            else if (imRecLevel==1) menuMain += ["im from me only"];
            else menuMain += ["hear im"];

        }
        menuMain += ["main menu"];
        llDialog(ID, menuMessage, menuMain, menuChannel);
        listenHandleMenu = llListen( menuChannel, "", ID, "");
        menuExpireTime=llGetUnixTime() + 60;
    }
}
displayRestrictionsMenu (key ID)
{
    generateStatusMessage();
    menuMessage=statusMessage;
    menuMessage += "\n\nRestrictions";
    menuLevel="restrictionsMenu";
    if (ID==keyHolder || keysOnStatus==TRUE || ID==wearer)
    {
        llListenRemove(listenHandleMenu);
        menuChannel = (integer)(llFrand(-1000000000.0) - 1000000000.0);
        menuMain=menuRestrictions;
        menuMain += ["main menu"];
        llDialog(ID, menuMessage, menuMain, menuChannel);
        listenHandleMenu = llListen( menuChannel, "", ID, "");
        menuExpireTime=llGetUnixTime() + 60;
    }
}
displayMiscRestrictionsMenu (key ID)
{
    generateStatusMessage();
    menuMessage=statusMessage;
    menuMessage += "\n\nMisc. Restrictions";
    menuLevel="miscRestrictionsMenu";
    if (ID==keyHolder || keysOnStatus==TRUE || ID==wearer)
    {
        llListenRemove(listenHandleMenu);
        menuChannel = (integer)(llFrand(-1000000000.0) - 1000000000.0);
        if (showinvStatus==TRUE) menuMain = ["hide inv"];
        else menuMain = ["show inv"];
        if (editStatus==TRUE) menuMain += ["no edit"];
        else menuMain += ["edit"];
        if (rezStatus==TRUE) menuMain += ["no rez"];
        else menuMain += ["rez"];
        if (viewnoteStatus==TRUE) menuMain += ["no notes"];
        else menuMain += ["notes"];
        if (viewtextureStatus==TRUE) menuMain += ["no pict."];
        else menuMain += ["view pict."];
        if (viewscriptStatus==TRUE) menuMain += ["no scripts"];
        else menuMain += ["edit scripts"];
        if (fartouchStatus==TRUE) menuMain += ["no far touch"];
        else menuMain += ["allow far touch"];
        menuMain += ["back"];
        llDialog(ID, menuMessage, menuMain, menuChannel);
        listenHandleMenu = llListen( menuChannel, "", ID, "");
        menuExpireTime=llGetUnixTime() + 60;
    }
}
displayMovementRestrictionsMenu (key ID)
{
    generateStatusMessage();
    menuMessage=statusMessage;
    menuMessage += "\n\nMovement. Restrictions";
    menuLevel="movementRestrictionsMenu";
    if (ID==keyHolder || keysOnStatus==TRUE || ID==wearer)
    {
        llListenRemove(listenHandleMenu);
        menuChannel = (integer)(llFrand(-1000000000.0) - 1000000000.0);
        if (flyStatus==TRUE) menuMain = ["no fly"];
        else menuMain = ["allow fly"];
        if (tplmStatus==TRUE) menuMain += ["no tp lm"];
        else menuMain += ["tp lm"];
        if (tplocStatus==TRUE) menuMain += ["no tp loc"];
        else menuMain += ["tp loc"];
        if (tplureStatus==TRUE) menuMain += ["no tp lure"];
        else menuMain += ["tp lure"];
        if (sittpStatus==TRUE) menuMain += ["no sit tp"];
        else menuMain += ["sit tp"];
        if (sitStatus==TRUE) menuMain += ["no sit"];
        else menuMain += ["allow sit"];
        if (unsitStatus==TRUE) menuMain += ["no stand"];
        else menuMain += ["allow stand"];
        menuMain += ["back"];
        llDialog(ID, menuMessage, menuMain, menuChannel);
        listenHandleMenu = llListen( menuChannel, "", ID, "");
        menuExpireTime=llGetUnixTime() + 60;
    }
}
displayNamesMapsRestrictionsMenu (key ID)
{
    generateStatusMessage();
    menuMessage=statusMessage;
    menuMessage += "\n\nNames and Map Restrictions";
    menuLevel="namesmapsRestrictionsMenu";
    if (ID==keyHolder || keysOnStatus==TRUE || ID==wearer)
    {
        llListenRemove(listenHandleMenu);
        menuChannel = (integer)(llFrand(-1000000000.0) - 1000000000.0);
        if (showworldmapStatus==TRUE) menuMain = ["no wrld map"];
        else menuMain = ["show wrld map"];
        if (showminimapStatus==TRUE) menuMain += ["no mini map"];
        else menuMain += ["show mini map"];
        if (showlocStatus==TRUE) menuMain += ["no location"];
        else menuMain += ["show location"];
        if (shownamesStatus==TRUE) menuMain += ["no names"];
        else menuMain += ["show names"];
        if (showhovertextworldStatus==TRUE) menuMain += ["no hover txt"];
        else menuMain += ["show hover txt"];
        menuMain += ["back"];
        llDialog(ID, menuMessage, menuMain, menuChannel);
        listenHandleMenu = llListen( menuChannel, "", ID, "");
        menuExpireTime=llGetUnixTime() + 60;
    }
}
displayClothesAttachmentsRestrictionsMenu (key ID)
{
    generateStatusMessage();
    menuMessage=statusMessage;
    menuMessage += "\n\nClothing and Attachment Restrictions";
    menuLevel="clothesattachmentsRestrictionsMenu";
    if (ID==keyHolder || keysOnStatus==TRUE || ID==wearer)
    {
        llListenRemove(listenHandleMenu);
        menuChannel = (integer)(llFrand(-1000000000.0) - 1000000000.0);
        if (addattachStatus==TRUE) menuMain = ["no add attach"];
        else menuMain = ["add attach"];
        if (addoutfitStatus==TRUE) menuMain += ["no add outfit"];
        else menuMain += ["add outfit"];
        menuMain += ["back"];
        llDialog(ID, menuMessage, menuMain, menuChannel);
        listenHandleMenu = llListen( menuChannel, "", ID, "");
        menuExpireTime=llGetUnixTime() + 60;
    }
}
displayLeashMenu (key ID)
{
    generateStatusMessage();
    menuMessage=statusMessage;
    menuMessage += "\n\nLeash Menu";
    menuLevel="leashMenu";
    if (ID==keyHolder || keysOnStatus==TRUE || ID==wearer)
    {
        llListenRemove(listenHandleMenu);
        menuChannel = (integer)(llFrand(-1000000000.0) - 1000000000.0);
        menuMain = ["unleash", "object", "person", "1m", "2m", "5m", "10m",  "20m", "30m","50m"];
        if (leashRing=="FRONT") menuMain += ["rear ring"];
        else menuMain += ["front ring"];
        menuMain += ["back"];
        llDialog(ID, menuMessage, menuMain, menuChannel);
        listenHandleMenu = llListen( menuChannel, "", ID, "");
        menuExpireTime=llGetUnixTime() + 60;
    }
}
displayTimerMenu (key ID)
{
    generateStatusMessage();
    menuMessage=statusMessage;
    menuMessage += "\n\nTimer is: ";
    if (timerRun==TRUE) menuMessage += "running.";
    else menuMessage += "stopped.";
    if (releaseTime > llGetUnixTime())
    {
        menuMessage += "\n\nTime Remaining: ";
        integer secondsLeft = (integer)((releaseTime - llGetUnixTime())/3600);
        if (secondsLeft > 0) menuMessage += (string)secondsLeft + " hours ";
        menuMessage += (string)(((releaseTime - llGetUnixTime()) - 3600*secondsLeft)/60) + " minutes";

    }
    else
    {
        releaseTime=llGetUnixTime();
    }
    if (ID==keyHolder || keysOnStatus==TRUE || ID==wearer)
    {
        llListenRemove(listenHandleMenu);
        menuChannel = (integer)(llFrand(-1000000000.0) - 1000000000.0);
        menuMain=[];
        if (ID==keyHolder || keysOnStatus==TRUE)
        {
            menuMain=["+10 m", "+5 m", "+1 m", "+10 h", "+5 h", "+1 h", "-1 h", "-5 m", "-1 m"];
            if (timerRun==TRUE) menuMain += ["stop"];
            else menuMain += ["start", "clear"];

        }
        menuLevel="timerMenu";
        menuMain += ["main menu"];
        llDialog(ID, menuMessage, menuMain, menuChannel);
        listenHandleMenu = llListen( menuChannel, "", ID, "");
        menuExpireTime=llGetUnixTime() + 60;
    }
}
// Functions to store, retrieve and process data
getDataPrims()
{
    integer i=1;
    while (i <= llGetNumberOfPrims())
    {
        string linkDescription=(string)llGetLinkPrimitiveParams(i,[PRIM_NAME]);
        if (linkDescription=="keyHolderPrim") keyHolderPrim=i;
        else if (linkDescription=="keyHolderNamePrim") keyHolderNamePrim=i;
        else if (linkDescription=="flagsPrim") flagsPrim=i;
        else if (linkDescription=="valuePrim1") valuePrim1=i;
        else if (linkDescription=="valuePrim2") valuePrim2=i;
        else if (linkDescription=="valuePrim3") valuePrim3=i;
        else if (linkDescription=="valuePrim4") valuePrim4=i;
        else if (linkDescription=="valuePrim5") valuePrim5=i;
        else if (linkDescription=="valuePrim6") valuePrim6=i;
        ++i;
    }
}
getData()
{
    retrievedData=llList2String(llGetLinkPrimitiveParams(keyHolderPrim, [PRIM_DESC]),0);
    retrievedMessage=llBase64ToString(llXorBase64StringsCorrect(retrievedData,llStringToBase64(encryptionKey)));
    keyHolder=(key)retrievedMessage;
    if (keyHolder==" ") keyHolder = NULL_KEY;
    if (debugMode==TRUE) llOwnerSay("Keyholder key: " +  (string)keyHolder);
    retrievedData=llList2String(llGetLinkPrimitiveParams(keyHolderNamePrim, [PRIM_DESC]),0);
    retrievedMessage=llBase64ToString(llXorBase64StringsCorrect(retrievedData,llStringToBase64(encryptionKey)));
    keyHolderName=retrievedMessage;
    if (debugMode==TRUE) llOwnerSay("Keyholder name: " + keyHolderName);
    retrievedData=llList2String(llGetLinkPrimitiveParams(flagsPrim, [PRIM_DESC]),0);
    retrievedMessage=llBase64ToString(llXorBase64StringsCorrect(retrievedData,llStringToBase64(encryptionKey)));
    flags = llParseString2List(retrievedMessage, ["|"], []);
    retrievedData=llList2String(llGetLinkPrimitiveParams(valuePrim1, [PRIM_DESC]),0);
    value1=llBase64ToString(llXorBase64StringsCorrect(retrievedData,llStringToBase64(encryptionKey)));
    retrievedData=llList2String(llGetLinkPrimitiveParams(valuePrim2, [PRIM_DESC]),0);
    value2=llBase64ToString(llXorBase64StringsCorrect(retrievedData,llStringToBase64(encryptionKey)));
    retrievedData=llList2String(llGetLinkPrimitiveParams(valuePrim3, [PRIM_DESC]),0);
    value3=llBase64ToString(llXorBase64StringsCorrect(retrievedData,llStringToBase64(encryptionKey)));
    retrievedData=llList2String(llGetLinkPrimitiveParams(valuePrim4, [PRIM_DESC]),0);
    value4=llBase64ToString(llXorBase64StringsCorrect(retrievedData,llStringToBase64(encryptionKey)));
    retrievedData=llList2String(llGetLinkPrimitiveParams(valuePrim5, [PRIM_DESC]),0);
    value5=llBase64ToString(llXorBase64StringsCorrect(retrievedData,llStringToBase64(encryptionKey)));
    retrievedData=llList2String(llGetLinkPrimitiveParams(valuePrim6, [PRIM_DESC]),0);
    value6=llBase64ToString(llXorBase64StringsCorrect(retrievedData,llStringToBase64(encryptionKey)));
}
saveData()
{
    data = llXorBase64StringsCorrect(llStringToBase64((string)keyHolder), llStringToBase64(encryptionKey));
    llSetLinkPrimitiveParamsFast(keyHolderPrim, [PRIM_DESC, data]);
    data = llXorBase64StringsCorrect(llStringToBase64(keyHolderName), llStringToBase64(encryptionKey));
    llSetLinkPrimitiveParamsFast(keyHolderNamePrim, [PRIM_DESC, data]);
    string flagsString = (string)lockStatus + "|" + (string)keysOnStatus;
    flagsString += "|" + (string)blindfoldStatus + "|" + (string)visionLevel + "|" + (string)gagLevel;
    flagsString += "|" + (string)hearingLevel + "|" + (string)imSendLevel + "|" + (string)imRecLevel;
    flagsString += "|" + (string)shortEmoteStatus + "|" + (string)timerRun + "|" + (string)selfLockedTimer;
    flagsString += "|" + (string)wearerChangeColour + "|" + (string)leashStatus;
    data = llXorBase64StringsCorrect(llStringToBase64(flagsString), llStringToBase64(encryptionKey));
    llSetLinkPrimitiveParamsFast(flagsPrim, [PRIM_DESC, data]);
    value1 = (string)releaseTime;
    value2 = (string)flyStatus + "|" + (string)tplmStatus + "|" + (string)tplocStatus;
    value2 += "|" + (string)tplureStatus + "|" + (string)sittpStatus + "|" + (string)sitStatus;
    value2 += "|" +(string)unsitStatus;
    value3 = (string)showinvStatus + "|" + (string)editStatus + "|" + (string)rezStatus;
    value3 += "|" + (string)viewnoteStatus + "|" + (string)viewtextureStatus;
    value3 += "|" + (string)viewscriptStatus + "|" + (string)fartouchStatus;
    value4 = (string)addattachStatus + "|" + (string)addoutfitStatus + "|" + (string)showworldmapStatus;
    value4 += "|" + (string)showminimapStatus + "|" + (string)showlocStatus;
    value4 += "|" + (string)shownamesStatus + "|" + (string)showhovertextworldStatus;
    value5=(string)leashTarget;
    value6=leashRing;
    data = llXorBase64StringsCorrect(llStringToBase64(value1), llStringToBase64(encryptionKey));
    llSetLinkPrimitiveParamsFast(valuePrim1, [PRIM_DESC, data]);
    data = llXorBase64StringsCorrect(llStringToBase64(value2), llStringToBase64(encryptionKey));
    llSetLinkPrimitiveParamsFast(valuePrim2, [PRIM_DESC, data]);
    data = llXorBase64StringsCorrect(llStringToBase64(value3), llStringToBase64(encryptionKey));
    llSetLinkPrimitiveParamsFast(valuePrim3, [PRIM_DESC, data]);
    data = llXorBase64StringsCorrect(llStringToBase64(value4), llStringToBase64(encryptionKey));
    llSetLinkPrimitiveParamsFast(valuePrim4, [PRIM_DESC, data]);
    data = llXorBase64StringsCorrect(llStringToBase64(value5), llStringToBase64(encryptionKey));
    llSetLinkPrimitiveParamsFast(valuePrim5, [PRIM_DESC, data]);
    data = llXorBase64StringsCorrect(llStringToBase64(value6), llStringToBase64(encryptionKey));
    llSetLinkPrimitiveParamsFast(valuePrim6, [PRIM_DESC, data]);
}
processData()
{
    lockStatus=llList2Integer(flags, 0);
    keysOnStatus=llList2Integer(flags, 1);
    blindfoldStatus=llList2Integer(flags, 2);
    visionLevel=llList2Integer(flags, 3);
    gagLevel=llList2Integer(flags, 4);
    hearingLevel=llList2Integer(flags, 5);
    imSendLevel=llList2Integer(flags, 6);
    imRecLevel=llList2Integer(flags, 7);
    shortEmoteStatus=llList2Integer(flags, 8);
    timerRun=llList2Integer(flags, 9);
    selfLockedTimer=llList2Integer(flags, 10);
    wearerChangeColour=llList2Integer(flags, 11);
    leashStatus=llList2Integer(flags, 12);
    releaseTime = (integer)value1;
    rlvStatus1=llParseString2List(value2, ["|"], []);
    rlvStatus2=llParseString2List(value3, ["|"], []);
    rlvStatus3=llParseString2List(value4, ["|"], []);
    flyStatus=llList2Integer(rlvStatus1, 0);
    tplmStatus=llList2Integer(rlvStatus1, 1);
    tplocStatus=llList2Integer(rlvStatus1, 2);
    tplureStatus=llList2Integer(rlvStatus1, 3);
    sittpStatus=llList2Integer(rlvStatus1, 4);
    sitStatus=llList2Integer(rlvStatus1, 5);
    unsitStatus=llList2Integer(rlvStatus1, 6);
    showinvStatus=llList2Integer(rlvStatus2, 0);
    editStatus=llList2Integer(rlvStatus2, 1);
    rezStatus=llList2Integer(rlvStatus2, 2);
    viewnoteStatus=llList2Integer(rlvStatus2, 3);
    viewtextureStatus=llList2Integer(rlvStatus2, 4);
    viewscriptStatus=llList2Integer(rlvStatus2, 5);
    fartouchStatus=llList2Integer(rlvStatus2, 6);
    addattachStatus=llList2Integer(rlvStatus3, 0);
    addoutfitStatus=llList2Integer(rlvStatus3, 1);
    showworldmapStatus=llList2Integer(rlvStatus3, 2);
    showminimapStatus=llList2Integer(rlvStatus3, 3);
    showlocStatus=llList2Integer(rlvStatus3, 4);
    shownamesStatus=llList2Integer(rlvStatus3, 5);
    showhovertextworldStatus=llList2Integer(rlvStatus3, 6);
    leashTarget=(key)value5;
    leashRing=value6;
    if (lockStatus==TRUE)
    {
        if (rlvEnabled==TRUE) llOwnerSay("@detach=n,editobj:" + (string)llGetKey() + "=n");
        showLocks(TRUE);
    }
    else
    {
        if (rlvEnabled==TRUE) llOwnerSay("@clear");
        showLocks(FALSE);
    }

    if (blindfoldStatus==TRUE)
    {
        if (rlvEnabled==TRUE)
        {
            llOwnerSay(blindRLVOn);
        }
    }
    else
    {
        if (rlvEnabled==TRUE)
        {
            llOwnerSay(blindRLVOff);
        }
    }
    if (shortEmoteStatus==TRUE) llOwnerSay("@emote=rem");
    else llOwnerSay("@emote=add");
    if (rlvEnabled==TRUE)
    {
        if (visionLevel==0)
        {
            llOwnerSay("@setdebug_renderresolutiondivisor=y");
            llOwnerSay("@setdebug_renderresolutiondivisor:1=force");
        }
        else if (visionLevel==1)
        {
            llOwnerSay("@setdebug_renderresolutiondivisor=y");
            llOwnerSay("@setdebug_renderresolutiondivisor:2=force");
            llOwnerSay("@setdebug_renderresolutiondivisor=n");
        }
        else if (visionLevel==2)
        {
            llOwnerSay("@setdebug_renderresolutiondivisor=y");
            llOwnerSay("@setdebug_renderresolutiondivisor:4=force");
            llOwnerSay("@setdebug_renderresolutiondivisor=n");
        }
        else if (visionLevel==3)
        {
            llOwnerSay("@setdebug_renderresolutiondivisor=y");
            llOwnerSay("@setdebug_renderresolutiondivisor:8=force");
            llOwnerSay("@setdebug_renderresolutiondivisor=n");
        }
        else if (visionLevel==4)
        {
            llOwnerSay("@setdebug_renderresolutiondivisor=y");
            llOwnerSay("@setdebug_renderresolutiondivisor:16=force");
            llOwnerSay("@setdebug_renderresolutiondivisor=n");
        }
        if (flyStatus==TRUE) llOwnerSay("@fly=y");
        else llOwnerSay("@fly=n");
        if (tplmStatus==TRUE) llOwnerSay("@tplm=y");
        else llOwnerSay("@tplm=n");
        if (tplocStatus==TRUE) llOwnerSay("@tploc=y");
        else llOwnerSay("@tploc=n");
        if (tplureStatus==TRUE) llOwnerSay("@tplure=y,tplure:" + (string)keyHolder + "=rem,accepttp:" + (string)keyHolder + "=rem");
        else llOwnerSay("@tplure=n,tplure:" + (string)keyHolder + "=add,accepttp:" + (string)keyHolder + "=add");
        if(sittpStatus==TRUE) llOwnerSay("@sittp=y");
        else llOwnerSay("@sittp=n");
        if(sitStatus==TRUE) llOwnerSay("@sit=y");
        else llOwnerSay("@sit=n");
        if (unsitStatus==TRUE) llOwnerSay("@unsit=y");
        else llOwnerSay("@unsit=n");
        if(showinvStatus==TRUE) llOwnerSay("@showinv=y");
        else llOwnerSay("@showinv=n");
        if(editStatus==TRUE) llOwnerSay("@edit=y");
        else llOwnerSay("@edit=n");
        if(rezStatus==TRUE) llOwnerSay("@rez=y");
        else llOwnerSay("@rez=n");
        if(viewnoteStatus==TRUE) llOwnerSay("@viewnote=y");
        else llOwnerSay("@viewnote=n");
        if (viewtextureStatus==TRUE) llOwnerSay("@viewtexture=y");
        else llOwnerSay("@viewtexture=n");
        if (viewscriptStatus==TRUE) llOwnerSay("@viewscript=y");
        else llOwnerSay("@viewscript=n");
        if (fartouchStatus==TRUE) llOwnerSay("@fartouch=y");
        else llOwnerSay("@fartouch=n");
        if(addattachStatus==TRUE) llOwnerSay("@addattach=y");
        else llOwnerSay("@addattach=n");
        if(addoutfitStatus==TRUE) llOwnerSay("@addoutfit=y");
        else llOwnerSay("@addoutfit=n");
        if(showworldmapStatus==TRUE) llOwnerSay("@showworldmap=y");
        else llOwnerSay("@showworldmap=n");
        if(showminimapStatus==TRUE) llOwnerSay("@showminimap=y");
        else llOwnerSay("@showminimap=n");
        if (showlocStatus==TRUE) llOwnerSay("@showloc=y");
        else llOwnerSay("@showloc=n");
        if(shownamesStatus==TRUE) llOwnerSay("@shownames=y");
        else llOwnerSay("@shownames=n");
        if (showhovertextworldStatus==TRUE) llOwnerSay("@showhovertextworld=y");
        else llOwnerSay("@showhovertextworld=n");
    }
    llSleep(2.0);
    if (gagLevel==0) llMessageLinked(LINK_SET, gagMessageID, "NONE", NULL_KEY);
    else if (gagLevel==1) llMessageLinked(LINK_SET, gagMessageID, "LOOSE", NULL_KEY);
    else if (gagLevel==2) llMessageLinked(LINK_SET, gagMessageID, "MEDIUM", NULL_KEY);
    else if (gagLevel==3) llMessageLinked(LINK_SET, gagMessageID, "TIGHT", NULL_KEY);
    else if (gagLevel==4) llMessageLinked(LINK_SET, gagMessageID, "MUTE", NULL_KEY);
    if (hearingLevel==0)  llMessageLinked(LINK_SET, hearingMessageID, "NORM", NULL_KEY);
    else if (hearingLevel==1) llMessageLinked(LINK_SET, hearingMessageID, "MUFFLE", NULL_KEY);
    else if (hearingLevel==2) llMessageLinked(LINK_SET, hearingMessageID, "DEAF", NULL_KEY);
    if (imSendLevel==0) llOwnerSay ("@sendim_sec=y");
    else if (imSendLevel==1) llOwnerSay ("@sendim_sec=n");
    else if (imSendLevel==2) llOwnerSay ("@sendim_sec=n,sendim:" + (string)keyHolder + "=add");
    if (imRecLevel==0) llOwnerSay ("@recvim_sec=y");
    if (imRecLevel==1) llOwnerSay ("@recvim_sec=n");
    if (imRecLevel==2) llOwnerSay ("@recvim_sec=n,recvim:" + (string)keyHolder + "=add");
    if (leashStatus==TRUE)
    {
        if(debugMode==TRUE) llOwnerSay("Attempting re-leash");
        if (leashRing=="FRONT") llMessageLinked(LINK_SET, leashMessageID, "FRONT RING", NULL_KEY);
        else llMessageLinked(LINK_SET, leashMessageID, "BACK RING", NULL_KEY);
        llMessageLinked(LINK_SET, leashMessageID, "LEASH_TARGET", leashTarget);
        llMessageLinked(LINK_SET, leashMessageID, "5", NULL_KEY);
        llMessageLinked(LINK_SET, leashMessageID, "RELEASH", NULL_KEY);
    }
}
default
{
    state_entry ()
    {
        getDataPrims();
        getData();
        processData();
        reloadDataTime=llGetUnixTime() + 60;
        llSetTimerEvent(5.0);
        wearer=llGetOwner();
        wearerName=llKey2Name(wearer);
    }
    touch_start(integer total_number)
    {
        toucher=llDetectedKey(0);
        if (toucher==keyHolder || keysOnStatus==TRUE || toucher==wearer)
        {
            menuLevel="mainMenu";
            displayMainMenu(toucher);
        }
        else llWhisper(0, "Sorry " + llKey2Name(toucher) + ", you do not have the keys to " + wearerName + "'s hood");
        return;
    }
    listen(integer channel, string name, key id, string choice)
    {
        llListenRemove(listenHandleMenu);
        if (channel==menuChannel && menuLevel=="mainMenu")
        {

            if (choice=="take keys")
            {
                keyHolder=id;
                keyHolderName=llKey2Name(keyHolder);
                keysOnStatus=FALSE;
                //showKeys(FALSE);
                saveData();
                llPlaySound(takeKeysSound,0.5);
                if (keyHolder != wearer) llWhisper (0, keyHolderName + " takes the keys from the locks in " + wearerName + "'s hood ensuring they have control over the locks.");
                else llWhisper (0, wearerName + " removes the keys form the locks on the hood ensuring only they have access.");
                displayMainMenu(id);
                return;
            }
            if (choice=="leave keys")
            {
                keyHolder=NULL_KEY;
                keyHolderName="";
                keysOnStatus=TRUE;
                //showKeys(TRUE);
                saveData();
                if (keyHolder != wearer) llWhisper (0, keyHolderName + " leaves the keys in the locks of " + wearerName + "'s hood allowing anyone access.");
                else llWhisper (0, wearerName + " leaves the keys in the locks of their hood allowing anyone access.");
                llPlaySound(leaveKeysSound,0.5);
                displayMainMenu(id);
                return;
            }
            if (choice=="lock")
            {
                if (keyHolder==NULL_KEY) keyHolder=id;
                keyHolderName=llKey2Name(keyHolder);
                if (rlvEnabled==TRUE) llOwnerSay("@detach=n,editobj:" + (string)llGetKey() + "=n");
                lockStatus=TRUE;
                keysOnStatus=FALSE;
                //showKeys(FALSE);
                showLocks(TRUE);
                saveData();
                if (keyHolder != wearer) llWhisper (0, keyHolderName + " locks the locks on " + wearerName + "'s hood ensuring it cannot be removed.");
                else llWhisper (0, wearerName + " locks the locks on their hood ensuring it cannot be removed.");
                llPlaySound(lockSound,0.5);
                displayMainMenu(id);
                return;
            }
            if (choice=="unlock")
            {
                if (rlvEnabled==TRUE) llOwnerSay("@clear");
                lockStatus=FALSE;
                keysOnStatus=FALSE;
                showLocks(FALSE);
                gagLevel=0;
                hearingLevel=0;
                blindfoldStatus=FALSE;
                imSendLevel=0;
                imRecLevel=0;
                visionLevel=0;
                shortEmoteStatus=FALSE;
                selfLockedTimer=FALSE;
                timerRun=FALSE;
                leashStatus=FALSE;
                leashRing="FRONT";
                leashTarget=NULL_KEY;
                llOwnerSay(blindRLVOff);
                llMessageLinked(LINK_SET, gagMessageID, "NONE", NULL_KEY);
                llMessageLinked(LINK_SET, hearingMessageID, "NORM", NULL_KEY);
                llMessageLinked(LINK_SET, leashMessageID, "UNLEASH", id);
                flyStatus=TRUE;
                tplmStatus=TRUE;
                tplocStatus=TRUE;
                tplureStatus=TRUE;
                sittpStatus=TRUE;
                sitStatus=TRUE;
                unsitStatus=TRUE;
                sitTarget=NULL_KEY;
                showinvStatus=TRUE;
                editStatus=TRUE;
                rezStatus=TRUE;
                viewnoteStatus=TRUE;
                viewtextureStatus=TRUE;
                viewscriptStatus=TRUE;
                fartouchStatus=TRUE;
                addattachStatus=TRUE;
                addoutfitStatus=TRUE;
                showworldmapStatus=TRUE;
                showminimapStatus=TRUE;
                showlocStatus=TRUE;
                shownamesStatus=TRUE;
                showhovertextworldStatus=TRUE;
                saveData();
                if (keyHolder != wearer) llWhisper (0, keyHolderName + " unlocks the locks on " + wearerName + "'s hood allowing it to be removed.");
                else llWhisper (0, wearerName + " unlocks the locks on their hood allowing it to be removed.");
                llPlaySound(unlockSound,0.5);
                displayMainMenu(id);
                return;
            }
            if (choice=="blindfold")
            {
                blindfoldStatus=TRUE;
                if (rlvEnabled==TRUE) llOwnerSay(blindRLVOn);
                llWhisper (0, keyHolderName + " attaches a blindfold to the hood leaving " + wearerName + " total darkness.");
                saveData();
                displayMainMenu(id);
                return;
            }
            if (choice=="unblindfold")
            {
                blindfoldStatus=FALSE;
                if (rlvEnabled==TRUE) llOwnerSay(blindRLVOff);
                llWhisper (0, keyHolderName + " removes the blindfold allowing " + wearerName + " to see again.");
                saveData();
                displayMainMenu(id);
                return;
            }
            if (choice=="reset")
            {
                llOwnerSay("@detach=n,sendim_sec=n,recvim_sec=n,showinv=n,edit=n,rez=n,shownames=n,showloc=n,tploc=n,tplm=n,tplure=n,addoutfit=n,addattach=n,fly=n");
                llOwnerSay("Starting reset of child scripts...");
                llMessageLinked(LINK_SET, gagMessageID, "RESET", NULL_KEY);
                llSleep(5.0);
                llMessageLinked(LINK_SET, hearingMessageID, "RESET", NULL_KEY);
                llMessageLinked(LINK_SET, leashMessageID, "RESET", NULL_KEY);
                llOwnerSay("Waiting for child scripts to reset...");
                llSleep(5.0);
                llOwnerSay("Resetting main script...");
                llResetScript();
            }
            if (choice=="no wear clr")
            {
                wearerChangeColour=FALSE;
                saveData();
                displayMainMenu(id);
                return;
            }
            else if (choice=="wearer clr")
            {
                wearerChangeColour=TRUE;
                saveData();
                displayMainMenu(id);
                return;
            }
            if (choice=="colour" && (id==keyHolder || id==llGetOwner())) llMessageLinked(LINK_THIS, 5566, "MENU", id);
            if (choice=="speech")
            {
                menuLevel="speechMenu";
                displaySpeechMenu(id);
                return;
            }
            if (choice=="hearing")
            {
                menuLevel="hearingMenu";
                displayHearingMenu(id);
                return;
            }
            if (choice=="timer")
            {
                menuLevel="timerMenu";
                displayTimerMenu(id);
                return;
            }
            if (choice=="restrictions")
            {
                menuLevel="restrictionsMenu";
                displayRestrictionsMenu(id);
                return;
            }
            if (choice=="vision")
            {
                menuLevel="visionMenu";
                displayVisionMenu(id);
                return;
            }
            if (choice=="leashing")
            {
                menuLevel="leashMenu";
                displayLeashMenu(id);
                return;
            }
        }
        else if (channel==menuChannel && menuLevel=="restrictionsMenu")
        {
            if (choice=="misc")
            {
                menuLevel="miscRestrictionsLevel";
                displayMiscRestrictionsMenu(id);
                return;
            }
            if (choice=="movement")
            {
                menuLevel="movementRestrictionsLevel";
                displayMovementRestrictionsMenu(id);
                return;
            }
            if (choice=="clths/atch")
            {
                menuLevel="clothesattachmentsRestrictionsLevel";
                displayClothesAttachmentsRestrictionsMenu(id);
                return;
            }
            if (choice=="names/maps")
            {
                menuLevel="namesmapsRestrictionsLevel";
                displayNamesMapsRestrictionsMenu(id);
                return;
            }
        }
        else if (channel==menuChannel && menuLevel=="speechMenu")
        {

            if (choice=="no send im")
            {
                imSendLevel=1;
                llOwnerSay ("@sendim_sec=n,sendim:" + (string)keyHolder + "=rem");
                llWhisper(0, keyHolderName + " attaches a jamming device to the hood preventing " + wearerName + " from sending instant messages.");
                saveData();
                displaySpeechMenu(id);
                return;
            }
            if (choice=="im to me only")
            {
                imSendLevel=2;
                llOwnerSay ("@sendim_sec=n,sendim:" + (string)keyHolder + "=add");
                llWhisper(0, keyHolderName + " adjusts the jamming device on " + wearerName + "'s hood allowing them to send instant messages to them only.");
                saveData();
                displaySpeechMenu(id);
                return;
            }
            if (choice=="send im")
            {
                imSendLevel=0;
                llOwnerSay ("@sendim_sec=y");
                llWhisper(0, keyHolderName + " removes the jamming device from " + wearerName + "'s hood allowing them to send instant messages.");
                saveData();
                displaySpeechMenu(id);
                return;
            }
            if (choice=="normal")
            {
                gagLevel=0;
                llMessageLinked(LINK_SET, gagMessageID, "NONE", NULL_KEY);
                llWhisper(0, keyHolderName + " removes the gag allowing " + wearerName + " to speak clearly.");
                saveData();
                displaySpeechMenu(id);
                return;
            }
            if (choice=="distorted")
            {
                gagLevel=1;
                llMessageLinked(LINK_SET, gagMessageID, "LOOSE", NULL_KEY);
                llWhisper(0, keyHolderName + " inserts a gag causing " + wearerName + " speech to become distorted.");
                saveData();
                displaySpeechMenu(id);
                return;
            }
            if (choice=="garbled")
            {
                gagLevel=2;
                llMessageLinked(LINK_SET, gagMessageID, "MEDIUM", NULL_KEY);
                llWhisper(0, keyHolderName + " inserts a large gag causing " + wearerName + " speech to become garbled.");
                saveData();
                displaySpeechMenu(id);
                return;
            }
            if (choice=="incoherent")
            {
                gagLevel=3;
                llMessageLinked(LINK_SET, gagMessageID, "TIGHT", NULL_KEY);
                llWhisper(0, keyHolderName + " adjusts the gag causing " + wearerName + " speech to become incoherent.");
                saveData();
                displaySpeechMenu(id);
                return;
            }
            if (choice=="mute")
            {
                gagLevel=4;
                llMessageLinked(LINK_SET, gagMessageID, "MUTE", NULL_KEY);
                llWhisper(0, keyHolderName + " adjusts the gag causing " + wearerName + " speech to be muted.");
                saveData();
                displaySpeechMenu(id);
                return;
            }
            if (choice=="short emotes")
            {
                shortEmoteStatus=TRUE;
                llOwnerSay("@emote=rem");
                llWhisper(0, keyHolderName + " adjusts the gag forcing " + wearerName + " to use short emotes only.");
                saveData();
                displaySpeechMenu(id);
                return;
            }
            if (choice=="long emotes")
            {
                shortEmoteStatus=FALSE;
                llOwnerSay("@emote=add");
                llWhisper(0, keyHolderName + " adjusts the gag allowing " + wearerName + " to use long emotes.");
                saveData();
                displaySpeechMenu(id);
                return;
            }
        }
        else if (channel==menuChannel && menuLevel=="hearingMenu")
        {
            if (choice=="no hear im")
            {
                imRecLevel=1;
                llOwnerSay ("@recvim_sec=n,recvim:" + (string)keyHolder + "=rem");
                llWhisper (0, keyHolderName + " attaches a jamming device to the hood preventing " + wearerName + " from hearing instant messages.");
                saveData();
                displayHearingMenu(id);
                return;
            }
            if (choice=="im from me only")
            {
                imRecLevel=2;
                llOwnerSay ("@recvim_sec=n,recvim:" + (string)keyHolder + "=add");
                llWhisper (0, keyHolderName + " adjusts the jamming device on " + wearerName + "'s hood allowing them to receive instant message from their keyholder only.");
                saveData();
                displayHearingMenu(id);
                return;
            }
            if (choice=="hear im")
            {
                imRecLevel=0;
                llOwnerSay("@recvim_sec=y");
                llWhisper(0, keyHolderName + " removes the jamming device from " + wearerName + "'s hood allowing them to receive instant messages.");
                saveData();
                displayHearingMenu(id);
                return;
            }
            if (choice=="normal")
            {
                hearingLevel=0;
                llMessageLinked(LINK_SET, hearingMessageID, "NORM", NULL_KEY);
                llWhisper(0, keyHolderName + " removes the ear pads from " + wearerName + "'s hood allowing them to hear clearly.");
                saveData();
                displayHearingMenu(id);
            }
            if (choice=="muffled")
            {
                hearingLevel=1;
                llMessageLinked(LINK_SET, hearingMessageID, "MUFFLE", NULL_KEY);
                llWhisper(0, keyHolderName + " places ear pads in " + wearerName + "'s hood preventing them from hearing clearly.");
                saveData();
                displayHearingMenu(id);
            }
            if (choice=="deaf")
            {
                hearingLevel=2;
                llMessageLinked(LINK_SET, hearingMessageID, "DEAF", NULL_KEY);
                llWhisper(0, keyHolderName + " places thick ear pads in " + wearerName + "'s hood preventing them from hearing at all.");
                saveData();
                displayHearingMenu(id);
            }
        }
        else if (channel==menuChannel && menuLevel=="miscRestrictionsMenu")
        {
            if (choice=="hide inv")
            {
                showinvStatus=FALSE;
                llOwnerSay("@showinv=n");
                saveData();
                displayMiscRestrictionsMenu(id);
            }
            else if (choice=="show inv")
            {
                showinvStatus=TRUE;
                llOwnerSay("@showinv=y");
                saveData();
                displayMiscRestrictionsMenu(id);
            }
            else if (choice=="no edit")
            {
                editStatus=FALSE;
                llOwnerSay("@edit=n");
                saveData();
                displayMiscRestrictionsMenu(id);
            }
            else if (choice=="edit")
            {
                editStatus=TRUE;
                llOwnerSay("@edit=y");
                saveData();
                displayMiscRestrictionsMenu(id);
            }
            else if (choice=="no rez")
            {
                rezStatus=FALSE;
                llOwnerSay("@rez=n");
                saveData();
                displayMiscRestrictionsMenu(id);
            }
            else if (choice=="rez")
            {
                rezStatus=TRUE;
                llOwnerSay("@rez=y");
                saveData();
                displayMiscRestrictionsMenu(id);
            }
            else if (choice=="no notes")
            {
                viewnoteStatus=FALSE;
                llOwnerSay("@viewnote=n");
                saveData();
                displayMiscRestrictionsMenu(id);
            }
            else if (choice=="notes")
            {
                viewnoteStatus=TRUE;
                llOwnerSay("@viewnote=y");
                saveData();
                displayMiscRestrictionsMenu(id);
            }
            else if (choice=="no pict.")
            {
                viewtextureStatus=FALSE;
                llOwnerSay("@viewtexture=n");
                saveData();
                displayMiscRestrictionsMenu(id);
            }
            else if (choice=="view pict.")
            {
                viewtextureStatus=TRUE;
                llOwnerSay("@viewtexture=y");
                saveData();
                displayMiscRestrictionsMenu(id);
            }
            else if (choice=="no scripts")
            {
                viewscriptStatus=FALSE;
                llOwnerSay("@viewscript=n");
                saveData();
                displayMiscRestrictionsMenu(id);
            }
            else if (choice=="edit scripts")
            {
                viewscriptStatus=TRUE;
                llOwnerSay("@viewscript=y");
                saveData();
                displayMiscRestrictionsMenu(id);
            }
            else if (choice=="no far touch")
            {
                fartouchStatus=FALSE;
                llOwnerSay("@fartouch=n");
                saveData();
                displayMiscRestrictionsMenu(id);
            }
            else if (choice=="allow far touch")
            {
                fartouchStatus=TRUE;
                llOwnerSay("@fartouch=y");
                saveData();
                displayMiscRestrictionsMenu(id);
            }
            return;
        }
        else if (channel==menuChannel && menuLevel=="movementRestrictionsMenu")
        {
            if (choice=="no fly")
            {
                flyStatus=FALSE;
                llOwnerSay("@fly=n");
                saveData();
                displayMovementRestrictionsMenu(id);
            }
            else if (choice=="allow fly")
            {
                flyStatus=TRUE;
                llOwnerSay("@fly=y");
                saveData();
                displayMovementRestrictionsMenu(id);
            }
            else if (choice=="no tp lm")
            {
                tplmStatus=FALSE;
                llOwnerSay("@tplm=n");
                saveData();
                displayMovementRestrictionsMenu(id);
            }
            else if (choice=="tp lm")
            {
                tplmStatus=TRUE;
                llOwnerSay("@tplm=y");
                saveData();
                displayMovementRestrictionsMenu(id);
            }
            else if (choice=="no tp loc")
            {
                tplocStatus=FALSE;
                llOwnerSay("@tploc=n");
                saveData();
                displayMovementRestrictionsMenu(id);
            }
            else if (choice=="tp loc")
            {
                tplocStatus=TRUE;
                llOwnerSay("@tploc=y");
                saveData();
                displayMovementRestrictionsMenu(id);
            }
            else if (choice=="no tp lure")
            {
                tplureStatus=FALSE;
                llOwnerSay("@tplure=n,tplure:" + (string)keyHolder + "=add,accepttp:" + (string)keyHolder + "=add");
                saveData();
                displayMovementRestrictionsMenu(id);
            }
            else if (choice=="tp lure")
            {
                tplureStatus=TRUE;
                llOwnerSay("@tplure=y,tplure:" + (string)keyHolder + "=rem,accepttp:" + (string)keyHolder + "=rem");
                saveData();
                displayMovementRestrictionsMenu(id);
            }
            else if (choice=="no sit tp")
            {
                sittpStatus=FALSE;
                llOwnerSay("@sittp=n");
                saveData();
                displayMovementRestrictionsMenu(id);
            }
            else if (choice=="sit tp")
            {
                sittpStatus=TRUE;
                llOwnerSay("@sittp=y");
                saveData();
                displayMovementRestrictionsMenu(id);
            }
            else if (choice=="no sit")
            {
                sitStatus=FALSE;
                llOwnerSay("@sit=n");
                saveData();
                displayMovementRestrictionsMenu(id);
            }
            else if (choice=="allow sit")
            {
                sitStatus=TRUE;
                llOwnerSay("@sit=y");
                saveData();
                displayMovementRestrictionsMenu(id);
            }
            else if (choice=="no stand")
            {
                unsitStatus=FALSE;
                llOwnerSay("@unsit=n");
                saveData();
                displayMovementRestrictionsMenu(id);
            }
            else if (choice=="allow stand")
            {
                unsitStatus=TRUE;
                llOwnerSay("@unsit=y");
                saveData();
                displayMovementRestrictionsMenu(id);
            }
            return;
        }
        else if (channel==menuChannel && menuLevel=="namesmapsRestrictionsMenu")
        {
            if (choice=="no wrld map")
            {
                showworldmapStatus=FALSE;
                llOwnerSay("@showworldmap=n");
                saveData();
                displayNamesMapsRestrictionsMenu(id);
            }
            else if (choice=="show wrld map")
            {
                showworldmapStatus=TRUE;
                llOwnerSay("@showworldmap=y");
                saveData();
                displayNamesMapsRestrictionsMenu(id);
            }
            else if (choice=="no mini map")
            {
                showminimapStatus=FALSE;
                llOwnerSay("@showminimap=n");
                saveData();
                displayNamesMapsRestrictionsMenu(id);
            }
            else if (choice=="show mini map")
            {
                showminimapStatus=TRUE;
                llOwnerSay("@showminimap=y");
                saveData();
                displayNamesMapsRestrictionsMenu(id);
            }
            else if (choice=="no location")
            {
                showlocStatus=FALSE;
                llOwnerSay("@showloc=n");
                saveData();
                displayNamesMapsRestrictionsMenu(id);
            }
            else if (choice=="show location")
            {
                showlocStatus=TRUE;
                llOwnerSay("@showloc=y");
                saveData();
                displayNamesMapsRestrictionsMenu(id);
            }
            else if (choice=="no names")
            {
                shownamesStatus=FALSE;
                llOwnerSay("@shownames=n");
                saveData();
                displayNamesMapsRestrictionsMenu(id);
            }
            else if (choice=="show names")
            {
                shownamesStatus=TRUE;
                llOwnerSay("@shownames=y");
                saveData();
                displayNamesMapsRestrictionsMenu(id);
            }
            else if (choice=="no hover txt")
            {
                showhovertextworldStatus=FALSE;
                llOwnerSay("@showhovertextworld=n");
                saveData();
                displayNamesMapsRestrictionsMenu(id);
            }
            else if (choice=="show hover txt")
            {
                showhovertextworldStatus=TRUE;
                llOwnerSay("@showhovertextworld=y");
                saveData();
                displayNamesMapsRestrictionsMenu(id);
            }
            return;
        }
        else if (channel==menuChannel && menuLevel=="clothesattachmentsRestrictionsMenu")
        {
            if (choice=="no add attach")
            {
                addattachStatus=FALSE;
                llOwnerSay("@addattach=n");
                saveData();
                displayClothesAttachmentsRestrictionsMenu(id);
            }
            else if (choice=="add attach")
            {
                addattachStatus=TRUE;
                llOwnerSay("@addattach=y");
                saveData();
                displayClothesAttachmentsRestrictionsMenu(id);
            }
            else if (choice=="no add outfit")
            {
                addoutfitStatus=FALSE;
                llOwnerSay("@addoutfit=n");
                saveData();
                displayClothesAttachmentsRestrictionsMenu(id);
            }
            else if (choice=="add outfit")
            {
                addoutfitStatus=TRUE;
                llOwnerSay("@addoutfit=y");
                saveData();
                displayClothesAttachmentsRestrictionsMenu(id);
            }
            return;
        }
        else if (channel==menuChannel && menuLevel=="visionMenu")
        {
            if (choice=="normal")
            {
                llOwnerSay("@setdebug_renderresolutiondivisor=y");
                llOwnerSay("@setdebug_renderresolutiondivisor:1=force");
                llWhisper(0, keyHolderName + " adjusts the visor on " + wearerName + "'s hood allowing them to see clearly.");
                visionLevel=0;
                saveData();
                displayVisionMenu(id);
            }
            else if (choice=="s. blurry")
            {
                llOwnerSay("@setdebug_renderresolutiondivisor=y");
                llOwnerSay("@setdebug_renderresolutiondivisor:2=force");
                llOwnerSay("@setdebug_renderresolutiondivisor=n");
                llWhisper(0, keyHolderName + " adjusts the visor on " + wearerName + "'s making their vision slightly blurry.");
                visionLevel=1;
                saveData();
                displayVisionMenu(id);
            }
            else if (choice=="blurry")
            {
                llOwnerSay("@setdebug_renderresolutiondivisor=y");
                llOwnerSay("@setdebug_renderresolutiondivisor:4=force");
                llOwnerSay("@setdebug_renderresolutiondivisor=n");
                llWhisper(0, keyHolderName + " adjusts the visor on " + wearerName + "'s making their vision blurry.");
                visionLevel=2;
                saveData();
                displayVisionMenu(id);
            }
            else if (choice=="v. blurry")
            {
                llOwnerSay("@setdebug_renderresolutiondivisor=y");
                llOwnerSay("@setdebug_renderresolutiondivisor:8=force");
                llOwnerSay("@setdebug_renderresolutiondivisor=n");
                llWhisper(0, keyHolderName + " adjusts the visor on " + wearerName + "'s making their vision very blurry.");
                visionLevel=3;
                saveData();
                displayVisionMenu(id);
            }
            else if (choice=="poor")
            {
                llOwnerSay("@setdebug_renderresolutiondivisor=y");
                llOwnerSay("@setdebug_renderresolutiondivisor:16=force");
                llOwnerSay("@setdebug_renderresolutiondivisor=n");
                llWhisper(0, keyHolderName + " adjusts the visor on " + wearerName + "'s making their vision almost useless.");
                visionLevel=4;
                saveData();
                displayVisionMenu(id);
            }

            return;
        }
        else if (channel==menuChannel && menuLevel=="timerMenu")
        {
            if (choice=="+10 m") releaseTime += 600;
            else if (choice=="+5 m") releaseTime += 300;
            else if (choice=="+1 m") releaseTime += 60;
            else if (choice=="+10 h") releaseTime += 36000;
            else if (choice=="+5 h") releaseTime += 18000;
            else if (choice=="+1 h") releaseTime += 3600;
            else if (choice=="-1 h") releaseTime -= 3600;
            else if (choice=="-5 m") releaseTime -= 300;
            else if (choice=="-1 m") releaseTime -= 60;
            saveData();
            if (choice=="start")
            {
                llWhisper(0, "Timer running");
                timerRun=TRUE;
                saveData();
                if (id==wearer)
                {
                    selfLockedTimer=TRUE;
                    llOwnerSay("You have locked your own timer.  You must now wait for your release.");
                    saveData();
                    displayMainMenu(id);
                    return;
                }
            }
            if (choice=="stop")
            {
                llWhisper(0, "Timer stopped");
                timerRun=FALSE;
                saveData();
            }
            if (choice=="clear")
            {
                releaseTime=llGetUnixTime();
                saveData();
            }
            if (choice=="main menu")
            {
                displayMainMenu(id);
                return;
            }
            displayTimerMenu(id);
            return;
        }
        else if (channel==menuChannel && menuLevel=="leashMenu")
        {
            if (choice=="front ring")
            {
                leashRing="FRONT";
                llMessageLinked(LINK_SET, leashMessageID, "FRONT RING", id);
                saveData();
            }
            else if (choice=="rear ring")
            {
                leashRing="BACK";
                llMessageLinked(LINK_SET, leashMessageID, "BACK RING", id);
                saveData();
            } 
             if (choice=="unleash") 
                {
                    llMessageLinked(LINK_SET, leashMessageID, "UNLEASH", id);
                    leashStatus=FALSE;
                    leashTarget=NULL_KEY;
                    saveData();
                }
                if (choice=="object") llMessageLinked(LINK_SET, leashMessageID, "OBJECT", id);
                if (choice=="person") llMessageLinked(LINK_SET, leashMessageID, "PERSON", id);
                if (choice=="1m") llMessageLinked(LINK_SET, leashMessageID, "1", id);
                if (choice=="2m") llMessageLinked(LINK_SET, leashMessageID, "2", id);
                if (choice=="5m") llMessageLinked(LINK_SET, leashMessageID, "5", id);
                if (choice=="10m") llMessageLinked(LINK_SET, leashMessageID, "10", id);
                if (choice=="20m") llMessageLinked(LINK_SET, leashMessageID, "20", id);
                if (choice=="30m") llMessageLinked(LINK_SET, leashMessageID, "30", id);
                if (choice=="50m") llMessageLinked(LINK_SET, leashMessageID, "50", id);
                if (choice=="back") displayMainMenu(id);
                else
                {
                    if (choice != "object" && choice !="person")
                    {
                        displayLeashMenu (id);
                    }
                } 
        }
        if (choice=="main menu")
        {
            menuLevel="mainMenu";
            displayMainMenu(id);
            return;
        }
    }
    timer ()
    {
        integer currentTime=llGetUnixTime();
        if (currentTime >= menuExpireTime) llListenRemove(listenHandleMenu); //Close menu listener
        if (reloadedData==FALSE)
        {
            if (currentTime >= reloadDataTime)
            {
                getData();
                processData();
                reloadedData=TRUE;
            }
        }
        if (timerRun==TRUE)
        {
            if (currentTime >= releaseTime)
            {
                llWhisper (0, "Timer has released " + wearerName);
                if (rlvEnabled==TRUE) llOwnerSay("@clear");
                lockStatus=FALSE;
                keysOnStatus=FALSE;
                //showKeys(FALSE);
                showLocks(FALSE);
                gagLevel=0;
                hearingLevel=0;
                blindfoldStatus=FALSE;
                imSendLevel=0;
                imRecLevel=0;
                visionLevel=0;
                shortEmoteStatus=FALSE;
                selfLockedTimer=FALSE;
                timerRun=FALSE;
                leashStatus=FALSE;
                leashRing="FRONT";
                leashTarget=NULL_KEY;
                llOwnerSay(blindRLVOff);
                llMessageLinked(LINK_SET, gagMessageID, "NONE", NULL_KEY);
                llMessageLinked(LINK_SET, hearingMessageID, "NORM", NULL_KEY);
                llMessageLinked(LINK_SET, leashMessageID, "UNLEASH", NULL_KEY);
                //Reset RLV restrictions
                flyStatus=TRUE;
                tplmStatus=TRUE;
                tplocStatus=TRUE;
                tplureStatus=TRUE;
                sittpStatus=TRUE;
                sitStatus=TRUE;
                unsitStatus=TRUE;
                sitTarget=NULL_KEY;
                showinvStatus=TRUE;
                editStatus=TRUE;
                rezStatus=TRUE;
                viewnoteStatus=TRUE;
                viewtextureStatus=TRUE;
                viewscriptStatus=TRUE;
                fartouchStatus=TRUE;
                addattachStatus=TRUE;
                addoutfitStatus=TRUE;
                showworldmapStatus=TRUE;
                showminimapStatus=TRUE;
                showlocStatus=TRUE;
                shownamesStatus=TRUE;
                showhovertextworldStatus=TRUE;
                saveData();
            }
        }

    }
    on_rez (integer startParam)
    {
        llResetScript();
    }
    attach (key attachKey)
    {
        if (attachKey != NULL_KEY)
        {
            llResetScript();
        }
    }
    changed (integer iChange)
    {
        if (iChange & CHANGED_TELEPORT)
        {
            llResetScript();
        }
        if (iChange & CHANGED_REGION)
        {
            llResetScript();
        }
    }
    link_message(integer sender_num, integer num, string str, key id)
    {
        if (num==leashMessageID && str=="LEASH_ACTIVE")
        {
            leashStatus=TRUE;
            leashTarget=id;
            saveData();
        }
    }
}