

key agent;
integer debug = FALSE;         // set to TRUE or FALSE for debug chat on various actions

vector Sitpos = <0,0,.1>;
vector Sitrot = <0,0,0>;
integer Sent = FALSE;

DEBUG(string str)
{
    if (debug)
        llOwnerSay( str);                    // Send the owner debug info so you can chase NPCS
}


default
{
    state_entry()
    {        
        llSetText("",<1,1,1>,1.0);
        rotation Sitrot2 = llEuler2Rot(DEG_TO_RAD * Sitrot);
        llSitTarget(Sitpos, Sitrot2);
    }
 
    on_rez(integer o)
    {
        llResetScript();
    }
    
    changed(integer change)
    {
        if (change & CHANGED_LINK)
        {
            agent = llAvatarOnSitTarget();
            if (agent != NULL_KEY)
            {                
                if( ! osIsNpc(agent) )
                {
                    llUnSit(agent);
                    llSay(0,"Sorry, you cannot ride that seat. Try the pumpkin.");
                    Sent = FALSE;
                }
                else
                {
                    if (! Sent++) {
                        DEBUG("Driver Seated");
                        llMessageLinked(LINK_SET,0,"FootmanSeated",agent);
                    }
                }
            }
        }
    }
    
}  