
integer debug = FALSE;         // set to TRUE or FALSE for debug chat on various actions

float DIST = 20;
 
// OpenSim & Bulletsim
  
//Carriage visibility
integer VISIBLE = 0     ;
integer INVISIBLE = 1   ;

// avatar control animations
string AvatarSit = "unisex-sit";
string AvatarRide = "HoldHarness";
string AvatarStand  = "M-Stand-01";
string AvatarWalk  = "M-Walk-01";

// Godmother
vector STARTPOS = <6,6,0>;
vector WALKTO = <6,-5,0>;

string whatsplayingGodmother = "";      // the currently playing NPC automation

key NPCKeyGodmother;

vector Destination; // place for a NPC to go.
integer started = FALSE;
string myState = "";

integer NPCisRunning;
string last_animation; // the last animation played on the owner
integer once;

DEBUG(string str)
{
    if (debug)
        llOwnerSay(llGetScriptName()+":" +  str);                    // Send the owner debug info so you can chase NPCS
}

SetTimer(integer p) {
    DEBUG("Timer=" + (string) p);
    llSetTimerEvent(p);
}

SetState(string s) {
    myState = s;
    DEBUG("State = " + s);
}

RemoveAllNPC() {
    DEBUG("Remove All NPC");
    osNpcRemove(NPCKeyGodmother); 
} 

Rotate (float Z) {
   vector input = <0, 0, Z> * DEG_TO_RAD;
    rotation rot = llEuler2Rot(input);
    
    osNpcSetRot(NPCKeyGodmother,rot);
}

NPCPlayGodmother(string what)
{
    if (whatsplayingGodmother != what) {
        //DEBUG("Playing Godmother animation " + what + ", stopping " + whatsplayingGodmother);
        osNpcStopAnimation(NPCKeyGodmother, whatsplayingGodmother);
        osNpcPlayAnimation(NPCKeyGodmother, what);
        whatsplayingGodmother = what;
    }       
}

key kSitGodmother;  // key of seat

StartNPCGodmother() {

    NPCKeyGodmother = osNpcCreate("Fairy", "Godmother", llGetPos()+STARTPOS, "AppearanceGodmother", OS_NPC_SENSE_AS_AGENT);    // no OS_NPC_SENSE_AS_AGENT allowed due to llSensor Use
     
     llSetObjectDesc(NPCKeyGodmother);
     
    //DEBUG("Godmother Created");
    whatsplayingGodmother = "sit";
    NPCPlayGodmother(AvatarStand);
    
    osNpcSay(NPCKeyGodmother,"Oh dear child, are you going to the ball?");
}

Boot(float alpha) {

    integer j = llGetNumberOfPrims();
    integer i = 0;
    float intens;
    if (alpha == 0) {
        llPlaySound("magic-wand-1",1.0);
        intens = 1;
    } else {
        llPlaySound("magic-string-spell-1",1.0);
        intens = 0;
    }
    
    for ( i = 1 ; i <= j; i ++) {
        string name = llGetLinkName(i);
        if (name == "Cinderella's Pumpkin")
        {
            llSetLinkAlpha(i,alpha, ALL_SIDES);
            llSetLinkAlpha(i,alpha, ALL_SIDES);
        } else {
            llSetLinkAlpha(i, intens, ALL_SIDES);
            llSetLinkAlpha(i, intens, ALL_SIDES);
        }
    }    
}

Type(integer sleep) {
    NPCPlayGodmother("avatar_type");
    llSleep(sleep);
    NPCPlayGodmother(AvatarStand);
}

default
{
    state_entry()
    {
        Boot(INVISIBLE);
        llMessageLinked(LINK_SET,0,"reset","");
       NPCKeyGodmother = llGetObjectDesc();
       osNpcRemove(NPCKeyGodmother);
       
       Boot(INVISIBLE);
       llMessageLinked(LINK_SET,0,"reset","");
       llSensorRepeat("","",AGENT,DIST,PI,10);
       
       llMessageLinked(LINK_SET,1000,"@reset","");
       llMessageLinked(LINK_SET,1001,"@reset","");
       llMessageLinked(LINK_SET,1002,"@reset","");
       llMessageLinked(LINK_SET,1003,"@reset","");
       
       llSleep(2);
       
      // llMessageLinked(LINK_SET,1000,"@go","");
       
    }
    
    on_rez(integer p) {
        llResetScript();   
    }
    
    
    sensor(integer n) {
        
        integer people = 0;
        while ( n > 0) {
            if (! osIsNpc(llDetectedKey(n-1))) {
                DEBUG("people");
                people++;
            }
            n--;
        }
        
        if (! started && people) {

            llMessageLinked(LINK_SET,1000,"@go","");
            llMessageLinked(LINK_SET,1001,"@go","");
            llMessageLinked(LINK_SET,1002,"@go","");
            llMessageLinked(LINK_SET,1003,"@go","");
            
            llPlaySound("Mouse1", 1.0);
            
            DEBUG("Godmother appears");
            started = TRUE;
            StartNPCGodmother();
        
            SetState("rezGodmother");
            Destination = WALKTO;
            SetTimer(1); 
            
        } else {
            if (started && !people) {
                DEBUG("Carriage disappears");
                SetTimer(0);
                Boot(INVISIBLE);
                llMessageLinked(LINK_SET,0,"reset","");
                started = FALSE;
                osNpcRemove(NPCKeyGodmother);
                
                llMessageLinked(LINK_SET,1000,"@reset","");
                llMessageLinked(LINK_SET,1001,"@reset","");
                llMessageLinked(LINK_SET,1002,"@reset","");
                llMessageLinked(LINK_SET,1003,"@reset","");
            }
        }
    }
     
    timer()
    {
        
        if (myState == "rezGodmother") {
            
            vector pos = osNpcGetPos(NPCKeyGodmother);
            
            if (llVecDist(pos, llGetPos() + Destination) > 1) {  
                NPCPlayGodmother(AvatarWalk);
                osNpcMoveToTarget(NPCKeyGodmother,llGetPos() + Destination,OS_NPC_NO_FLY );   
                SetTimer(1); // for walking 
            } else {
                NPCPlayGodmother(AvatarStand);
                Rotate(-180);
                llMessageLinked(LINK_SET,1000,"@say=Squeak","");
                Type(2);
                osNpcSay(NPCKeyGodmother,"Hello!  You need a carriage to take you to the ball.");
                SetState("pumpkin");
                SetTimer(5);
                
                Rotate(-270);
                return;
                
            }
        }  else if (myState == "pumpkin" ) {
                 
            Type(2);
            osNpcSay(NPCKeyGodmother,"Ah, this pumpkin will do.");
            Rotate(-180);
            SetState("bippyhorses");
            SetTimer(5);
            return;
            
        } else if (myState == "bippyhorses" ) {
        
            osNpcSay(NPCKeyGodmother,"Bippity Boppity Boo!");
            llPlaySound("magic-wand-1",1.0);
            
            NPCPlayGodmother("avatar_sword_strike_R"); 
            llSleep(1);
            
            Boot(VISIBLE);    // show carriage
            
            NPCPlayGodmother(AvatarStand);
            Rotate(-180);
            SetState("findrats");
            SetTimer(10);
            return;
            
        } else if (myState == "findrats" ) {   
        
            Type(2);
            osNpcSay(NPCKeyGodmother,"These mice will make fine horses.");
            
            llPlaySound("Mouse2", 1.0);
            llSleep(1);
            llMessageLinked(LINK_SET,1000,"@say=Eep!","");
            llMessageLinked(LINK_SET,1001,"@say=Oh!","");
            Rotate(-270);
            myState = "Wavewand";
            SetTimer(10);
            return;
                
        } else if (myState == "Wavewand" ) {  

           // llPlaySound("BippyMice",1.0);
            Type(2);
            osNpcSay(NPCKeyGodmother,"Bippity Boppety Boo ... Mice turn into horses, too!");
            
            llPlaySound("magic-wand-1",1.0);
            NPCPlayGodmother("avatar_sword_strike_R"); 
            llSleep(.5);
            NPCPlayGodmother(AvatarStand);
            
            myState = "showhorses";
            SetTimer(3);
            return;
            
        } else if (myState == "showhorses" ) {
        
            llMessageLinked(LINK_SET,1002,"Eeeeeeeee!","");
            llMessageLinked(LINK_SET,1004,"Weeee!","");
             
            llMessageLinked(LINK_SET,1000,"@reset","");
            llMessageLinked(LINK_SET,1001,"@reset","");
            llMessageLinked(LINK_SET,1002,"@reset","");
            llMessageLinked(LINK_SET,1003,"@reset","");
            
            llMessageLinked(LINK_SET,1,"horses","");
            
            SetTimer(10);
            SetState( "Goodtimes");
            return;

        } else if  (myState == "Goodtimes") {
            
            Type(2);
            osNpcSay(NPCKeyGodmother,0,"I know you willl have a great time at the ball! Sit on the carriage and drive up the road. The Prince awaits you!");
            SetState( "Theend");
           
        } else if  (myState == "Theend") {
            Type(2);
            
            osNpcShout(NPCKeyGodmother,0,"Remember to leave before the stroke of midnight!");
            
            SetTimer(0);
            llPlaySound("Crystal Chimes",1.0);
            osNpcRemove(NPCKeyGodmother);
            return;  
        }   
    }


    link_message(integer sender_number, integer number, string message, key id)
    {
        DEBUG(message);
        if (message == "Invisible" )
        {
            Boot(INVISIBLE);    // unshow carriage
            SetTimer(0);
        } else if (message == "Visible" && myState != "remove" ) {
            started = TRUE;
            Boot(VISIBLE);    // show carriage
            llMessageLinked(LINK_SET,1,"showhorses","");            
        } else if ( message== "Seated") {
            
            SetTimer(0);
        }
    }
}

 