
integer debug = FALSE;
         // set to TRUE or FALSE for debug chat on various actions
 
 
integer   link_Channel =   1003; // some random number you want to talk to this gadget on. Best if large and negative
float     TIMER = 1;         // faster = less jerky stopping.  How often the system checks the distance traveled.  Fastest you can go is 0.5 seconds
float     QUICK = 1;        // when we need to move to the next state, we use a QUICK timer
string    Appearance = "!BertAppearance";  // The name of the recorded Appearance notecard
string    Notecard = "!BertPath"; // The name of the recorded routes
integer   allowUsers = FALSE;  // If true, any user can get a Start NPC and Stop NPC menu.  Only groups and owners can get all commands if TRUE, or FALSE
float     MAXDIST = 2.0;       // how close a NPC has to get to a dest pos to continue to next state. Do not lower this too much, as it may miss the target
integer   WANDERRAND = TRUE;   // set to TRUE and they will pause during wanders a random number of seconds
float     WANDERTIME = 2.0;    // how long they stand after each @wander,if WANDERRAND is FALSE. If WANDERRAND is  TRUE, this is the max time
integer   WAIT = 20;        // wait for this number of seconds for the NPC to reach a destination (for safety). If it fails to reach a target, it will move on after this time.

float     REZTIME = 2.0;      // wait this long for NPC to rez in, then start the process
string    STAND = "M-Stand-01";     // the name of the default Stand animation
string    WALK = "M-Walk-01";       // the name of the default Walk animation
string    FLY = "Fly";        // the name of the default Fly animation
string    RUN = "Run";        // the name of the default Run animation
string    LAND = "Land";      // the name of the default land animation ( for birds only)
float     OffsetZ = 0.5;      // appear 0.5 meter above ground, this is added to all destinations to keep them from sinking in.  
float    SPEEDMULT =0.4;     // 1.0 = regular avatar speed. Smaller numbers slow down walks. Large numbers speed them up.
integer  FLIGHT = 299;        // For controlling wings.  A channel that is shouted at when flight starts and ends. "flying" or "landing" 

// DESCRIPTIONS FIELDS HAVE TO SURVIVE A RESET
//  These vars are stored  by saving them with KeyValueSet
// "pr" is a 0 if it is set for Owner Only, 1 for Group control
// "se" is "on" if Started
// "co" = "R" or "A" for relative or absolute addressing mode
// "key" = NPC key

// These Globals used to be stored in description.   Moved to RAM in V1.6
float RAMPause;          // @pause param
float RAMwd ;            // @wander distance
integer RAMwc;           // @wander count
float RAMrot;            //  @rotate
string RAMsit;           // @sit primname
string RAMtouch;         // @touch primname
string RAManimationName; // @animate animation (string) time (float)
float RAManimationTime;

// other globals section
integer iChannel;        // a listen channel, randomly assigned
integer iHandle;         // the handle to it

// NPC controls
vector newDest ;                // tmp storage for the walks
integer iWaitCounter ;          // wait for this number of seconds for the NPC to reach a desrtination
string sNPCName;                // the name of the NPC that may be in world. So we can remove it.
integer bNPC_STOP = FALSE;      // boolean to reuse a listener
integer Stopped = FALSE;        // set to TRUE by link messages so we do not remember them
float  fTimerVal ;              // how long we wait when wandering (calculated)
float NPCEnabled;               // true if the NPC is suppodes to be running

// OS_NPC_CREATOR_OWNED will create an 'owned' NPC that will only respond to osNpc* commands issued from scripts that have the same owner as the one that created the NPC.
// OS_NPC_NOT_OWNED will create an 'unowned' NPC that will respond to any script that has OSSL permissions to call osNpc* commands.
integer  NPCOptions = OS_NPC_CREATOR_OWNED;    // only yhe owner of this box can control this NPC.

integer walkstate = 0;  // helps us reshare the walk state for run, fly and land - a bit of a hack, but it saves RAM. Has to be done this way because some bits of NPCWalkOption are asserted as 0

integer NPCWalkOption = OS_NPC_NO_FLY;   // Some notes for what happens to NPCWalkOption:
// OS_NPC_FLY - Fly the avatar to the given position. The avatar will not land unless the OS_NPC_LAND_AT_TARGET option is also given.
// OS_NPC_NO_FLY - Do not fly to the target. The NPC will attempt to walk to the location. If it's up in the air then the avatar will keep bouncing hopeless until another move target is given or the move is stopped
//OS_NPC_LAND_AT_TARGET - If given and the avatar is flying, then it will land when it reaches the target. If OS_NPC_NO_FLY is given then this option has no effect.
// OS_NPC_RUNNING - if given, NPC avatar moves at running/fast flying speed, otherwise moves at walking/slow flying speed.
string sCommand;  // place to store a command for two-prompted ones
string sParam2;   // place to store a prompt for two-prompted ones
string priPub = "Owner Only";    // Private or Group
key kUserKey;        // the person who is controlling the avatar, not the Owner  
// the command lists
list lCommands;  // commands are stored here
list lNpcCommandList; // Storage for the NPC script.
string npcAction; // Storage for the next action. @cmd=0|hello, this becomes @cmd
string npcParams; // Storage for the param, @cmd=0|hello, this becomes 0|hello

// misc vars
string sNotecard; // commands are stored here temporarily for dumping
vector  vWanderPos; // a place to wander to
string lastANIM ;   // last animation run
// Sensor
integer avatarPresent;   // Sensor sets this flag when people are within Range.

// Coordinate control
vector vInitialPos ; // Vector that will be filled by the script with the initial starting position in region coordinates.
vector vDestPos = ZERO_VECTOR; // Storage for destination position.
string relAbs = "Relative";    // absolute vs relative positioning


// STATES
integer MENU ;             // processing a dialog box state, may be concurrent with STATE
integer STATE;             // state storage
integer NULL = 0;          // the null state
integer MakeNotecard = 1;  // displaying a text box for NPC name
integer RecordPath = 2;    // displaying a path notecard menu
integer NobodyHome = 3;    // looking for an avatar
integer Spawning = 4;      // spawning an avatar
integer Animate = 5;       // animation timer needed
integer Walking = 6;       // Hey! I am walking here!
integer Wander = 7;        // Wandering around neeeds a timer, too
integer WanderHold = 8;    // We reached a wander point
integer DoProcess = 9;     // Set this to make it process a new command
integer Touch = 10;        // Timer is busy sensing something to touch
integer Sit = 11;          // Timer is busy sensing something to sit on
integer Paused = 12;       // Timer is busy pausing

key gNpcKey = NULL_KEY;   // global key storage for the one NPC, to save CPU cycles
list Stack ;              // a command stack from link message input

///////////////////////////////////////////////////////////////////////////
//                              FUNCTIONS                                //
///////////////////////////////////////////////////////////////////////////


TimerEvent(float timesent)
{
    DEBUG("Setting  timer: " + (string) timesent);
    llSetTimerEvent(timesent);
}

// for 4.1 parse a message from a Listen or a Link message
ParseMsg(string str) {
    DEBUG("Command In:" + str);
    if (str=="@go") {
        SetStop(FALSE); // Let's run the notecard
        DEBUG("@go running");
        DoProcessNPCLine();
    } else {
        Stack += [str];    // take anything, the controller will filter away non @ stuff
        if (STATE == NULL)
            DoProcessNPCLine(); // v 4.5 remove wait for STATE == 0
    }
}

SetStop(integer what)
{
    DEBUG("Stopped set to " + (string ) what);
    Stopped = what;
}
// Do* functions are much like states from the old V2 scripts.

///////////////////////  STATELIKE BEHAVIOUR  /////////////
// these StateXX functions need to wait on a timer to fire. 

// Create a NPC
StateSpawn() {
    DEBUG("state spawn " + sNPCName);
     
    NPCEnabled = TRUE; //  in world
    // see if there is already one out there.
    if (NPCKey() != NULL_KEY) {
        DEBUG("Already living");
        return;
    }
    
    STATE = Spawning;        
    list name = llParseString2List(sNPCName, [" "], []);
   
    vector vRezPos = vInitialPos;
    if (relAbs == "Relative"){
        vRezPos += llGetPos();
    }

   // llSay(0,llDumpList2String(name,",")); 

    DEBUG("Rezzing NPC name " +llList2String(name, 0)+ llList2String(name, 1) + " at "+ (string) vRezPos);
    key aKey = osNpcCreate(llList2String(name, 0), llList2String(name, 1), vRezPos, Appearance, NPCOptions);

    SaveKey(aKey); // save in description and global, too
    
    osSetSpeed(aKey,SPEEDMULT);   // 1.9 speed multiplier
    TimerEvent(REZTIME);
    NPCAnimate(STAND);
}

StateSit() {
    DEBUG ("state sit - looking for " + RAMsit);
    STATE=Sit;
    llSensor(RAMsit, "", PASSIVE|ACTIVE|SCRIPTED,  96, PI);
}

StateTouch() {
    DEBUG ("state touch - looking for " + RAMtouch);
    STATE = Touch;
    llSensor(RAMtouch, "", PASSIVE|ACTIVE|SCRIPTED,  96, PI);
}
 
DoStand() {
    DEBUG("state stand");
    osNpcStand(NPCKey());
}


StateAnimate() {
    
    DEBUG("state animate");
    STATE = Animate;
    NPCAnimate(RAManimationName);
    if (RAManimationTime <=0 )    // V 3.4 tweak
        RAManimationTime = 1;
    TimerEvent(RAManimationTime);
}
    
StateWalk() {

    DEBUG("Start Walk");
    //DEBUG("NPCWalkOption = " + (string) NPCWalkOption);
    STATE = Walking;
            
    // walk, fly, run, land
   if (walkstate == 1) {
        NPCAnimate(WALK);
    } else if (walkstate == 2)  {
        llShout(FLIGHT,"flying");
        NPCAnimate(FLY);
    } else if (walkstate == 3) {
        NPCAnimate(RUN);
    } else if (walkstate == 4) {
        NPCAnimate(LAND);
    } 
    newDest = vDestPos ;
    newDest.z += OffsetZ;
        
    // notecard is stored as offsets from this box with relative addressing.  Convert to absolute
    if (relAbs == "Relative"){
        newDest += llGetPos();
    }

    DEBUG("Moveto:" + (string) newDest);
    osNpcMoveToTarget(NPCKey(), newDest, NPCWalkOption);
    iWaitCounter = WAIT;            // wait 60 seconds to get to a destination.
    TimerEvent(TIMER);
}


StateWander(){
    DEBUG("state wander");
    STATE = Wander;
    
    vector point = CirclePoint(RAMwd);
    DEBUG("CirclePoint:" + (string) point);
    vWanderPos = vDestPos + point;
    DEBUG("vWanderPos:" + (string) vWanderPos);

    fTimerVal = WANDERTIME;    // default time to pause after each wander
    if (WANDERRAND)
        fTimerVal = llFrand(WANDERTIME) + 1;    // override, they want random times

    NPCAnimate(WALK);

    DEBUG("Wander to:" + (string) vWanderPos);

    osNpcMoveToTarget(NPCKey(), vWanderPos, NPCWalkOption);
    iWaitCounter = WAIT;            // wait 60 seconds to get to a destination.
    TimerEvent(TIMER);      
}

StateWanderhold() {

    DEBUG("Wander Hold");
    STATE = WanderHold;
       
     // now that we have reached a wander spot, slow the timer down to the desired value
    TimerEvent(fTimerVal);
}


 
DoRotate() {
    DEBUG("@rotate=" + (string) RAMrot); 
    osNpcSetRot(NPCKey(), llEuler2Rot(<0,0,RAMrot> * DEG_TO_RAD));
}  



// @pause=10 will do nothing for 10 seconds
DoPause() {
    STATE = Paused;
    if (RAMPause < 0.1)
        RAMPause = 0.1;
    DEBUG("@pause=" + (string)RAMPause);
    TimerEvent(RAMPause);
}


// @stop makes the NPC stop moving in whatever state it is in.  You have to linkmessage to get moving again
DoStop() {    
    DEBUG("NPC is Stopped");
    STATE   = 0;    // accept commands
    SetStop(TRUE); // Link controlled - we mnust have a @go to continue with notecards
    TimerEvent(0);
    Stack = []; // v3.8
}
    
// @delete removes the NPC forever. Next command starts it up again at the beginning
DoDelete() {
    DEBUG("state delete");
    osNpcRemove(NPCKey());
    SaveKey(NULL_KEY);
    TimerEvent(0);
    Stack = []; // v3.8
    STATE = NULL;    // accept commands
}

// change the appearance of the NPC
DoAppearance(string notecard) {
    DEBUG("state appearance");
    if (llGetInventoryType(notecard) == INVENTORY_NOTECARD){
        DEBUG("Load appearance " + notecard);
        osNpcLoadAppearance(NPCKey(),notecard);
    }
    STATE = NULL;    // accept commands
}

// Change the avatar speed
DoSpeed(string speed) {
    float newspeed = (float) speed;
    if (newspeed > 0.1 && newspeed < 5.0) {// sanity check
        osSetSpeed(NPCKey(),newspeed);
    }
    STATE = NULL;    // accept commands
}

DoTeleport(string params) {
    list Data = llParseString2List(params, ["|"], []);
    string itemName = llList2String(Data, 0);
    vector Dest = (vector) itemName;
    if (Dest != ZERO_VECTOR) {
        if (relAbs == "Relative"){
            Dest += llGetPos();
        }
        osTeleportAgent( NPCKey(), llGetRegionName(), Dest, ZERO_VECTOR );
        
    } else {
        llSay(DEBUG_CHANNEL,"Attempt to teleport to <0,0,0> probably not what you intended: @teleport=<vector>");
    }
    STATE = NULL;    // accept commands
}



DoNewNote (string card) {
    DEBUG("Load Notecard " + card);    
    NPCReadNoteCard(card);
    SetStop(FALSE);
    STATE = NULL;    // accept commands
}
DoAttach(string params) {
    
    list Data = llParseString2List(params, ["|"], []);
    string itemName = llList2String(Data, 0);
    integer attachmentPoint  = (integer) llList2String(Data, 1);
    if (attachmentPoint > 0
        && attachmentPoint < 40
        && llGetInventoryType(itemName) == INVENTORY_OBJECT
       )
    {
        osForceAttachToOtherAvatarFromInventory(NPCKey(),itemName,attachmentPoint);
    }
    STATE = NULL;    // accept commands
}

// This loops over the notecard, processing each command
DoProcessNPCLine() {
    DEBUG("ProcessNPCLine, stopped = " + (string) Stopped);
    
    STATE = DoProcess;
    
    TimerEvent(TIMER);
    
        // auto load a notecard
    if (! llGetListLength(lNpcCommandList)) {
        DEBUG("Read Notecard");
        NPCReadNoteCard(Notecard);
    }

    // look for link messages on the stack
    string next = llList2String(Stack,0);    // lets see if there is anything from a link message
    if (llStringLength(next))
    {
        Stack = llDeleteSubList(Stack,0,0);
        ProcessCmd(next);        //lets do this command instead.
        return;
    }

    // @stop issued?
    if (Stopped) {
        TimerEvent(0);
        DEBUG("Stopped, waiting for input");
        STATE = NULL;
        return;
    }

    // No, we have an @go for liftoff
    next = llList2String(lNpcCommandList, 0);        // get the next command
    DEBUG("Execute:" + next);
    lNpcCommandList = llDeleteSubList(lNpcCommandList, 0, 0);      // delete it
        
    if (llGetListLength(lNpcCommandList) == 0) {
        DEBUG("EOF");
    }
    ProcessCmd(next);
} 



ProcessCmd(string cmd) {

    DEBUG("ProcessCmd:" + cmd);
    if (llGetSubString(cmd, 0, 0) != "@") {
        DEBUG("ignoring");
        TimerEvent(QUICK);  // this is so we do not recurse the stack
        STATE = NULL;
        return;
    }

    list data  = llParseString2List(cmd, ["="], []);
    npcAction = llToLower(llStringTrim(llList2String(data, 0), STRING_TRIM));

    DEBUG("Action:" + npcAction);
    npcParams = llStringTrim(llList2String(data, 1), STRING_TRIM);
    DEBUG("Params:" + npcParams);
    
    @commands;
    if(npcAction == "@spawn") {
        DEBUG("@spawn npcParams ");
        list spawnData = llParseString2List(npcParams, ["|"], []);
        sNPCName =llList2String(spawnData, 0);    // V 1.6 name in RAM

        vInitialPos = (vector) llList2String(spawnData, 1);        
        DEBUG("Coords for NPC at " + (string) vInitialPos);
        StateSpawn();
        return;
    }
    
    
    if(npcAction == "@stop") {
        DoStop();
        STATE = NULL;
        return;
    }
    else if(npcAction == "@goto") {
        DEBUG("goto");
        integer lastIdx = llGetListLength(lNpcCommandList)-1;
        lNpcCommandList = llDeleteSubList(lNpcCommandList, lastIdx, lastIdx);
        // Wind commands till goto label.
        @wind;
        string next1 = llList2String(lNpcCommandList, 0);
        lNpcCommandList = llDeleteSubList(lNpcCommandList, 0, 0);
        lNpcCommandList += next1;
        if(next1 != npcParams) jump wind;
        // Wind the label too.
        next1 = llList2String(lNpcCommandList, 0);
        lNpcCommandList = llDeleteSubList(lNpcCommandList, 0, 0);
        lNpcCommandList += next1;
        // Get next command.
        list data1  = llParseString2List(next1, ["="], []);
        npcAction = llToLower(llStringTrim(llList2String(data1, 0), STRING_TRIM));
        npcParams = llStringTrim(llList2String(data1, 1), STRING_TRIM);
        // Reschedule.
        jump commands;
    }
    else if(npcAction == "@sound") {
        DEBUG("sound");
        llTriggerSound(npcParams,1.0);
    }
    else if(npcAction == "@randsound") {
        DEBUG("@randsound");
        integer N = llGetInventoryNumber(INVENTORY_SOUND);
        integer rand = llCeil(llFrand(N)) -1;    // pick a random sound
        string toPlay = llGetInventoryName(INVENTORY_SOUND,rand);
        llTriggerSound(toPlay,1.0);
    }
    else if(npcAction == "@walk") {
        DEBUG("@walk");
        GetDest(npcParams);
        walkstate = 1;//  walking
        NPCWalkOption = OS_NPC_NO_FLY ;
        StateWalk();
        return;
    }
    else if(npcAction == "@fly") {
        GetDest(npcParams);
        walkstate = 2;//  flying
        NPCWalkOption = OS_NPC_FLY ;
        StateWalk();
        return;
    }
    else if(npcAction == "@run") {
        DEBUG("@run");
        GetDest(npcParams);
        walkstate = 3;//  running
        NPCWalkOption = OS_NPC_NO_FLY | OS_NPC_RUNNING;
        StateWalk();
        return;
    }
    else if(npcAction == "@land") {
        DEBUG("@land");
        GetDest(npcParams);
        walkstate = 4;//  landing
        NPCWalkOption= OS_NPC_FLY | OS_NPC_LAND_AT_TARGET ;
        StateWalk();
        return;
    }
    else if(npcAction == "@say") {
        DEBUG("@say " + npcParams);
        osNpcSay(NPCKey(), 0, npcParams);
    }
    else if(npcAction == "@shout") {
        DEBUG("@shout");
        osNpcShout(NPCKey(),0, npcParams);
    }
    else if(npcAction == "@whisper") {
        DEBUG("@whisper " + npcParams);
        osNpcWhisper(NPCKey(),0, npcParams);
    }
    // speak a command on a channel, so you can open doors and control stuff.
    else if(npcAction == "@cmd") {
        DEBUG("@cmd");
        list dataToSpeak = llParseString2List(npcParams, ["|"], []);
        string channel = llList2String(dataToSpeak,0);
        DEBUG("Channel:"+(string) channel);
        integer iChannel = (integer) channel;
        string stringToSpeak = llList2String(dataToSpeak,1);
        llSay(iChannel, stringToSpeak);
    }
    // stop everything
    else if(npcAction == "@pause") {
        RAMPause = (float) npcParams;
        DoPause();
        return;
    }
    else if(npcAction == "@wander") {
        list wanderData = llParseString2List(npcParams, ["|"], []);
        RAMwd = (float) llList2String(wanderData, 0);
        RAMwc = (integer) llList2String(wanderData, 1);
        vDestPos = osNpcGetPos(NPCKey());        // set the wander start
        DEBUG("Starting at " + (string) vDestPos);
        StateWander();
        return;
    }
    else if(npcAction == "@rotate") {
        RAMrot = (float) npcParams;
        DoRotate();
    }
    else if(npcAction == "@sit") {
        RAMsit= npcParams;
        StateSit();
        return;
    }
    else if(npcAction == "@touch") {
        RAMtouch= npcParams;
        StateTouch();
        return;
    }
    else  if(npcAction == "@stand") {
        DoStand();
    }
    else if(npcAction == "@delete") {
        DoDelete();
        SetStop(TRUE); // Link controlled - we mnust have a @go to continue with notecards
        return;
    }
    else if(npcAction == "@animate") {
        list animateData = llParseString2List(npcParams, ["|"], []);
        RAManimationName = llList2String(animateData, 0);
        RAManimationTime = (float) llList2String(animateData, 1);
        StateAnimate();
        return;
    }
    else if(npcAction == "@appearance" ){
        DoAppearance(npcParams);
    }
    else if (npcAction =="@speed") {
        DoSpeed(npcParams);
    }
    else if (npcAction =="@notecard") {      
        DoNewNote(npcParams);
        Notecard = npcParams;
    }
    else if (npcAction == "@attach")
    {
        DoAttach(npcParams);
    }
    else if (npcAction == "@teleport")
    {
        DoTeleport(npcParams);
    }
    else if (npcAction == "@reset")
    {
        DoDelete();

        llResetScript();
    }

    STATE = NULL;
    TimerEvent(QUICK);  // yeah I know, not possible this fast, we just go as fast as we can go - this is so we do not recurse the stack 
}
 


/////////////////// UTILITY Functions, not state-like //////////////////

// DEBUG(string) will chat a string or display it as hovertext if debug == TRUE
DEBUG(string str) {
    if (debug) llOwnerSay(llGetScriptName() + " : " +  str);                    // Send the owner debug info 
} 

GetDest(string npcParams) {
    list dest = llParseString2List(npcParams, ["<", ",", ">"], []);
    vDestPos.x = llList2Float(dest, 0);
    vDestPos.y = llList2Float(dest, 1);
    vDestPos.z = llList2Float(dest, 2);
}

NPCReadNoteCard(string Note) {
    DEBUG("NPCReadNoteCard");             
    lNpcCommandList = llParseString2List(osGetNotecard(Note), ["\n"], []);
}  

NPCAnimate(string anim)
{
    DEBUG("Start Anim: " + anim);
    if (llGetInventoryType(anim) == INVENTORY_ANIMATION ) {
        
        if (lastANIM != anim) {
            if(llStringLength(lastANIM)) {
                osNpcStopAnimation(NPCKey(), lastANIM);  
            }
            osNpcPlayAnimation(NPCKey(), anim);
            lastANIM = anim;
        }            
    } else {
        llSay(DEBUG_CHANNEL, "No animation named " + anim);
    }
} 

// return a String for the position we are at. Strings used as the caller wants strings
string Pos()
{
    vector where = llGetPos(); // find the box position
   
    where.z +=    OffsetZ;  // use the ground position + an offset 
   
   // if attached the height will be too high by 1/2 the agent size
    if (llGetAttached()) {
        vector size = llGetAgentSize(llGetOwner());   
        float Z = size.z;
        where.z -= Z/2;  
    }
   
    // DEBUG("Pos= " + (string) where);
    return (string) where;
}


vector CirclePoint(float radius) {
    float x = llFrand(radius *2) - radius;        // +/- radius, randomized
    float y = llFrand(radius *2) - radius;        // +/- radius, randomized
    return <x, y, 0>;        // so this should always happen
}


SaveKey(key akey)
{
    DEBUG("Saving Key of " + (string) akey);
    gNpcKey = akey;
}


key NPCKey()
{
    return gNpcKey;   // from cached copy
}


/////////////////// CODE BEGINS //////////////////


default
{
    changed(integer change) {
        if(change & CHANGED_REGION_START) {
            llResetScript();
        }
    }
    
    on_rez(integer start_param)
    {
        llResetScript();
    }

    state_entry() {
        DEBUG("Booted");
        llSetText("",<1,1,1>,1.0);  // clr all hovertext- we may not be using it.

    } 

    timer(){
       // DEBUG("tick");
        
        // if we are spawning, we need time to rez the NPC, then start processing NPC Commands.
        if (Spawning == STATE) {
            STATE = NULL;
            TimerEvent(TIMER);
        }
        // We end aniamtions with a timer
        else if (Animate == STATE){
            NPCAnimate(STAND);
            TimerEvent(TIMER);
        }
        else if (Walking == STATE) {
            if (--iWaitCounter) {
                DEBUG("still walking...");
                if (llVecDist(osNpcGetPos(NPCKey()), newDest) > MAXDIST)  {
                    return;
                }
            }

            DEBUG("At Destination: " + (string) newDest);
            
            // walk, fly, run, land
            if (walkstate == 1) {
                NPCAnimate(STAND);
                NPCWalkOption = OS_NPC_NO_FLY;
            } else if (walkstate == 2)  {
                    // nothing
                } else if (walkstate == 3) {
                     NPCAnimate(STAND);
                     NPCWalkOption = OS_NPC_NO_FLY;
            } else if (walkstate == 4) {
                llShout(FLIGHT,"landing");
                NPCAnimate(STAND);
                NPCWalkOption = OS_NPC_NO_FLY;
            }
        }
        // Wandering timer 
        else if (Wander == STATE) {
            if (--iWaitCounter) {          // wait 60 seconds to get to a destination.
                if (llVecDist(osNpcGetPos(NPCKey()), vWanderPos) > MAXDIST)
                    return;
            }

            // see if wander counter == 0, if so, stop walking, go to stand and process next line
            if(RAMwc == 0) {
                NPCAnimate(STAND);
                DEBUG("Wander ended, calling DoProcessNPCLine");
                STATE = NULL;
                return;
            }
            // one less time to wander around
            RAMwc--;
            NPCAnimate(STAND);
            TimerEvent(TIMER);
            StateWanderhold();
            return;
        }
        // Wandering requires us to re-wander when we reach a destination
        else if (WanderHold == STATE) {
            StateWander();
            return;
        }
        else if (DoProcess == STATE) {
            TimerEvent(QUICK);
        }

        STATE = NULL;

        // We always process a NPC line at end of timer.
        DEBUG("Tick end, calling DoProcessNPCLine");
        DoProcessNPCLine();
    }

    // sensors are used for sitting on prims
    // Neo Cortex: added different states to trigger sit or touch
    sensor(integer num) {
        if (Sit == STATE ) {
            osNpcSit(NPCKey(), llDetectedKey(0), OS_NPC_SIT_NOW);
            DEBUG("Seated, calling DoProcessNPCLine");
            
            STATE = 0;
        } else if (Touch == STATE) {
            osNpcTouch(NPCKey(), llDetectedKey(0), LINK_THIS);
            DEBUG("Touched, calling DoProcessNPCLine");
            STATE = 0;
        }
        DoProcessNPCLine();
    }
    no_sensor(){
        DEBUG ("no target prim located, calling DoProcessNPCLine");
        DoProcessNPCLine();
        STATE = NULL;
    }

    
    link_message(integer sender, integer num, string str, key id){
        if (num == link_Channel)
        {
            if (str == "@reset")
            {
                DoDelete();
                llResetScript();

            } else  {
                ParseMsg(str);
            }
        }
    }
        
} 

// __ END__ 




 