key agent;
integer debug = FALSE;         // set to TRUE or FALSE for debug chat on various actions

vector Sitpos = <0.2,0,-.3>;
vector Sitrot = <0,0,0>;
integer alreadyseated;

DEBUG(string str)
{
    if (debug)
        llOwnerSay( str);                    // Send the owner debug info so you can chase NPCS
}


default
{
    state_entry()
    {
        llSetText("",<1,1,1>,1.0);
        llSetAlpha(1,ALL_SIDES);
        
        rotation Sitrot2 = llEuler2Rot(DEG_TO_RAD * Sitrot);
        llSitTarget(Sitpos, Sitrot2);
    }
 
    on_rez(integer o)
    {
        llResetScript();
    }
    
    changed(integer change)
    {
        if (change & CHANGED_LINK)
        {
            agent = llAvatarOnSitTarget();
            
            if (agent != NULL_KEY && !  osIsNpc(agent) )
            {                
                if (alreadyseated++) 
                    return;

                DEBUG("Avatar Seated");
                llMessageLinked(LINK_SET,0,"Seated",agent);
                llSetText("",<1,1,1>,1.0);
                llSetAlpha(0.0,ALL_SIDES);
            }
            else
            {
                if (! alreadyseated)
                    return;
                
                alreadyseated = FALSE;
                llSetAlpha(1.0,ALL_SIDES);
                llMessageLinked(LINK_SET,0,"Unseated","");
            }
        }
    }
}  

 